/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.vcs.annotations.AnnotationAction;
import oracle.jdeveloper.vcs.annotations.Annotations;
import oracle.jdeveloper.vcs.annotations.AnnotationsCommand;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryUtil;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitLineDetails;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;

public class GITOperationViewAnnotation
extends AnnotationsCommand {
    private static final String COMMAND_ID = "oracle.jdeveloper.git.viewannotation";

    public GITOperationViewAnnotation() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    protected boolean isUnmodifiedStatus(VCSStatus status) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Annotations getAnnotations(URL url) throws Exception {
        File file = new File(url.getPath());
        GitClient client = null;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("ANNOTATE_OPERATION"));
        try {
            client = GITClientAdaptor.getClient(url);
            GitBlameResult result = client.blame(file, null, monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.format("ANNOTATE_ERROR", file.getPath()), monitor.getError());
            }
            if (result == null) {
                Annotations annotations = null;
                return annotations;
            }
            AnnotationsImpl annotationsImpl = new AnnotationsImpl(result, this.isModified(url), client.getUser().getName());
            return annotationsImpl;
        }
        catch (GitException.MissingObjectException moe) {
            GITProfile.getQualifiedLogger(GITOperationViewAnnotation.class.getName()).warning(moe.getMessage());
        }
        catch (GitException ge) {
            GITProfile.getQualifiedLogger(GITOperationViewAnnotation.class.getName()).log(Level.WARNING, "Annotations error " + ge.getMessage());
            throw new GITProcessException(Resource.format("ANNOTATE_ERROR", file.getPath()), ge.getCause().getMessage());
        }
        catch (GITProcessException gitpe) {
            GITProfile.getQualifiedLogger(GITOperationViewAnnotation.class.getName()).warning(gitpe.getMessage());
        }
        finally {
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
        return null;
    }

    private boolean isModified(URL url) throws Exception {
        VCSStatus status = (VCSStatus)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getStatusCacheBridge().get(url);
        return status != VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getStatusInstance("UNCHANGED");
    }

    private class AnnotationsImpl
    extends Annotations {
        private GitBlameResult _delegate;
        private List<String> _revNo = new ArrayList<String>();
        private boolean _modified;
        private String _user;
        private Date _date;
        private Collection<Action> _compareAction;

        private AnnotationsImpl(GitBlameResult blame, boolean modified, String user) {
            this._delegate = blame;
            this._modified = modified;
            this._user = user;
            this.calculateRevNo();
        }

        public Date getChanged(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                if (details != null) {
                    return new Date(details.getRevisionInfo().getCommitTime());
                }
                if (this._modified) {
                    return this.getCurrentDate();
                }
            }
            return null;
        }

        public String getRevision(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                if (details != null) {
                    String revision = details.getRevisionInfo().getRevision();
                    return Integer.toString(this._revNo.indexOf(revision));
                }
                if (this._modified) {
                    return Integer.toString(this._revNo.size());
                }
            }
            return "1";
        }

        public String getExtendedRevision(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                if (details != null) {
                    return details.getRevisionInfo().getRevision();
                }
                if (this._modified) {
                    return Resource.get("ANNOTATE_NOT_COMMIT");
                }
            }
            return null;
        }

        public String getAuthor(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                if (details != null) {
                    return details.getRevisionInfo().getAuthor().getName();
                }
                if (this._modified) {
                    return this._user;
                }
            }
            return Resource.get("ANNOTATION_NOT_AVAILABLE");
        }

        public String getLine(int lineNumber) {
            GitLineDetails details;
            if (lineNumber < this.getLineCount() && (details = this._delegate.getLineDetails(lineNumber)) != null) {
                return details.getContent();
            }
            return null;
        }

        public String getComment(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                if (details != null) {
                    return details.getRevisionInfo().getFullMessage();
                }
                if (this._modified) {
                    Resource.get("ANNOTATE_NOT_COMMIT");
                }
            }
            return null;
        }

        public int getLineCount() {
            return this._delegate.getLineCount();
        }

        public URL getURL() {
            return URLFactory.newFileURL((File)this._delegate.getBlamedFile());
        }

        private void calculateRevNo() {
            HashMap<String, Long> revsTime = new HashMap<String, Long>();
            for (int l = 0; l < this._delegate.getLineCount(); ++l) {
                GitLineDetails details = this._delegate.getLineDetails(l);
                if (details == null || revsTime.containsKey(details.getRevisionInfo().getRevision())) continue;
                revsTime.put(details.getRevisionInfo().getRevision(), details.getRevisionInfo().getCommitTime());
            }
            if (!revsTime.isEmpty()) {
                ArrayList revs = new ArrayList();
                revs.addAll(revsTime.keySet());
                Collections.sort(revs, new ComparatorRevision(revsTime));
                this._revNo.addAll(revs);
            }
        }

        private Date getCurrentDate() {
            if (this._date == null) {
                this._date = new Date(System.currentTimeMillis());
            }
            return this._date;
        }

        public Collection<Action> getCompareActions(int lineNumber) {
            if (this._compareAction == null) {
                this._compareAction = new ArrayList<Action>();
                this._compareAction.add((Action)((Object)new ComparePreviousAction()));
                this._compareAction.add((Action)((Object)new CompareHeadAction()));
            }
            return this._compareAction;
        }

        private class ComparatorRevision
        implements Comparator {
            private Map<String, Long> _revTimes;

            private ComparatorRevision(Map<String, Long> revTimes) {
                this._revTimes = revTimes;
            }

            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    Long t1 = this._revTimes.get((String)o1);
                    Long t2 = this._revTimes.get((String)o2);
                    return t1.compareTo(t2);
                }
                return 0;
            }
        }

        private class ComparePreviousAction
        extends CompareCommonAction {
            private String _firstRevision;

            ComparePreviousAction() {
                super(Resource.get("ANNOTATE_COMPARE_PREVIOUS"));
            }

            public boolean isEnabled() {
                if (this._firstRevision != null) {
                    String rev = (String)this.getValue("Revision");
                    return !this._firstRevision.equals(rev);
                }
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    String prvRevision;
                    String id = (String)this.getValue("Revision");
                    boolean uncommitted = false;
                    if (id.equals(Resource.get("ANNOTATE_NOT_COMMIT"))) {
                        prvRevision = this.getHeadRevision();
                        uncommitted = true;
                    } else {
                        prvRevision = this.getPreviousRevision(id);
                    }
                    if (prvRevision == null) {
                        MessageDialog.information((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("ANNOTATE_NO_PREVIOUS", id), (String)Resource.get("ANNOTATE_NO_PREVIOUS_TITLE"), null);
                        this._firstRevision = id;
                        return;
                    }
                    if (uncommitted) {
                        HistoryEntrySelector lhs = new HistoryEntrySelector(prvRevision);
                        Context historicalContext = new Context(GITOperationViewAnnotation.this.getContext());
                        HistoryContext.setHistoryEntrySelectorLHS((Context)historicalContext, (HistoryEntrySelector)lhs);
                        HistoryManager.getHistoryManager().showHistory(historicalContext);
                    } else {
                        VersionHistoryUtil.openHistoryViewer((URL)AnnotationsImpl.this.getURL(), (String)prvRevision, (String)id);
                    }
                }
                catch (Exception f) {
                    GITProfile.getQualifiedLogger(GITOperationViewAnnotation.class.getName()).warning(f.getMessage());
                    new VCSExceptionHandler().handleException(f);
                }
            }

            private String getPreviousRevision(String revisionId) throws GITProcessException {
                GitClient client = null;
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("ANNOTATE_OPERATION"));
                File file = new File(AnnotationsImpl.this.getURL().getPath());
                try {
                    client = GITClientAdaptor.getClient(AnnotationsImpl.this.getURL());
                    GitRevisionInfo info = client.getPreviousRevision(file, revisionId, monitor);
                    if (monitor.getError() != null) {
                        GITProfile.getQualifiedLogger(GITOperationViewAnnotation.class.getName()).warning(monitor.getError());
                        throw new GITProcessException(Resource.format("ANNOTATE_PREVIOUS_ERROR", file.getPath()), monitor.getError());
                    }
                    String string = info != null ? info.getRevision() : null;
                    return string;
                }
                catch (GitException e) {
                    GITProfile.getQualifiedLogger(GITOperationViewAnnotation.class.getName()).warning(e.getMessage());
                    throw new GITProcessException(Resource.format("ANNOTATE_PREVIOUS_ERROR", file.getPath()), e.getMessage());
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
            }

            @Override
            protected String getDescriptiveMessage(File file) {
                return Resource.format("ANNOTATE_PREVIOUS_ERROR", file.getPath());
            }
        }

        private class CompareHeadAction
        extends CompareCommonAction {
            CompareHeadAction() {
                super(Resource.get("ANNOTATE_COMPARE_HEAD"));
            }

            public boolean isEnabled() {
                String rev = (String)this.getValue("Revision");
                return !rev.equals(Resource.get("ANNOTATE_NOT_COMMIT"));
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    String head = this.getHeadRevision();
                    VersionHistoryUtil.openHistoryViewer((URL)AnnotationsImpl.this.getURL(), (String)((String)this.getValue("Revision")), (String)head);
                }
                catch (Exception f) {
                    new VCSExceptionHandler().handleException(f);
                }
            }

            @Override
            protected String getDescriptiveMessage(File file) {
                return Resource.format("ANNOTATE_NO_HEAD", file.getPath());
            }
        }

        private abstract class CompareCommonAction
        extends AnnotationAction {
            CompareCommonAction(String name) {
                super(name);
            }

            protected String getHeadRevision() throws GITProcessException {
                GitClient client = null;
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("ANNOTATE_OPERATION"));
                File file = new File(AnnotationsImpl.this.getURL().getPath());
                try {
                    SearchCriteria sc = new SearchCriteria();
                    sc.setFiles(new File[]{file});
                    sc.setLimit(1);
                    client = GITClientAdaptor.getClient(AnnotationsImpl.this.getURL());
                    GitRevisionInfo[] info = client.log(sc, false, monitor);
                    if (monitor.getError() != null) {
                        GITProfile.getQualifiedLogger(GITOperationViewAnnotation.class.getName()).warning(monitor.getError());
                        throw new GITProcessException(this.getDescriptiveMessage(file), monitor.getError());
                    }
                    String string = info[0] != null ? info[0].getRevision() : null;
                    return string;
                }
                catch (GitException e) {
                    GITProfile.getQualifiedLogger(GITOperationViewAnnotation.class.getName()).warning(e.getMessage());
                    throw new GITProcessException(this.getDescriptiveMessage(file), e.getMessage());
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
            }

            protected abstract String getDescriptiveMessage(File var1);
        }
    }
}

