/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideri.util.Product;
import oracle.javatools.controls.FileField;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepository;

public class GITOperationInitialize
extends GITAbstractOperation {
    public GITOperationInitialize() {
        super("oracle.jdeveloper.git.init", VCSCommandStyle.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImpl(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        int stat = this.saveDirtyNodesUI(locatables);
        if (stat == 0) {
            URL root = URLFileSystem.getParent((URL)this.getContext().getWorkspace().getURL());
            if (Product.isRaptor() && this.getContext().getElement() != null && this.getContext().getElement() instanceof Locatable && ((Locatable)this.getContext().getElement()).getURL() != null && !URLFileSystem.isDirectoryPath((URL)(root = ((Locatable)this.getContext().getElement()).getURL()))) {
                root = URLFileSystem.getParent((URL)root);
            }
            final GITInitPanel panel = new GITInitPanel(root);
            JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)this.getDialogTitle(), (int)7);
            DialogHeader header = new DialogHeader();
            header.setHeaderDescription(Resource.get("INIT_DIALOG_HINT"));
            dialog.setDialogHeader((Component)header);
            dialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        return;
                    }
                    GITOperationInitialize.this.validateDialog(evt, panel);
                    GITOperationInitialize.this.gitInit(evt, panel);
                }
            });
            HelpSystem.getHelpSystem().registerTopic((JComponent)panel, this.getHelpTopicId());
            try {
                if (dialog.runDialog()) {
                    this.postUpdate(profile, locatables);
                    int n = 0;
                    return n;
                }
            }
            finally {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
        return stat;
    }

    private void gitInit(PropertyChangeEvent evt, GITInitPanel panel) throws PropertyVetoException {
        String path = panel.getRepositoryPath();
        File file = new File(path);
        GitClient client = null;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("INIT_OPERATION"));
        try {
            client = GitRepository.getInstance(file).createClient();
            monitor.setLog(true);
            client.init(monitor);
            if (monitor.getError() != null) {
                MessageDialog.error((Component)panel, (Object)monitor.getError(), (String)Resource.get("INIT_PATH_TITLE"), null);
                throw new PropertyVetoException(monitor.getError(), evt);
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationInitialize.class.getName()).log(Level.SEVERE, e.getMessage());
            MessageDialog.error((Component)panel, (Object)e.getMessage(), (String)Resource.get("INIT_PATH_TITLE"), null);
            throw new PropertyVetoException(e.getMessage(), evt);
        }
        finally {
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
    }

    private void validateDialog(PropertyChangeEvent evt, GITInitPanel panel) throws PropertyVetoException {
        String path = panel.getRepositoryPath();
        if (path.isEmpty()) {
            MessageDialog.error((Component)panel, (Object)Resource.get("INIT_PATH_NOT_EMPTY"), (String)Resource.get("INIT_PATH_TITLE"), null);
            throw new PropertyVetoException(Resource.get("INIT_PATH_NOT_EMPTY"), evt);
        }
        if (!URLFileSystem.exists((URL)URLFactory.newDirURL((String)path))) {
            MessageDialog.error((Component)panel, (Object)Resource.format("INIT_PATH_NOT_EXIST", path), (String)Resource.get("INIT_PATH_TITLE"), null);
            throw new PropertyVetoException(Resource.format("INIT_PATH_NOT_EXIST", path), evt);
        }
    }

    private void postUpdate(VCSProfile profile, Locatable[] locatables) throws Exception {
        CommandState commandState = this.getCommandState(profile, locatables);
        this.postInvoke(profile, commandState);
    }

    private static class GITInitPanel
    extends JPanel {
        private String _rootPath;
        private JLabel _lblRoot = new JLabel();
        private FileField _fldRoot = new FileField();
        private JButton _btnBrowse = new JButton();

        GITInitPanel(URL destUrl) {
            this._rootPath = URLFileSystem.getPlatformPathName((URL)destUrl);
            this.init();
            this.initLayout();
            this.addListener();
        }

        private void init() {
            ResourceUtils.resLabel((JLabel)this._lblRoot, (Component)this._fldRoot, (String)Resource.get("INIT_DIALOG_ROOT"));
            ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)Resource.get("INIT_DIALOG_BROWSE"));
            this._fldRoot.setOnlyDirectories(true);
            this._fldRoot.setText(this._rootPath);
        }

        private void initLayout() {
            Insets ins = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)this._lblRoot, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
            this.add((Component)this._fldRoot, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            this.add((Component)this._btnBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        }

        private void addListener() {
            this._btnBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLChooser urlChooser = DialogUtil.newURLChooser();
                    urlChooser.setSelectionScope(1);
                    urlChooser.setSelectedURL(URLFactory.newDirURL((String)_fldRoot.getText()));
                    int ret = urlChooser.showOpenDialog((Component)this, Resource.get("INIT_BROWSE_TITLE"));
                    if (ret == 0) {
                        URL url = urlChooser.getSelectedURL();
                        _fldRoot.setText(URLFileSystem.getPlatformPathName((URL)url));
                    }
                }
            });
        }

        private Component getDefaultComp() {
            return this._fldRoot;
        }

        private String getRepositoryPath() {
            return this._fldRoot.getText();
        }
    }
}

