/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDockableViewRegistry;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITFileContentProvider;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationDiffBranch
extends GITAbstractOperation {
    public GITOperationDiffBranch() {
        super("oracle.jdeveloper.git.diff-branch", VCSCommandStyle.NORMAL);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        VCSDockableViewRegistry.showDockableView((String)"GIT-Branch-Compare");
        return 0;
    }

    private Collection getBranchChanges(GitClient client, URL root) throws Exception {
        Map<String, GitBranch> branches = GITUtil.getBranches(root);
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
        GitBranch activeBranch = GITUtil.getActiveBranch(branches);
        GitBranch trackingBranch = activeBranch.getTrackedBranch();
        if (trackingBranch == null) {
            return Collections.emptyList();
        }
        SearchCriteria criteria = new SearchCriteria();
        criteria.setRevisionFrom(activeBranch.getName());
        criteria.setRevisionTo(trackingBranch.getName());
        criteria.setFollowRenames(true);
        criteria.setIncludeMerges(false);
        try {
            GitRevisionInfo[] infos;
            GitRevisionInfo excludeInfo = client.log(trackingBranch.getName(), (ProgressMonitor)monitor);
            for (GitRevisionInfo info : infos = client.log(criteria, (ProgressMonitor)monitor)) {
                Map<File, GitRevisionInfo.GitFileInfo> files = info.getModifiedFiles();
                for (File file : files.keySet()) {
                    GitRevisionInfo.GitFileInfo fInfo = files.get(file);
                    System.out.print(file.getName() + " status " + fInfo.getStatus().name());
                    if (fInfo.getOriginalFile() != null) {
                        System.out.println(" original " + fInfo.getOriginalFile());
                        continue;
                    }
                    System.out.println("");
                }
            }
        }
        catch (GitException.MissingObjectException e) {
            GITProfile.getQualifiedLogger(GITFileContentProvider.class.getName()).log(Level.WARNING, e.getMessage());
            throw new Exception(Resource.get("ERROR_NO_TRACKING_BRANCH"));
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITFileContentProvider.class.getName()).log(Level.WARNING, e.getMessage());
            throw new Exception(Resource.get("ERROR_NO_TRACKING_BRANCH"));
        }
        return Collections.emptyList();
    }
}

