/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.changelist;

import java.util.Collection;
import java.util.Iterator;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.git.GITStatusResolver;
import oracle.jdevimpl.vcs.git.changelist.GITAbstractEventQueue;
import org.netbeans.libs.git.GitStatus;

public class GITCandidatesEventQueue
extends GITAbstractEventQueue {
    public GITCandidatesEventQueue(ChangeList changeList) {
        super(changeList);
        changeList.setExcludeDirectories(false);
    }

    protected void filterByStatus(Collection<VCSHashURL> urls) throws Exception {
        super.filterByStatus(urls);
        String value = System.getProperty("git-candidate-include-class");
        if (value == null) {
            Iterator<VCSHashURL> it = urls.iterator();
            while (it.hasNext()) {
                VCSHashURL url = it.next();
                String path = url.getURL().getPath();
                if (!path.endsWith(".class") && !path.contains("/classes/")) continue;
                it.remove();
            }
        }
    }

    @Override
    protected boolean filter(GitStatus status) {
        return GITStatusResolver.isUnversioned(status);
    }

    @Override
    protected URLFilter getURLFilter() {
        return GlobalIgnoreList.getURLFilter();
    }
}

