/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class GITVersionURL {
    public static final String PROTOCOL_NAME = "ide.scm.git";
    private final String _path;
    private final String _version;

    public GITVersionURL(String path, String version) {
        this._path = path;
        this._version = version;
    }

    public GITVersionURL(URL url) {
        this._path = url.getFile().replace('/', File.separatorChar);
        this._version = url.getRef();
    }

    public String getPath() {
        return this._path;
    }

    public String getVersion() {
        return this._version;
    }

    public URL toURL() throws MalformedURLException {
        Object file = this._path.replace(File.separatorChar, '/');
        if (this._version != null && !this._version.equals("")) {
            file = (String)file + "#" + this._version;
        }
        return new URL(PROTOCOL_NAME, "", (String)file);
    }

    public static final URL toURL(String path, String version) throws MalformedURLException {
        return new GITVersionURL(path, version).toURL();
    }
}

