/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUser;

public class GITUserProperties {
    private static final String FILENAME = "git.properties";
    private static final String AUTHOR_NAME = "author-name:";
    private static final String AUTHOR_EMAIL = "author-email:";
    private static final String COMMITER_NAME = "commiter-name:";
    private static final String COMMITER_EMAIL = "commiter-email:";

    private URL getPropertyFile() {
        URL url = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.jdeveloper.git");
        url = URLFactory.newURL((URL)url, (String)FILENAME);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeUsers(List<GITUser> authors, List<GITUser> commiters) {
        Properties prop = new Properties();
        URL url = this.getPropertyFile();
        int limit = this.getLimit();
        for (int a = 0; a < authors.size() && a < limit; ++a) {
            prop.setProperty(AUTHOR_NAME + a, authors.get(a).getName());
            prop.setProperty(AUTHOR_EMAIL + a, authors.get(a).getEmail());
        }
        for (int c = 0; c < commiters.size() && c < limit; ++c) {
            prop.setProperty(COMMITER_NAME + c, commiters.get(c).getName());
            prop.setProperty(COMMITER_EMAIL + c, commiters.get(c).getEmail());
        }
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url));
            prop.storeToXML((OutputStream)bos, "Git Commit Users", IdeUtil.getIdeEncoding());
        }
        catch (IOException e) {
            GITProfile.getQualifiedLogger(GITUserProperties.class.getName()).log(Level.WARNING, "Failed to save Commit Users " + e.getMessage());
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void loadUsers(List<GITUser> authors, List<GITUser> commiters) {
        Properties prop = new Properties();
        URL url = this.getPropertyFile();
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(URLFileSystem.openInputStream((URL)url));
            prop.loadFromXML(bis);
            this.extractUsers(authors, prop, AUTHOR_NAME, AUTHOR_EMAIL);
            this.extractUsers(commiters, prop, COMMITER_NAME, COMMITER_EMAIL);
        }
        catch (IOException e) {
            GITProfile.getQualifiedLogger(GITUserProperties.class.getName()).log(Level.WARNING, "Failed to load Commit Users " + e.getMessage());
        }
    }

    private int getLimit() {
        try {
            return Integer.getInteger(System.getProperty("git-commit-user", "10"));
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITUserProperties.class.getName()).log(Level.WARNING, "Wrong property value " + e.getMessage());
            return 10;
        }
    }

    private void extractUsers(List<GITUser> users, Properties prop, String nameprop, String emailprop) {
        int limit = this.getLimit();
        for (int a = 0; a < limit; ++a) {
            String name = prop.getProperty(nameprop + a);
            String email = prop.getProperty(emailprop + a);
            if (name == null || name.isEmpty()) {
                return;
            }
            users.add(new GITUser(name, email));
        }
    }
}

