/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSQuickDiffReferenceProvider;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;

class GITQuickDiffHeadProvider
extends VCSQuickDiffReferenceProvider {
    private static final String ID = "GitHeadCopy";

    GITQuickDiffHeadProvider() {
        super((VCSExtension)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git"));
    }

    public InputStream openInputStream(URL url) throws IOException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("CatFile");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        File file = new File(url.getPath());
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            boolean stat = client.catFile(file, "HEAD", out, monitor);
            if (!stat) {
                throw new IOException(Resource.format("QUICK_DIFF_FILE_CONTENT", URLFileSystem.getPlatformPathName((URL)url)));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (GitException ex) {
            GITProfile.getQualifiedLogger(GITQuickDiffHeadProvider.class.getName()).warning(ex.getMessage());
            throw new IOException(Resource.format("QUICK_DIFF_FILE_CONTENT", URLFileSystem.getPlatformPathName((URL)url)));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return Resource.get("QUICK_DIFF_HEAD");
    }
}

