/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;

public class GITFileProtocolHelper
extends VCSURLFileSystemHelper {
    public GITFileProtocolHelper() {
        super(URLFileSystem.findHelper((String)"file"), (VCSExtension)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean renameToImpl(URL oldUrl, URL newUrl) {
        GITCommandProgressMonitor monitor;
        GitClient client;
        block13: {
            client = null;
            try {
                client = GITClientAdaptor.getClient(oldUrl);
                if (client == null) {
                    boolean bl = super.renameToImpl(oldUrl, newUrl);
                    return bl;
                }
                File source = new File(oldUrl.toURI());
                File target = new File(newUrl.toURI());
                monitor = new GITCommandProgressMonitor("rename");
                client.rename(source, target, false, monitor);
                if (monitor.getError() == null) break block13;
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITFileProtocolHelper.class.getName()).log(Level.WARNING, e.getMessage());
                boolean bl = super.renameToImpl(oldUrl, newUrl);
                return bl;
            }
            GITProfile.getQualifiedLogger(GITFileProtocolHelper.class.getName()).log(Level.WARNING, monitor.getError());
            return false;
        }
        if (!monitor.hasFinished()) return false;
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        profile.getPolicyStatusCache().clear(oldUrl);
        return true;
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean deleteImpl(URL url) {
        GITCommandProgressMonitor monitor;
        GitClient client;
        block15: {
            client = null;
            try {
                client = GITClientAdaptor.getClient(url);
                if (client == null) {
                    if (URLFileSystem.isDirectoryPath((URL)url)) {
                        URL[] children;
                        for (URL child : children = URLFileSystem.list((URL)url)) {
                            this.deleteImpl(child);
                        }
                    }
                    boolean children = super.deleteImpl(url);
                    return children;
                }
                File[] file = new File[]{new File(url.toURI())};
                monitor = new GITCommandProgressMonitor("remove");
                client.remove(file, false, monitor);
                if (monitor.getError() == null) break block15;
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITFileProtocolHelper.class.getName()).log(Level.WARNING, e.getMessage());
                boolean bl = super.deleteImpl(url);
                return bl;
            }
            GITProfile.getQualifiedLogger(GITFileProtocolHelper.class.getName()).log(Level.WARNING, monitor.getError());
            return false;
        }
        if (!monitor.hasFinished()) return false;
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        profile.getPolicyStatusCache().clear(new URL[]{url}, Depth.INFINITY);
        return true;
        finally {
            if (client != null) {
                client.release();
            }
        }
    }
}

