/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSFile;
import oracle.jdeveloper.vcs.spi.VCSFileContentProvider;
import oracle.jdeveloper.vcs.spi.VCSModifiedFile;
import oracle.jdeveloper.vcs.spi.VCSRevision;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITStatusResolver;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITFileContentProvider
extends VCSFileContentProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRevision(URL url) throws Exception {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            Map<String, GitBranch> branches = GITUtil.getBranches(url);
            GitBranch activeBranch = GITUtil.getActiveBranch(branches);
            GitBranch trackedBranch = activeBranch.getTrackedBranch();
            SearchCriteria criteria = new SearchCriteria();
            File[] files = new File[]{new File(url.getPath())};
            criteria.setRevisionTo(trackedBranch.getName());
            criteria.setLimit(1);
            criteria.setFiles(files);
            criteria.setFollowRenames(true);
            criteria.setIncludeMerges(false);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
            GitRevisionInfo[] info = client.log(criteria, (ProgressMonitor)monitor);
            if (info.length == 0) {
                String string = null;
                return string;
            }
            String string = info[0].getRevision();
            return string;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public Collection<VCSRevision> getRevisions(Map<String, String> params, String fromRevision, int maxCount) throws Exception {
        return Collections.emptySet();
    }

    public Collection<VCSFile> getFiles(Map<String, String> params, String fromRevision, String toRevision) throws Exception {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VCSModifiedFile> getModifiedFiles(Context context, Map<String, String> metadata) throws Exception {
        Locatable[] locs = VCSContextUtils.getContextLocatables((Context)context);
        if (locs == null || locs.length == 0) {
            return Collections.emptyList();
        }
        URL root = GITUtil.getRootContaining(locs[0].getURL());
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(locs[0].getURL());
            Map<File, VCSModifiedFile> modStFiles = this.getWorkingTree(client, root);
            Map<File, FileStatus> branchFiles = this.getBranchChanges(client, root);
            Collection<VCSModifiedFile> collection = this.combineCollections(modStFiles, branchFiles);
            return collection;
        }
        finally {
            if (client != null) {
                // empty if block
            }
            client.release();
        }
    }

    private Map<File, VCSModifiedFile> getWorkingTree(GitClient client, URL root) throws Exception {
        Map<File, GitStatus> statuses;
        File[] files = new File[]{new File(root.getPath())};
        HashMap<File, VCSModifiedFile> mdFiles = new HashMap<File, VCSModifiedFile>();
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("status");
        try {
            statuses = client.getStatus(files, monitor);
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITFileContentProvider.class.getName()).log(Level.WARNING, e.getMessage());
            throw new Exception(Resource.get("ERROR_NO_WORKING_TREE"));
        }
        for (File file : statuses.keySet()) {
            GitStatus gstatus = statuses.get(file);
            if (!this.modifiedStatus(gstatus)) continue;
            VCSModifiedFile mdFile = new VCSModifiedFile();
            VCSStatus status = GITStatusResolver.getVCSStatus(profile, statuses.get(file));
            mdFile.setUrl(URLFactory.newFileURL((String)file.getPath()));
            mdFile.setStatus(status.getOverlay().getToolTipText());
            mdFile.setDeletedFile(GITStatusResolver.isDeleted(gstatus));
            mdFile.setNewFile(GITStatusResolver.isAdded(gstatus) || GITStatusResolver.isAddedModified(gstatus));
            if (gstatus.isRenamed()) {
                mdFile.setPreviousUrl(URLFactory.newFileURL((File)gstatus.getOldPath()));
            }
            mdFiles.put(file, mdFile);
        }
        return mdFiles;
    }

    public InputStream getInputStream(URL url, String revision) throws IOException {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("catFile");
            client.catFile(new File(url.getPath()), revision, out, monitor);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (GitException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private boolean modifiedStatus(GitStatus status) {
        if (GITStatusResolver.isAdded(status)) {
            return true;
        }
        if (GITStatusResolver.isAddedModified(status)) {
            return true;
        }
        if (GITStatusResolver.isDeleted(status)) {
            return true;
        }
        if (GITStatusResolver.isModified(status)) {
            return true;
        }
        if (GITStatusResolver.isPending(status)) {
            return true;
        }
        if (GITStatusResolver.isPendingModified(status)) {
            return true;
        }
        if (GITStatusResolver.isDeleted(status)) {
            return true;
        }
        return status.isRenamed();
    }

    private Map<File, FileStatus> getBranchChanges(GitClient client, URL root) throws Exception {
        Map<String, GitBranch> branches = GITUtil.getBranches(root);
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
        GitBranch activeBranch = GITUtil.getActiveBranch(branches);
        GitBranch trackingBranch = activeBranch.getTrackedBranch();
        if (trackingBranch == null) {
            return Collections.emptyMap();
        }
        SearchCriteria criteria = new SearchCriteria();
        criteria.setRevisionFrom(trackingBranch.getName());
        criteria.setRevisionTo(activeBranch.getName());
        criteria.setFollowRenames(true);
        criteria.setIncludeMerges(false);
        HashMap<File, FileStatus> branchFiles = new HashMap<File, FileStatus>();
        try {
            GitRevisionInfo[] infos;
            GitRevisionInfo excludeInfo = client.log(trackingBranch.getName(), (ProgressMonitor)monitor);
            for (GitRevisionInfo info : infos = client.log(criteria, (ProgressMonitor)monitor)) {
                Map<File, GitRevisionInfo.GitFileInfo> mdFiles;
                if (excludeInfo.getRevision().equals(info.getRevision()) || (mdFiles = info.getModifiedFiles()) == null) continue;
                Map<File, GitRevisionInfo.GitFileInfo> filterFiles = this.removeDelRename(mdFiles);
                for (File file : filterFiles.keySet()) {
                    GitRevisionInfo.GitFileInfo gfInfo = filterFiles.get(file);
                    if (gfInfo.getStatus() == GitRevisionInfo.GitFileInfo.Status.RENAMED) {
                        FileStatus fileRename = this.getRename(branchFiles, file);
                        if (fileRename != null) {
                            fileRename.orginal = gfInfo.getOriginalFile();
                            continue;
                        }
                        FileStatus status = new FileStatus();
                        status.orginal = gfInfo.getOriginalFile();
                        branchFiles.put(file, status);
                        continue;
                    }
                    if (branchFiles.containsKey(file)) continue;
                    FileStatus status = new FileStatus();
                    status.added = gfInfo.getStatus() == GitRevisionInfo.GitFileInfo.Status.ADDED;
                    status.deleted = gfInfo.getStatus() == GitRevisionInfo.GitFileInfo.Status.REMOVED;
                    branchFiles.put(file, status);
                }
            }
        }
        catch (GitException.MissingObjectException e) {
            GITProfile.getQualifiedLogger(GITFileContentProvider.class.getName()).log(Level.WARNING, e.getMessage());
            throw new Exception(Resource.get("ERROR_NO_TRACKING_BRANCH"));
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITFileContentProvider.class.getName()).log(Level.WARNING, e.getMessage());
            throw new Exception(Resource.get("ERROR_NO_TRACKING_BRANCH"));
        }
        return branchFiles;
    }

    private FileStatus getRename(Map<File, FileStatus> branchFiles, File searchFile) {
        for (File file : branchFiles.keySet()) {
            FileStatus status = branchFiles.get(file);
            if (status.orginal == null || !status.orginal.equals(searchFile)) continue;
            return status;
        }
        return null;
    }

    private Collection<VCSModifiedFile> combineCollections(Map<File, VCSModifiedFile> modStFiles, Map<File, FileStatus> branchFiles) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        ArrayList<VCSModifiedFile> modFiles = new ArrayList<VCSModifiedFile>();
        if (branchFiles.isEmpty()) {
            if (modStFiles.isEmpty()) {
                return Collections.emptyList();
            }
            Iterator<File> it = modStFiles.keySet().iterator();
            while (it.hasNext()) {
                modFiles.add(modStFiles.get(it.next()));
            }
            return modFiles;
        }
        for (File file : branchFiles.keySet()) {
            FileStatus status = branchFiles.get(file);
            if (modStFiles.containsKey(file)) {
                VCSModifiedFile modified = modStFiles.get(file);
                modified.setPreviousUrl(URLFactory.newFileURL((File)status.orginal));
                continue;
            }
            VCSModifiedFile mdFile = new VCSModifiedFile();
            mdFile.setUrl(URLFactory.newFileURL((File)file));
            mdFile.setDeletedFile(status.deleted);
            mdFile.setNewFile(status.added);
            if (status.orginal != null) {
                mdFile.setPreviousUrl(URLFactory.newFileURL((File)status.orginal));
            }
            if (status.orginal != null) {
                mdFile.setStatus(profile.getStatusInstance("RENAMED").getOverlay().getToolTipText());
            } else if (status.added) {
                mdFile.setStatus(profile.getStatusInstance("ADDED").getOverlay().getToolTipText());
            } else if (status.deleted) {
                mdFile.setStatus(profile.getStatusInstance("DELETED").getOverlay().getToolTipText());
            } else {
                mdFile.setStatus(profile.getStatusInstance("PENDING").getOverlay().getToolTipText());
            }
            modFiles.add(mdFile);
        }
        Iterator<File> it2 = modStFiles.keySet().iterator();
        while (it2.hasNext()) {
            modFiles.add(modStFiles.get(it2.next()));
        }
        return modFiles;
    }

    private Map<File, GitRevisionInfo.GitFileInfo> removeDelRename(Map<File, GitRevisionInfo.GitFileInfo> mdFiles) {
        HashMap<File, GitRevisionInfo.GitFileInfo> filtered = new HashMap<File, GitRevisionInfo.GitFileInfo>();
        for (File file : mdFiles.keySet()) {
            GitRevisionInfo.GitFileInfo info = mdFiles.get(file);
            if (info.getStatus() == GitRevisionInfo.GitFileInfo.Status.REMOVED && this.containsOriginalFile(mdFiles, info.getFile())) continue;
            filtered.put(file, info);
        }
        return filtered;
    }

    private boolean containsOriginalFile(Map<File, GitRevisionInfo.GitFileInfo> mdFiles, File originalFile) {
        for (File file : mdFiles.keySet()) {
            GitRevisionInfo.GitFileInfo info = mdFiles.get(file);
            if (info.getOriginalFile() == null || !info.getOriginalFile().equals(originalFile)) continue;
            return true;
        }
        return false;
    }

    private static class FileStatus {
        File orginal;
        boolean added = false;
        boolean deleted = false;

        private FileStatus() {
        }
    }
}

