/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.util.logging.Level;
import oracle.ide.config.Preferences;
import oracle.ide.log.LogManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITCommandProgressMonitor
extends ProgressMonitor {
    private String _operation;
    private String _error;
    private boolean _finished = false;
    private boolean _log = false;
    private VCSCancellable _cancel;
    private IndeterminateProgressMonitor _progress;
    private LabelMessage _message;
    private static int THRESHOLD = 500;

    public GITCommandProgressMonitor(String operation) {
        this._operation = operation;
    }

    public void setOperation(String operation) {
        this._operation = operation;
    }

    public void setIndeterminateProgress(IndeterminateProgressMonitor progress) {
        this._progress = progress;
    }

    @Override
    public void beginTask(String taskName, int totalWorkUnits) {
        if (this._progress != null) {
            if (totalWorkUnits <= 10) {
                this._progress.getPanel().setNote(taskName);
            } else {
                this._message = new LabelMessage(taskName, totalWorkUnits, 0);
                this._message.updateMessage(0);
            }
        }
    }

    @Override
    public void updateTaskState(int completed) {
        if (this._message != null) {
            this._message.updateMessage(completed);
        }
    }

    @Override
    public void endTask() {
        this._message = null;
    }

    @Override
    public boolean isCanceled() {
        if (this._cancel != null) {
            return this._cancel.isCancelled();
        }
        return false;
    }

    @Override
    public void started(String command) {
        GITProfile.getQualifiedLogger(this._operation).log(Level.INFO, command);
        this.logMsg(command);
    }

    @Override
    public void finished() {
        this._finished = true;
    }

    @Override
    public void preparationsFailed(String message) {
        GITProfile.getQualifiedLogger(this._operation).log(Level.WARNING, "PreparationsFailed " + message);
    }

    @Override
    public void notifyError(String message) {
        this._error = message;
        this.logMsg(message);
        GITProfile.getQualifiedLogger(this._operation).log(Level.WARNING, "Error " + message);
    }

    @Override
    public void notifyWarning(String message) {
        this.logMsg(message);
        GITProfile.getQualifiedLogger(this._operation).log(Level.WARNING, "Warning " + message);
    }

    @Override
    public void notifyMessage(String message) {
        this.logMsg(message);
    }

    public String getError() {
        return this._error;
    }

    public boolean hasFinished() {
        return this._finished;
    }

    public void setLog(boolean log) {
        this._log = log;
    }

    public void logCompleted() {
        this.logMsg(Resource.format("COMPLETED_OPERATION", this._operation));
        GITProfile.getQualifiedLogger(this._operation).log(Level.INFO, Resource.format("COMPLETED_OPERATION", this._operation));
    }

    private void logMsg(String command) {
        if (this._log && this.isUserLog()) {
            LogManager.getLogManager().getMsgPage().log((Object)command);
            LogManager.getLogManager().getMsgPage().log((Object)"\n");
        }
    }

    private boolean isUserLog() {
        return VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.git").getAutoLogMessages();
    }

    public void setCancellable(VCSCancellable cancel) {
        this._cancel = cancel;
    }

    private class LabelMessage {
        private String _label;
        private int _total;
        private int _completed;
        private long _updTime = 0L;

        LabelMessage(String label, int total, int start) {
            this._label = label;
            this._total = total;
            this._completed = start;
        }

        void updateMessage(int num) {
            this._completed += num;
            if (System.currentTimeMillis() - this._updTime > (long)THRESHOLD) {
                this._updTime = System.currentTimeMillis();
                GITCommandProgressMonitor.this._progress.getPanel().setNote(this.getMessage());
            }
        }

        private String getMessage() {
            StringBuilder sb = new StringBuilder(this._label);
            sb.append(" ");
            sb.append(this._completed);
            sb.append(" / ");
            sb.append(this._total);
            return sb.toString();
        }
    }
}

