/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitClientCallback;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepository;

public class GITClientAdaptor {
    public static GitClient getClient(URL url) throws GitException {
        URL root = GITUtil.getRootContaining(url);
        if (root == null) {
            if (URLFileSystem.exists((URL)URLFactory.newURL((URL)url, (String)".git"))) {
                root = url;
            } else {
                return null;
            }
        }
        GitRepository repos = GitRepository.getInstance(new File(root.getPath()));
        GitClient client = repos.createClient();
        return client;
    }

    public static void setAuthentication(GitClient client, String user, char[] pass, String keyFile, char[] passPhrase) {
        if (user == null) {
            return;
        }
        GITClientCallback callback = new GITClientCallback();
        callback.setUser(user);
        if (pass != null) {
            callback.setPass(pass);
        }
        if (keyFile != null && !keyFile.isEmpty()) {
            callback.setKeyFile(keyFile);
        }
        if (passPhrase != null) {
            callback.setPassPhrase(passPhrase);
        }
        client.setCallback(callback);
    }

    public static void clearAuthentication(GitClient client) {
    }

    private static class GITClientCallback
    extends GitClientCallback {
        private String _user;
        private char[] _pass;
        private String _keyFile;
        private char[] _passPhrase;

        private GITClientCallback() {
        }

        @Override
        public String askQuestion(String uri, String prompt) {
            return null;
        }

        @Override
        public String getUsername(String uri, String prompt) {
            return this._user;
        }

        @Override
        public char[] getPassword(String uri, String prompt) {
            return this._pass;
        }

        @Override
        public char[] getPassphrase(String uri, String prompt) {
            if (this._passPhrase != null) {
                return this._passPhrase;
            }
            EncryptedPanel panel = new EncryptedPanel(Resource.get("AUTH_PASSPHRASE"));
            JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultComp(), (String)Resource.get("PASS_PHRASE"));
            if (dialog.runDialog()) {
                return panel.getPasswd();
            }
            return null;
        }

        @Override
        public Boolean askYesNoQuestion(String uri, String prompt) {
            boolean stat = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)prompt, (String)Resource.get("AUTHENTICATION_TITLE"), null);
            if (stat) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private void setUser(String user) {
            this._user = null;
            if (user.length() != 0) {
                this._user = user;
            }
        }

        private void setPass(char[] pass) {
            this._pass = null;
            if (pass.length != 0) {
                this._pass = pass;
            }
        }

        @Override
        public String getIdentityFile(String string, String string1) {
            return this._keyFile;
        }

        void setKeyFile(String keyFile) {
            this._keyFile = keyFile;
        }

        void setPassPhrase(char[] passPhrase) {
            this._passPhrase = passPhrase;
        }

        private static class EncryptedPanel
        extends JPanel {
            private JLabel _lblPrompt = new JLabel();
            private JPasswordField _fld = new JPasswordField();

            private EncryptedPanel(String mesg) {
                this.init();
                ResourceUtils.resLabel((JLabel)this._lblPrompt, (Component)this._fld, (String)mesg);
            }

            private char[] getPasswd() {
                return this._fld.getPassword();
            }

            private void init() {
                Insets ins = new Insets(5, 5, 5, 5);
                this.setLayout(new GridBagLayout());
                this.add((Component)this._lblPrompt, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
                this.add((Component)this._fld, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            }

            private Component getDefaultComp() {
                return this._fld;
            }
        }
    }
}

