/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl.cache;

import java.util.concurrent.ConcurrentHashMap;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.cache.DescriptorCache;

class ConcurrentDescriptorCache
implements DescriptorCache {
    private final ConcurrentHashMap<String, CollectionDescriptor> cache;
    private final int numberOfEntries;

    public ConcurrentDescriptorCache(int n) {
        this.numberOfEntries = n;
        this.cache = new ConcurrentHashMap(n);
    }

    @Override
    public CollectionDescriptor get(String string) {
        return this.cache.get(string);
    }

    @Override
    public CollectionDescriptor putIfAbsent(CollectionDescriptor collectionDescriptor) {
        if (this.cache.size() > this.numberOfEntries) {
            this.clear();
        }
        return this.cache.putIfAbsent(collectionDescriptor.getName(), collectionDescriptor);
    }

    @Override
    public CollectionDescriptor put(CollectionDescriptor collectionDescriptor) {
        if (this.cache.size() > this.numberOfEntries) {
            this.clear();
        }
        return this.cache.put(collectionDescriptor.getName(), collectionDescriptor);
    }

    @Override
    public boolean containsDescriptor(String string) {
        return this.cache.containsKey(string);
    }

    @Override
    public synchronized void remove(String string) {
        this.cache.remove(string);
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
    }
}

