/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.wizard.PagePanel;

final class EditItemWizard
extends JFrame
implements VetoableChangeListener,
ActionListener {
    private final PaletteController _controller = PaletteController.getInstance();
    private JEWTDialog _dlg;
    private final JPanel _panel = new JPanel();
    private PaletteItemImpl _paletteItem = null;
    private JLabel _itemLbl = new JLabel();
    private JLabel _itemImageLbl = new JLabel();
    private JTextField _itemNameFld = new JTextField();
    private URLTextField _imageFld = new URLTextField();
    private JScrollPane _scrollPane = new JScrollPane();
    private JTextArea _snippetPane = new JTextArea();
    private JButton _browseBtn = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private PalettePage _palettePage;
    private JLabel _previewLbl = new JLabel();
    private JLabel _imageViewLbl = new JLabel();
    private String _defaultIcon = null;
    private JButton _defaultBtn = new JButton();

    public boolean invoke(PalettePage page, PaletteItem item) {
        this._paletteItem = (PaletteItemImpl)item;
        this._palettePage = page;
        this._defaultIcon = this._paletteItem.getItem().getIcon();
        this._dlg = new JEWTDialog((Frame)Ide.getMainWindow(), PaletteArb.getString(66), 7);
        this._dlg.setContent((Component)this._panel);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        this._load();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, "f1_idedpaletteedititem_html");
        return WizardLauncher.runDialog((JDialog)this._dlg);
    }

    public PaletteItem getItem() {
        return this._paletteItem;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
            if (!this.itemIsValid()) {
                throw new PropertyVetoException("no", evt);
            }
            String type = this._palettePage.getType();
            if (type.equals(PagePanel.TYPE_HTML) || type.equals(PagePanel.TYPE_CSS) || type.equals(PagePanel.TYPE_JAVA) || type.equals(PagePanel.TYPE_SNIPPET)) {
                this._paletteItem.setShortLabel(this._itemNameFld.getText());
                this._paletteItem.getItem().setShortLabel(this._itemNameFld.getText());
                this._paletteItem.setIcon(this._imageFld.getText());
                this._paletteItem.getItem().setIcon(this._imageFld.getText());
            } else {
                this._paletteItem.setIcon(this._imageFld.getText());
                this._paletteItem.getItem().setIcon(this._imageFld.getText());
            }
            if (type.equals(PagePanel.TYPE_SNIPPET)) {
                this._paletteItem.getItem().setCodeSnippet(this._snippetPane.getText());
            }
        }
    }

    public boolean itemIsValid() {
        String type = this._palettePage.getType();
        if (this._itemNameFld.getText().trim().length() == 0) {
            MessageDialog.error((Component)this._dlg, (Object)PaletteArb.getString(67), (String)PaletteArb.getString(62), null);
            return false;
        }
        if (type.equals("snippet") && this._snippetPane.getText().trim().length() == 0) {
            MessageDialog.error((Component)this._dlg, (Object)"No snippet text is defined. Please define snippet text.", (String)PaletteArb.getString(62), null);
            this._snippetPane.requestFocus();
            return false;
        }
        Iterator iter = this._palettePage.getChildren();
        while (iter.hasNext()) {
            PaletteItem item = (PaletteItem)iter.next();
            if (!item.getShortLabel().equals(this._itemNameFld.getText()) || item == this._paletteItem) continue;
            MessageDialog.error((Component)this._dlg, (Object)"Cannot have duplicate names. Please assign a unique name for the component.", (String)PaletteArb.getString(62), null);
            return false;
        }
        ImageIcon icon = this._controller.getDefinedImage(this._imageFld.getText());
        if (icon == null || icon.getIconWidth() < 1) {
            MessageDialog.error((Component)this._dlg, (Object)PaletteArb.getString(68), (String)PaletteArb.getString(62), (String)"");
            return false;
        }
        return true;
    }

    public EditItemWizard() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this._itemLbl, (Component)this._itemNameFld, (String)PaletteArb.getString(69));
        ResourceUtils.resLabel((JLabel)this._itemImageLbl, (Component)this._imageFld, (String)PaletteArb.getString(70));
        ResourceUtils.resButton((AbstractButton)this._browseBtn, (String)PaletteArb.getString(72));
        ResourceUtils.resButton((AbstractButton)this._defaultBtn, (String)PaletteArb.getString(73));
        this._panel.setLayout(this.gridBagLayout1);
        this._imageFld.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                EditItemWizard.this.keyHasBeenTyped(e);
            }
        });
        this._scrollPane.setBorder(BorderFactory.createTitledBorder(PaletteArb.getString(71)));
        this._previewLbl.setText(PaletteArb.getString(74));
        this._scrollPane.getViewport().add((Component)this._snippetPane, null);
        this._panel.add((Component)this._browseBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._scrollPane, new GridBagConstraints(0, 4, 5, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._imageFld, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._itemNameFld, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._itemImageLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._itemLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._previewLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._imageViewLbl, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._panel.add((Component)this._defaultBtn, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this._scrollPane.setPreferredSize(new Dimension(300, 200));
        this._browseBtn.addActionListener(this);
        this._defaultBtn.addActionListener(this);
        this._snippetPane.setWrapStyleWord(true);
        this._snippetPane.setLineWrap(true);
        this._defaultBtn.setEnabled(false);
    }

    private void _load() {
        String oldName = this._paletteItem.getShortLabel();
        String imageURL = this._paletteItem.getItem().getIcon();
        String type = this._palettePage.getType();
        String snippet = this._paletteItem.getItem().getCodeSnippet();
        if (PagePanel.TYPE_JSP.equals(type)) {
            this._itemNameFld.setText(oldName);
            this._itemNameFld.setEnabled(false);
            this._imageFld.setText(imageURL);
            this._scrollPane.setVisible(false);
        } else if (PagePanel.TYPE_JAVA.equals(type) || PagePanel.TYPE_CSS.equals(type) || PagePanel.TYPE_HTML.equals(type)) {
            this._itemNameFld.setText(oldName);
            this._imageFld.setText(imageURL);
            this._scrollPane.setVisible(false);
        } else if (PagePanel.TYPE_SNIPPET.equals(type)) {
            this._itemNameFld.setText(oldName);
            this._imageFld.setText(imageURL);
            this._snippetPane.setText(snippet);
        }
        this._imageViewLbl.setIcon(this._paletteItem.getIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._defaultBtn) {
            this._imageFld.setText(this._defaultIcon);
            this._imageViewLbl.setIcon(this._paletteItem.getIcon());
            this._defaultBtn.setEnabled(false);
            this.invalidate();
            this.repaint();
        } else {
            URL url = this.showImageDialog();
            if (url != null) {
                this._imageFld.setURL(url);
                this._defaultBtn.setEnabled(true);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Image image = toolkit.getImage(url);
                if (image != null) {
                    this._imageViewLbl.setText("");
                    ImageIcon i = new ImageIcon(image);
                    this._imageViewLbl.setIcon(i);
                } else {
                    this._imageViewLbl.setText(PaletteArb.getString(68));
                }
                this.invalidate();
                this.repaint();
            }
        }
    }

    private URL showImageDialog() {
        String[] imageFiles = GraphicsUtils.getImageExtensions();
        URLChooser _imageChooser = DialogUtil.newURLChooser((URL)URLFactory.newURL(null));
        _imageChooser.setURLFilter((URLFilter)new DefaultURLFilter("Image Files", imageFiles));
        _imageChooser.setSelectionScope(0);
        int approve = _imageChooser.showOpenDialog((Component)Ide.getMainWindow(), "Select Image Source");
        if (approve == 0) {
            return _imageChooser.getSelectedURL();
        }
        return null;
    }

    private void keyHasBeenTyped(KeyEvent e) {
        this._defaultBtn.setEnabled(true);
    }
}

