/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.help.Helpable;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette.ADAPaletteListener;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteContext;
import oracle.ide.palette.PaletteDisplayableListener;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.palette.PaletteWindow;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.palette.PageNotFoundPanel;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteCommands;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteDockableFactory;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.PaletteUI;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.wizard.NewPageWizard;
import oracle.ideimpl.palette.wizard.PaletteDlg;

public class PaletteWindowImpl
extends PaletteWindow
implements ActiveViewListener,
Observer,
ActionListener,
EditorListener,
ContextMenuListener,
Controller {
    private static PaletteController controller = PaletteController.getInstance();
    private PaletteCommands _commands = new PaletteCommands();
    public static PaletteUI paletteUI = new PaletteUI();
    private PaletteImpl palette = PaletteImpl.getInstance();
    private String title;
    private static ContextMenu contextMenu;
    private static ContextMenuListener contextMenuListener;
    private final int SHOW_PROPERTIES_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette.SHOWPROPERTIES");
    private IdeAction _showPropertiesAction;
    private JMenuItem PROPERTIES_MENU;
    private final int LIST_VIEW_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette.LISTVIEW");
    private IdeAction _listViewAction;
    private JMenuItem LIST_VIEW_MENU;
    private final int HELP_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette.HELP");
    private IdeAction _helpAction;
    private JMenuItem HELP_MENU;
    private final int ADD_ITEM_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette.ADDITEM");
    private IdeAction _addItemAction;
    private JMenuItem ADD_ITEM_MENU;
    private final int REMOVE_ITEM_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette.REMOVEITEM");
    private IdeAction _removeItemAction;
    private JMenuItem REMOVE_ITEM_MENU;
    private final int ADD_PAGE_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette.ADDPAGE");
    private IdeAction _addPageAction;
    private JMenuItem ADD_PAGE_MENU;
    private final int REMOVE_PAGE_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette.REMOVEPAGE");
    private IdeAction _removePageAction;
    private JMenuItem REMOVE_PAGE_MENU;
    private JMenu SORT_BY;
    private JRadioButtonMenuItem SHOW_ALL = new JRadioButtonMenuItem(PaletteArb.getString(102));
    private JRadioButtonMenuItem FILTER_PAGE = new JRadioButtonMenuItem(PaletteArb.getString(103));
    private final ArrayList _list = new ArrayList();
    private final ArrayList _adaList = new ArrayList();
    private PaletteDlg _wizard = null;
    private static boolean OPENED;
    private Object _activeProject = null;
    private Editor _currentEditor = null;
    private static PaletteWindowImpl singleton;

    private PaletteWindowImpl() {
        this.initialize();
        controller.setPaletteWindow(this);
        this.palette.attach(this);
        this.SHOW_ALL.addActionListener(this);
        this.FILTER_PAGE.addActionListener(this);
    }

    public static PaletteWindowImpl getInstance() {
        return singleton;
    }

    public static boolean instanceExists() {
        return singleton != null;
    }

    public Context getContext(EventObject event) {
        Context context = Context.newIdeContext((View)this, (EventObject)event);
        Editor editor = this.getEditor();
        if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null) {
            context.setNode(editor.getContext().getNode());
            context.setProject(editor.getContext().getProject());
            context.setWorkspace(editor.getContext().getWorkspace());
        }
        return context;
    }

    @Override
    public PaletteItem getSelectedItem() {
        return (PaletteItem)this.getContext().getElement();
    }

    public Component getGUI() {
        return paletteUI;
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idecomponentpalette_html");
    }

    public void initialize() {
        this.title = PaletteArb.getString(27);
    }

    public Controller getController() {
        return controller;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = PaletteArb.getString(27);
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTabName() {
        return PaletteArb.getString(28);
    }

    public String getTitleName() {
        return "Component Palette";
    }

    protected Element[] getSelectionFromUI() {
        PaletteItem element = this.palette.getActiveItem();
        if (element == null) {
            return new Element[0];
        }
        return new Element[]{element};
    }

    public void activeViewChanged(ActiveViewEvent e) {
        Editor editor;
        if (e.getNewView() == null) {
            return;
        }
        if (e.getNewView().getContext().getProject() != null) {
            e.getNewView().getContext().getProject().attach((Observer)this);
        }
        if ((editor = this.getEditor()) != null && e.getNewView() instanceof Editor) {
            this._synchronizePalette(editor);
        }
    }

    @Override
    public Editor getEditor() {
        return EditorManager.getEditorManager().getCurrentEditor();
    }

    @Override
    public void showType(String pageType) {
        paletteUI.showType(this.getContext(), pageType, false);
    }

    @Override
    public void reset() {
        controller.reset();
    }

    @Override
    public void checkIfPopulated() {
        if (!this.palette.getHasPopulated()) {
            long t0 = System.currentTimeMillis();
            this.palette.populate();
            paletteUI.initialize();
            Assert.println((String)"  Populated {0} [{1}ms]", (Object)this.palette.getClass().getName(), (Object)Long.toString(System.currentTimeMillis() - t0));
        }
    }

    public void stateChange(int newState) {
        if (newState == 1) {
            this.checkIfPopulated();
            if (!OPENED) {
                this.firePaletteOpened(new PaletteEvent(this.palette, "PALETTE_OPENED"));
                OPENED = true;
                EditorManager.getEditorManager().addEditorListener((EditorListener)this);
                Editor editor = this.getEditor();
                this._syncPalette();
                this._synchronizePalette(editor);
            }
        } else if (newState == 3) {
            this.firePaletteClosed(new PaletteEvent(this.palette, "PALETTE_CLOSED"));
        }
        super.stateChange(newState);
    }

    public void show() {
        this.checkIfPopulated();
        super.show();
        DockStation.getDockStation().activateDockable((Dockable)PaletteDockableFactory.DOCKABLE_PROXY);
        GraphicsUtils.focusComponentOrChild((Component)paletteUI, (boolean)true);
    }

    public void update(Object observed, UpdateMessage change) {
        if (change.getMessageID() == UpdateMessage.PROPERTY_SET && change.containsProperty("technologyScope")) {
            this._forceSynchronization(this.getEditor());
        }
    }

    private final void triggerPopup(Context context) {
        this.getContextMenu().show(context);
    }

    public synchronized ContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ContextMenu();
            contextMenuListener = this;
            contextMenu.addContextMenuListener(contextMenuListener);
        }
        return contextMenu;
    }

    public boolean tryPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.triggerPopup(this.getContext(e));
            return true;
        }
        return false;
    }

    private void changeList() {
        String view = "";
        boolean listView = paletteUI.getActiveIconPanel().getListView();
        view = listView ? "icon" : "list";
        PalettePage page = this.palette.getActivePage();
        paletteUI.getActiveIconPanel().useListView(!listView);
        if (page != null) {
            page.setView(view);
            paletteUI.showPanel(page.getName(), paletteUI.getIfVertical());
        }
        this.palette.setDirty(true);
    }

    public void dockableShown(DockableEvent e) {
        super.dockableShown(e);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
    }

    public void dockableHidden(DockableEvent e) {
        super.dockableHidden(e);
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.FILTER_PAGE) {
            this.setFiltered(true);
        } else if (obj == this.SHOW_ALL) {
            this.setFiltered(false);
        } else {
            paletteUI.comboBoxChanged();
            this.fireSelectionChanged(new PaletteEvent(this.palette, "SELECTION_CHANGED"));
        }
    }

    @Override
    public void addPaletteListener(PaletteListener l) {
        this._list.add(l);
    }

    @Override
    public void removePaletteListener(PaletteListener l) {
        this._list.remove(l);
    }

    @Override
    public void addADAPaletteListener(ADAPaletteListener l) {
        this._adaList.add(l);
    }

    @Override
    public void removeADAPaletteListener(ADAPaletteListener l) {
        this._adaList.remove(l);
    }

    public void firePaletteOpened(PaletteEvent event) {
        for (PaletteListener l : this._list) {
            l.paletteOpened(event);
        }
    }

    public void firePaletteClosed(PaletteEvent event) {
        for (PaletteListener l : this._list) {
            l.paletteClosed(event);
        }
    }

    public void fireSelectionChanged(PaletteEvent event) {
        ArrayList list = (ArrayList)this._list.clone();
        for (PaletteListener l : list) {
            l.selectionChanged(event);
        }
    }

    public void fireItemPressed(PaletteEvent event) {
        ArrayList list = (ArrayList)this._list.clone();
        for (PaletteListener l : list) {
            l.itemPressed(event);
        }
    }

    public void fireItemUnPressed(PaletteEvent event) {
        ArrayList list = (ArrayList)this._list.clone();
        for (PaletteListener l : list) {
            if (!l.getClass().getName().equalsIgnoreCase("oracle.ideimpl.palette2.DeclaredPalette1Pages")) continue;
            l.itemPressed(event);
        }
    }

    public void fireStickyModeActivated(PaletteEvent event) {
        ArrayList list = (ArrayList)this._list.clone();
        for (PaletteListener l : list) {
            l.stickyModeActivated(event);
        }
    }

    public void fireStickyModeDeactivated(PaletteEvent event) {
        ArrayList list = (ArrayList)this._list.clone();
        for (PaletteListener l : list) {
            l.stickyModeDeactivated(event);
        }
    }

    public void fireDefaultCreate(PaletteEvent event) {
        for (ADAPaletteListener l : this._adaList) {
            l.defaultCreate(event);
        }
    }

    private String getSuffix(URL title) {
        String suffix = URLFileSystem.getSuffix((URL)title);
        int period = suffix.lastIndexOf(".");
        if (period != -1) {
            return suffix.substring(period + 1);
        }
        return "";
    }

    public String getEditorSuffix() {
        Editor editor = this.getEditor();
        if (editor != null) {
            URL title = editor.getContext().getNode().getURL();
            return this.getSuffix(title);
        }
        return "";
    }

    public void _syncPalette() {
        this._syncPalette(this.getContext());
    }

    private void _synchronizePalette(Editor editor) {
        if (editor == null || editor.getContext() == null || editor.getContext().getNode() == null) {
            return;
        }
        if (this._currentEditor != null && editor == this._currentEditor) {
            return;
        }
        this._currentEditor = editor;
        URL title = editor.getContext().getNode().getURL();
        Context passOnContext = this.getContext();
        passOnContext.setNode(editor.getContext().getNode());
        passOnContext.setProject(editor.getContext().getProject());
        PaletteContext.setEditor(passOnContext, editor);
        if (title != null) {
            String newSuffix = this.getSuffix(title);
            paletteUI.getPageComboBox().removeActionListener(this);
            paletteUI.showType(passOnContext, newSuffix, false);
            paletteUI.getPageComboBox().addActionListener(this);
        } else {
            paletteUI.showPagesNotFound();
        }
        Iterator iter = PaletteManagerImpl.getInstance().getPaletteDisplayables();
        while (iter.hasNext()) {
            PaletteDisplayableListener listener = (PaletteDisplayableListener)iter.next();
            listener.paletteDisplayed(passOnContext, editor);
        }
    }

    protected void _syncPalette(Context context) {
        boolean newProject = false;
        if (this._activeProject != null && context.getProject() != null && context.getProject() != this._activeProject) {
            newProject = true;
        }
        this._activeProject = context.getProject();
        this._synchronizePalette(this.getEditor());
    }

    private void _forceSynchronization(Editor editor) {
        if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null) {
            URL title = editor.getContext().getNode().getURL();
            if (title != null) {
                String newSuffix = this.getSuffix(title);
                paletteUI.getPageComboBox().removeActionListener(this);
                Context passOnContext = this.getContext();
                passOnContext.setNode(editor.getContext().getNode());
                passOnContext.setProject(editor.getContext().getProject());
                PaletteContext.setEditor(passOnContext, editor);
                paletteUI.showType(passOnContext, newSuffix, false);
                paletteUI.getPageComboBox().addActionListener(this);
            }
        } else {
            paletteUI.showPagesNotFound();
        }
    }

    private void addMnemonics(JMenuItem item, String mnemonic) {
        int mindex = mnemonic.indexOf("&");
        Object text = "";
        if (mindex > -1) {
            text = mnemonic.substring(0, mindex);
            if (mnemonic.length() > mindex) {
                text = (String)text + mnemonic.substring(mindex + 1);
            }
            item.setMnemonic((int)mnemonic.charAt(mindex + 1));
        } else {
            text = mnemonic;
        }
        item.setText((String)text);
        item.setIcon(IdeIcons.getIcon((int)23));
    }

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        this._synchronizePalette(editor);
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        int size;
        if (editor != null && editor == this._currentEditor) {
            this._currentEditor = null;
            paletteUI.clearContext();
        }
        if ((size = EditorManager.getEditorManager().getAllEditors().size()) == 0) {
            paletteUI.showPagesNotFound();
        }
    }

    private void setFiltered(boolean filtered) {
        PaletteUI.FILTERED = filtered;
        this.FILTER_PAGE.setSelected(filtered);
        this.SHOW_ALL.setSelected(!filtered);
        paletteUI.showType(this.getContext(), this.palette.getPageType(), false);
    }

    private void addMnemonics(IdeAction action, String mnemonic) {
        int mindex = mnemonic.indexOf("&");
        action.putValue("MnemonicKey", (Object)mnemonic.charAt(mindex + 1));
    }

    private IdeAction getAction(int commandID, String cmdClass, String name) {
        IdeAction action = IdeAction.get((int)commandID, (String)cmdClass, (String)name);
        action.addController((Controller)this);
        this.addMnemonics(action, name);
        return action;
    }

    public void menuWillShow(ContextMenu popup) {
        this._buildMenu(popup);
        Context context = popup.getContext();
        contextMenu.add((Component)this.PROPERTIES_MENU, MenuConstants.SECTION_COMP_PALETTE_PROPERTIES);
        contextMenu.add((Component)this.ADD_PAGE_MENU, 1.0f);
        Object o = context.getEvent().getSource();
        if (!(o instanceof PageNotFoundPanel)) {
            Palette palette = controller.getPalette();
            PalettePage palettePage = palette.getActivePage();
            boolean isPersistent = palettePage.isPersistent();
            contextMenu.add((Component)this.REMOVE_PAGE_MENU, 1.0f);
            if (isPersistent) {
                contextMenu.add((Component)this.ADD_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
            }
            this.SORT_BY.add(this.SHOW_ALL);
            this.SORT_BY.add(this.FILTER_PAGE);
            if (o instanceof PaletteItemUI) {
                PaletteItemUI pUI;
                Item item;
                if (isPersistent) {
                    contextMenu.add((Component)this.REMOVE_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                }
                if ((item = (pUI = (PaletteItemUI)o).getItem().getItem()) != null) {
                    String help = item.getHelpable();
                    String type = item.getType();
                    if (help != null || type.equals("jsptag") || type.equals("html") || type.equals("css")) {
                        contextMenu.add((Component)this.HELP_MENU, MenuConstants.SECTION_HELP_ABOUT);
                    }
                }
            }
            contextMenu.add((Component)this.LIST_VIEW_MENU, MenuConstants.SECTION_COMP_PALETTE_VIEW);
            contextMenu.add((Component)this.SORT_BY, MenuConstants.SECTION_COMP_PALETTE_VIEW);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action == this._showPropertiesAction) {
            this._wizard = new PaletteDlg();
            this._wizard.invoke(this.getContext());
            return true;
        }
        if (action == this._listViewAction) {
            this.changeList();
        } else if (action == this._addItemAction) {
            this._commands.invokeItemWizard(controller.getPalette().getActivePage());
        } else if (action == this._removeItemAction) {
            this._commands.removePaletteItem();
        } else if (action == this._addPageAction) {
            try {
                new NewPageWizard().invoke(this.getEditorSuffix(), this.getContext(), controller.getList());
            }
            catch (Exception ex) {
                Assert.printStackTrace();
            }
        } else if (action == this._removePageAction) {
            this._commands.removePalettePage();
        } else if (action == this._helpAction) {
            PaletteItemImpl p = (PaletteItemImpl)this.palette.getActiveItem();
            Item items = p.getItem();
            PaletteItem item = this.getSelectedItem();
            if (items.getHelpable() != null) {
                Helpable helpable = null;
                try {
                    helpable = (Helpable)Class.forName(items.getHelpable()).newInstance();
                    if (helpable != null) {
                        HelpSystem.getHelpSystem().showHelp(helpable.getHelpInfo());
                    }
                }
                catch (Exception ex) {
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo(items.getHelpable()));
                }
            } else if (item != null) {
                if (p.getItem().getType().equals("html")) {
                    String tgName = p.getShortLabel().toLowerCase();
                    String helpId = tgName.replaceAll(" ", "");
                    String newHelpId = helpId.replaceAll(":", "");
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo("f1_html" + newHelpId + "_html"));
                } else if (p.getItem().getType().equals("css")) {
                    String name = item.getShortLabel().toLowerCase();
                    String helpId = "f1_css" + name + "_html";
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo(helpId));
                } else {
                    String prefix = item.getClassPath().toLowerCase();
                    String name = item.getShortLabel().toLowerCase();
                    String helpId = "f1_jsp" + prefix + name + "_html";
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo(helpId));
                }
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action == this._removePageAction || action == this._addItemAction || action == this._removeItemAction) {
            Palette palette = controller.getPalette();
            PalettePage palettePage = palette.getActivePage();
            action.setEnabled(palettePage.isPersistent());
            return true;
        }
        return false;
    }

    private void _buildMenu(ContextMenu mgr) {
        if (this.HELP_MENU == null) {
            this._helpAction = this.getAction(this.HELP_COMMAND, null, PaletteArb.getString(59));
            this.HELP_MENU = mgr.createMenuItem((ToggleAction)this._helpAction, MenuConstants.WEIGHT_COMP_PALETTE_HELP);
        }
        if (this.ADD_ITEM_MENU == null) {
            this._addItemAction = this.getAction(this.ADD_ITEM_COMMAND, null, PaletteArb.getString(83));
            this.ADD_ITEM_MENU = mgr.createMenuItem((ToggleAction)this._addItemAction, MenuConstants.WEIGHT_COMP_PALETTE_ADD_COMP);
        }
        if (this.REMOVE_ITEM_MENU == null) {
            this._removeItemAction = this.getAction(this.REMOVE_ITEM_COMMAND, null, PaletteArb.getString(84));
            this.REMOVE_ITEM_MENU = mgr.createMenuItem((ToggleAction)this._removeItemAction, MenuConstants.WEIGHT_COMP_PALETTE_REMOVE_COMP);
        }
        if (this.ADD_PAGE_MENU == null) {
            this._addPageAction = this.getAction(this.ADD_PAGE_COMMAND, null, PaletteArb.getString(85));
            this.ADD_PAGE_MENU = mgr.createMenuItem((ToggleAction)this._addPageAction, 1.0f);
        }
        if (this.REMOVE_PAGE_MENU == null) {
            this._removePageAction = this.getAction(this.REMOVE_PAGE_COMMAND, null, PaletteArb.getString(86));
            this.REMOVE_PAGE_MENU = mgr.createMenuItem((ToggleAction)this._removePageAction, MenuConstants.WEIGHT_COMP_PALETTE_REMOVE_COMP);
        }
        IdeAction.remove((int)this.LIST_VIEW_COMMAND);
        this._listViewAction = !paletteUI.getActiveIconPanel().getListView() ? this.getAction(this.LIST_VIEW_COMMAND, null, PaletteArb.getString(23)) : this.getAction(this.LIST_VIEW_COMMAND, null, PaletteArb.getString(58));
        this.LIST_VIEW_MENU = mgr.createMenuItem((ToggleAction)this._listViewAction, MenuConstants.WEIGHT_COMP_PALETTE_TOGGLE_VIEW);
        if (this.SORT_BY == null) {
            this.SORT_BY = mgr.createSubMenu(PaletteArb.getString(101), Integer.valueOf(0), MenuConstants.WEIGHT_COMP_PALETTE_TOGGLE_VIEW);
            this.addMnemonics(this.SORT_BY, PaletteArb.getString(101));
            this.addMnemonics(this.SHOW_ALL, PaletteArb.getString(102));
            this.addMnemonics(this.FILTER_PAGE, PaletteArb.getString(103));
        }
        if (this.PROPERTIES_MENU == null) {
            this._showPropertiesAction = this.getAction(this.SHOW_PROPERTIES_COMMAND, null, PaletteArb.getString(31));
            this.PROPERTIES_MENU = mgr.createMenuItem((ToggleAction)this._showPropertiesAction, MenuConstants.WEIGHT_COMP_PALETTE_PROPERTIES);
        }
    }

    @Override
    public void addToHistoryHash(String fileType, String pageName) {
        controller.addToHistoryHash(fileType, pageName);
    }

    @Override
    public boolean isPanelActive() {
        try {
            if (paletteUI.getActiveIconPanel() != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public PaletteItem getActivePanelItem() {
        PaletteItem pi;
        try {
            pi = paletteUI.getActivePaletteItemUI().getPaletteItem();
        }
        catch (Exception e) {
            pi = null;
        }
        return pi;
    }

    @Override
    public ArrayList getActivePanelItemList() {
        ArrayList<PaletteItem> paletteItems = new ArrayList<PaletteItem>();
        try {
            ArrayList list = paletteUI.getActiveIconPanel().getIconList();
            for (PaletteItemUI pui : list) {
                PaletteItem item = pui.getPaletteItem();
                paletteItems.add(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paletteItems;
    }

    private void setPanelItem(int action, PaletteItem pi, boolean value) {
        try {
            ArrayList list = paletteUI.getActiveIconPanel().getIconList();
            for (PaletteItemUI pui : list) {
                if (pi != pui.getPaletteItem()) continue;
                if (action == 0) {
                    pui.setSelected(value);
                    continue;
                }
                pui.setEnabled(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setActivePanelItemSelected(PaletteItem pi, boolean selected) {
        this.setPanelItem(0, pi, selected);
    }

    @Override
    public void setActivePanelItemEnabled(PaletteItem pi, boolean enabled) {
        this.setPanelItem(1, pi, enabled);
    }

    static {
        OPENED = false;
        singleton = new PaletteWindowImpl();
    }
}

