/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.util.ArrayList;
import java.util.List;
import javax.ide.extension.BooleanVisitor;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.I18NStringVisitor;
import oracle.ide.IdeHook;
import oracle.ide.palette.Palette;
import oracle.ideimpl.palette.DeferredItem;
import oracle.ideimpl.palette.DeferredPage;

public final class PaletteHandler
extends IdeHook {
    static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "palette");
    private static final ElementName PAGE = PaletteHandler.element((String)"page");
    private static final ElementName NAME = PaletteHandler.element((String)"name");
    private static final ElementName PAGE_EDITOR = PaletteHandler.element((String)"pageEditor");
    private static final ElementName PROJECT_CONFIGURATION = PaletteHandler.element((String)"projectConfiguration");
    private static final ElementName SHOW_FOR_TYPES = PaletteHandler.element((String)"showForTypes");
    private static final ElementName TECHNOLOGY_SCOPE = PaletteHandler.element((String)"technologyScope");
    private static final ElementName TYPE = PaletteHandler.element((String)"type");
    private static final ElementName VIEW = PaletteHandler.element((String)"view");
    private static final ElementName CAN_REMOVE = PaletteHandler.element((String)"canRemove");
    private static final ElementName CAN_SHOW = PaletteHandler.element((String)"canShow");
    private static final ElementName DRAGGABLE = PaletteHandler.element((String)"draggable");
    private static final ElementName PALETTE_CONTEXT = PaletteHandler.element((String)"paletteContext");
    private static final ElementName ITEM = PaletteHandler.element((String)"item");
    private static final ElementName EDITOR = PaletteHandler.element((String)"editor");
    private static final ElementName INFO = PaletteHandler.element((String)"info");
    private static final ElementName ICON = PaletteHandler.element((String)"icon");
    private static final ElementName IS_PERSISTENT = PaletteHandler.element((String)"isPersistent");
    private static final ElementName LIBRARY = PaletteHandler.element((String)"Library");
    private static final ElementName LONG_LABEL = PaletteHandler.element((String)"longLabel");
    private static final ElementName SHORT_LABEL = PaletteHandler.element((String)"shortLabel");
    private static final ElementName HELPABLE = PaletteHandler.element((String)"helpable");
    private static final ElementName WEIGHT = PaletteHandler.element((String)"weight");
    private static final String KEY_PAGE = "Palette-Page";
    private static final String KEY_PALETTE_ITEM = "Palette-Page-Item";
    private static List _pages = new ArrayList();
    private final ElementVisitor _pageVisitor = new PageVisitor();

    public void start(ElementStartContext context) {
        context.registerChildVisitor(PAGE, this._pageVisitor);
    }

    void createPages(Palette palette) {
        for (DeferredPage page : _pages) {
            page.createPage(palette);
        }
        _pages.clear();
    }

    private final class PageVisitor
    extends ElementVisitor {
        private final ElementVisitor _nameVisitor = new NameVisitor();
        private final ElementVisitor _pageEditorVisitor = new PageEditorVisitor();
        private final ElementVisitor _projectConfigVisitor = new ProjectConfigVisitor();
        private final ElementVisitor _showForTypesVisitor = new ShowForTypesVisitor();
        private final ElementVisitor _technologyScopeVisitor = new TechnologyScopeVisitor();
        private final ElementVisitor _typeVisitor = new TypeVisitor();
        private final ElementVisitor _viewVisitor = new ViewVisitor();
        private final ElementVisitor _canRemoveVisitor = new CanRemoveVisitor();
        private final ElementVisitor _canShowVisitor = new CanShowVisitor();
        private final ElementVisitor _draggableVisitor = new DraggableVisitor();
        private final ElementVisitor _paletteContextVisitor = new PaletteContextVisitor();
        private final ElementVisitor _itemVisitor = new ItemVisitor();

        private PageVisitor() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(NAME, this._nameVisitor);
            context.registerChildVisitor(PAGE_EDITOR, this._pageEditorVisitor);
            context.registerChildVisitor(PROJECT_CONFIGURATION, this._projectConfigVisitor);
            context.registerChildVisitor(SHOW_FOR_TYPES, this._showForTypesVisitor);
            context.registerChildVisitor(TECHNOLOGY_SCOPE, this._technologyScopeVisitor);
            context.registerChildVisitor(TYPE, this._typeVisitor);
            context.registerChildVisitor(VIEW, this._viewVisitor);
            context.registerChildVisitor(CAN_REMOVE, this._canRemoveVisitor);
            context.registerChildVisitor(CAN_SHOW, this._canShowVisitor);
            context.registerChildVisitor(DRAGGABLE, this._draggableVisitor);
            context.registerChildVisitor(PALETTE_CONTEXT, this._paletteContextVisitor);
            context.registerChildVisitor(ITEM, this._itemVisitor);
            context.getScopeData().put(PaletteHandler.KEY_PAGE, new DeferredPage());
        }

        public void end(ElementEndContext context) {
            _pages.add(this.getPage((ElementContext)context));
        }

        private DeferredPage getPage(ElementContext context) {
            return (DeferredPage)context.getScopeData().get(PaletteHandler.KEY_PAGE);
        }

        private final class NameVisitor
        extends I18NStringVisitor {
            private NameVisitor() {
            }

            protected void string(ElementContext context, String value) {
                PageVisitor.this.getPage(context).setName(value);
            }
        }

        private final class PageEditorVisitor
        extends ElementVisitor {
            private PageEditorVisitor() {
            }

            public void end(ElementEndContext context) {
                PageVisitor.this.getPage((ElementContext)context).setPageEditor(context.getText().trim());
            }
        }

        private final class ProjectConfigVisitor
        extends ElementVisitor {
            private ProjectConfigVisitor() {
            }

            public void end(ElementEndContext context) {
                PageVisitor.this.getPage((ElementContext)context).setProjectConfiguration(context.getText().trim());
            }
        }

        private final class ShowForTypesVisitor
        extends ElementVisitor {
            private ShowForTypesVisitor() {
            }

            public void end(ElementEndContext context) {
                String text = context.getText();
                if (text == null) {
                    text = "";
                }
                PageVisitor.this.getPage((ElementContext)context).setShowForTypes(text.trim());
            }
        }

        private final class TechnologyScopeVisitor
        extends ElementVisitor {
            private TechnologyScopeVisitor() {
            }

            public void end(ElementEndContext context) {
                PageVisitor.this.getPage((ElementContext)context).setTechnologyScope(context.getText().trim());
            }
        }

        private final class TypeVisitor
        extends ElementVisitor {
            private TypeVisitor() {
            }

            public void end(ElementEndContext context) {
                PageVisitor.this.getPage((ElementContext)context).setType(context.getText().trim());
            }
        }

        private final class ViewVisitor
        extends ElementVisitor {
            private ViewVisitor() {
            }

            public void end(ElementEndContext context) {
                String view = context.getText().trim();
                if (view != null && view.equalsIgnoreCase("list")) {
                    PageVisitor.this.getPage((ElementContext)context).setList(true);
                }
            }
        }

        private final class CanRemoveVisitor
        extends BooleanVisitor {
            private CanRemoveVisitor() {
            }

            protected void booleanValue(ElementContext context, boolean value) {
                PageVisitor.this.getPage(context).setRemove(value);
            }
        }

        private final class CanShowVisitor
        extends BooleanVisitor {
            private CanShowVisitor() {
            }

            protected void booleanValue(ElementContext context, boolean value) {
                PageVisitor.this.getPage(context).setCanShow(value);
            }
        }

        private final class DraggableVisitor
        extends BooleanVisitor {
            private DraggableVisitor() {
            }

            protected void booleanValue(ElementContext context, boolean value) {
                PageVisitor.this.getPage(context).setDraggable(value);
            }
        }

        private final class PaletteContextVisitor
        extends ElementVisitor {
            private PaletteContextVisitor() {
            }

            public void end(ElementEndContext context) {
                PageVisitor.this.getPage((ElementContext)context).setPaletteContext(context.getText().trim());
            }
        }

        public class ItemVisitor
        extends ElementVisitor {
            private final ElementVisitor _canRemoveVisitor = new CanRemoveVisitor();
            private final ElementVisitor _editorVisitor = new EditorVisitor();
            private final ElementVisitor _iconVisitor = new IconVisitor();
            private final ElementVisitor _infoVisitor = new InfoVisitor();
            private final ElementVisitor _isPersistentVisitor = new IsPersistentVisitor();
            private final ElementVisitor _libraryVisitor = new LibraryVisitor();
            private final ElementVisitor _longLabelVisitor = new LongLabelVisitor();
            private final ElementVisitor _shortLabelVisitor = new ShortLabelVisitor();
            private final ElementVisitor _technologyScopeVisitor = new TechnologyScopeVisitor();
            private final ElementVisitor _typeVisitor = new TypeVisitor();
            private final ElementVisitor _helpableVisitor = new HelpableVisitor();
            private final ElementVisitor _weightVisitor = new WeightVisitor();

            public void start(ElementStartContext context) {
                context.registerChildVisitor(CAN_REMOVE, this._canRemoveVisitor);
                context.registerChildVisitor(EDITOR, this._editorVisitor);
                context.registerChildVisitor(ICON, this._iconVisitor);
                context.registerChildVisitor(INFO, this._infoVisitor);
                context.registerChildVisitor(IS_PERSISTENT, this._isPersistentVisitor);
                context.registerChildVisitor(LIBRARY, this._libraryVisitor);
                context.registerChildVisitor(LONG_LABEL, this._longLabelVisitor);
                context.registerChildVisitor(SHORT_LABEL, this._shortLabelVisitor);
                context.registerChildVisitor(TECHNOLOGY_SCOPE, this._technologyScopeVisitor);
                context.registerChildVisitor(TYPE, this._typeVisitor);
                context.registerChildVisitor(HELPABLE, this._helpableVisitor);
                context.registerChildVisitor(WEIGHT, this._weightVisitor);
                DeferredItem item = new DeferredItem();
                context.getScopeData().put(PaletteHandler.KEY_PALETTE_ITEM, item);
            }

            public void end(ElementEndContext context) {
                PageVisitor.this.getPage((ElementContext)context).addItem(this.getItem((ElementContext)context));
            }

            private DeferredItem getItem(ElementContext context) {
                return (DeferredItem)context.getScopeData().get(PaletteHandler.KEY_PALETTE_ITEM);
            }

            private final class CanRemoveVisitor
            extends BooleanVisitor {
                private CanRemoveVisitor() {
                }

                protected void booleanValue(ElementContext context, boolean value) {
                    ItemVisitor.this.getItem(context).setCanRemove(value);
                }
            }

            private final class EditorVisitor
            extends ElementVisitor {
                private EditorVisitor() {
                }

                public void end(ElementEndContext context) {
                    ItemVisitor.this.getItem((ElementContext)context).setEditor(context.getText().trim());
                }
            }

            private final class IconVisitor
            extends ElementVisitor {
                private IconVisitor() {
                }

                public void end(ElementEndContext context) {
                    if (context.getText() != null) {
                        String text = context.getText().trim();
                        if (text.length() > "res:".length() && text.startsWith("res:")) {
                            text = text.substring("res:".length());
                        }
                        ItemVisitor.this.getItem((ElementContext)context).setIcon(text);
                    }
                }
            }

            private final class InfoVisitor
            extends ElementVisitor {
                private InfoVisitor() {
                }

                public void end(ElementEndContext context) {
                    ItemVisitor.this.getItem((ElementContext)context).setInfo(context.getText().trim());
                }
            }

            private final class IsPersistentVisitor
            extends BooleanVisitor {
                private IsPersistentVisitor() {
                }

                public void booleanValue(ElementContext context, boolean value) {
                    ItemVisitor.this.getItem(context).setPersistent(value);
                }
            }

            private final class LibraryVisitor
            extends ElementVisitor {
                private LibraryVisitor() {
                }

                public void end(ElementEndContext context) {
                    ItemVisitor.this.getItem((ElementContext)context).setLibrary(context.getText().trim());
                }
            }

            private final class LongLabelVisitor
            extends I18NStringVisitor {
                private LongLabelVisitor() {
                }

                public void string(ElementContext context, String value) {
                    ItemVisitor.this.getItem(context).setLongLabel(value);
                }
            }

            private final class ShortLabelVisitor
            extends I18NStringVisitor {
                private ShortLabelVisitor() {
                }

                public void string(ElementContext context, String value) {
                    ItemVisitor.this.getItem(context).setShortLabel(value);
                }
            }

            private final class TechnologyScopeVisitor
            extends ElementVisitor {
                private TechnologyScopeVisitor() {
                }

                public void end(ElementEndContext context) {
                    ItemVisitor.this.getItem((ElementContext)context).setTechnologyScope(context.getText().trim());
                }
            }

            private final class TypeVisitor
            extends ElementVisitor {
                private TypeVisitor() {
                }

                public void end(ElementEndContext context) {
                    ItemVisitor.this.getItem((ElementContext)context).setType(context.getText().trim());
                }
            }

            private final class HelpableVisitor
            extends ElementVisitor {
                private HelpableVisitor() {
                }

                public void end(ElementEndContext context) {
                    ItemVisitor.this.getItem((ElementContext)context).setHelpable(context.getText().trim());
                }
            }

            private final class WeightVisitor
            extends ElementVisitor {
                private WeightVisitor() {
                }

                public void end(ElementEndContext context) {
                    ItemVisitor.this.getItem((ElementContext)context).setWeight(context.getText().trim());
                }
            }
        }
    }
}

