/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.ideimpl.palette.PaletteScroll;

public class HorizontalScroll
extends PaletteScroll {
    private JButton _leftBtn;
    private JButton _rightBtn;
    private LeftButtonModel _leftModel = null;
    private RightButtonModel _rightModel = null;

    public HorizontalScroll(JPanel panel, JButton leftBtn, JButton rightBtn) {
        super(panel);
        this._leftBtn = leftBtn;
        this._rightBtn = rightBtn;
        this._leftModel = new LeftButtonModel(this._leftBtn);
        this._rightModel = new RightButtonModel(this._rightBtn);
        leftBtn.addMouseListener(this);
        rightBtn.addMouseListener(this);
        this.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    public void moveLeft() {
    }

    public void moveRight() {
    }

    public boolean canMoveLeft() {
        return false;
    }

    public boolean canMoveRight() {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent p0) {
    }

    @Override
    public void mousePressed(MouseEvent p0) {
        if (p0.getSource() == this._leftBtn) {
            this._leftModel.setPressed(true);
        } else {
            this._rightModel.setPressed(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent p0) {
        this._leftModel.setPressed(false);
        this._rightModel.setPressed(false);
    }

    @Override
    public void mouseEntered(MouseEvent p0) {
    }

    @Override
    public void mouseExited(MouseEvent p0) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent p0) {
        JViewport vp = this.getViewport();
        Rectangle visRect = vp.getViewRect();
        double visWidth = visRect.getWidth();
        Dimension viewDim = vp.getViewSize();
        double totalWidth = viewDim.getWidth();
        Rectangle rect = new Rectangle(0, (int)(viewDim.getHeight() - visRect.getHeight()), (int)visRect.getWidth(), (int)visRect.getHeight());
        vp.scrollRectToVisible(rect);
        if (visRect.getX() == 0.0) {
            this._leftBtn.setVisible(false);
        } else {
            this._leftBtn.setVisible(true);
        }
        this._checkRight();
    }

    private void _checkRight() {
        JViewport vp = this.getViewport();
        Rectangle visRect = vp.getViewRect();
        double width = visRect.getWidth();
        if (width > 0.0) {
            Component[] comps = this.getPanel().getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Rectangle rec = comps[i].getBounds();
                int viewWidth = (int)visRect.getWidth() + visRect.x;
                int recWidth = rec.x + (int)rec.getWidth();
                if (recWidth > viewWidth) {
                    this._rightBtn.setVisible(true);
                    continue;
                }
                this._rightBtn.setVisible(false);
            }
        }
    }

    public class LeftButtonModel
    extends ContinuousButtonModel {
        protected LeftButtonModel(AbstractButton button) {
            super(button, 200, null);
        }

        protected void processPulse() {
            boolean hasShown = false;
            Rectangle scrollToRec = null;
            JViewport vp = HorizontalScroll.this.getViewport();
            Rectangle visRect = vp.getViewRect();
            double width = visRect.getWidth();
            if (width > 0.0) {
                Component[] comps = HorizontalScroll.this.getPanel().getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Rectangle rec = comps[i].getBounds();
                    if (!visRect.contains(rec) && visRect.x > rec.x) {
                        scrollToRec = rec;
                        continue;
                    }
                    if (scrollToRec == null) continue;
                    HorizontalScroll.this.getPanel().scrollRectToVisible(scrollToRec);
                    break;
                }
            }
        }
    }

    public class RightButtonModel
    extends ContinuousButtonModel {
        protected RightButtonModel(AbstractButton button) {
            super(button, 200, null);
        }

        protected void processPulse() {
            boolean hasShown = false;
            JViewport vp = HorizontalScroll.this.getViewport();
            Rectangle visRect = vp.getViewRect();
            double width = visRect.getWidth();
            if (width > 0.0) {
                Component[] comps = HorizontalScroll.this.getPanel().getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Rectangle rec = comps[i].getBounds();
                    int viewWidth = (int)visRect.getWidth() + visRect.x;
                    int recWidth = rec.x + (int)rec.getWidth();
                    if (recWidth <= viewWidth) continue;
                    HorizontalScroll.this.getPanel().scrollRectToVisible(rec);
                    if (i != comps.length - 1) break;
                    HorizontalScroll.this._rightBtn.setVisible(false);
                    break;
                }
            }
        }
    }
}

