/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageLogger {
    private final InteractiveLogger interactiveLogger;
    private final ErrorLogger errorLogger;
    private final TraceLogger traceLogger;

    private static void logDefaultError(String msg, Throwable t) {
        Logger.getLogger(MessageLogger.class.getName()).log(Level.WARNING, msg, t);
    }

    private static void logDefaultTrace(Level level, String msg) {
        Logger.getLogger(MessageLogger.class.getName()).log(level, msg);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MessageLogger source) {
        return new Builder(source);
    }

    private MessageLogger(InteractiveLogger interactiveLogger, ErrorLogger errorLogger, TraceLogger traceLogger) {
        this.interactiveLogger = interactiveLogger;
        this.errorLogger = errorLogger;
        this.traceLogger = traceLogger;
    }

    public void logUserMessage(String msg) {
        this.interactiveLogger.log(msg);
    }

    public void logError(String msg, Throwable t) {
        this.errorLogger.error(msg, t);
    }

    public void traceMessage(Level level, String msg) {
        this.traceLogger.trace(level, msg);
    }

    public void traceMessage(String msg) {
        this.traceMessage(Level.FINE, msg);
    }

    public static class Builder {
        private InteractiveLogger interactiveLogger;
        private ErrorLogger errorLogger;
        private TraceLogger traceLogger;

        private Builder() {
        }

        private Builder(MessageLogger source) {
            this.interactiveLogger = source.interactiveLogger;
            this.errorLogger = source.errorLogger;
            this.traceLogger = source.traceLogger;
        }

        public Builder interactiveLogger(InteractiveLogger interactiveLogger) {
            this.interactiveLogger = interactiveLogger;
            return this;
        }

        public Builder errorLogger(ErrorLogger errorLogger) {
            this.errorLogger = errorLogger;
            return this;
        }

        public Builder traceLogger(TraceLogger traceLogger) {
            this.traceLogger = traceLogger;
            return this;
        }

        public MessageLogger build() {
            if (this.interactiveLogger == null) {
                throw new IllegalStateException("MessageLogger requires InteractiveLogger");
            }
            if (this.errorLogger == null) {
                this.errorLogger = (x$0, x$1) -> MessageLogger.logDefaultError(x$0, x$1);
            }
            if (this.traceLogger == null) {
                this.traceLogger = (x$0, x$1) -> MessageLogger.logDefaultTrace(x$0, x$1);
            }
            return new MessageLogger(this.interactiveLogger, this.errorLogger, this.traceLogger);
        }
    }

    public static interface TraceLogger {
        public void trace(Level var1, String var2);
    }

    public static interface ErrorLogger {
        public void error(String var1, Throwable var2);
    }

    public static interface InteractiveLogger {
        public void log(String var1);
    }
}

