/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.secrets;

import java.io.OutputStream;
import java.util.concurrent.Callable;
import oracle.dbtools.core.secrets.BinarySecretImpl;
import oracle.dbtools.core.secrets.TextSecret;

public interface BinarySecret
extends AutoCloseable {
    public static BinarySecret copyOf(BinarySecret existing) {
        return BinarySecretImpl.copyOf(existing);
    }

    public static void erase(byte[] bytes) {
        if (bytes != null) {
            int length = bytes.length;
            if (length > 0) {
                bytes[0] = 0;
            }
            for (int pos = 1; pos < length; pos += pos) {
                System.arraycopy(bytes, 0, bytes, pos, Math.min(length - pos, pos));
            }
        }
    }

    public static BinarySecret none() {
        return BinarySecretImpl.none();
    }

    default public TextSecret asText() {
        return TextSecret.of(this);
    }

    @Override
    public void close();

    public boolean isPresent();

    default public <T> T map(Mapper<T> mapper) {
        return (T)this.mapOrElse(mapper, () -> null);
    }

    public <T> T map(ProtectedMapper<T> var1, TextSecret var2);

    public <T> T mapOrElse(Mapper<T> var1, Callable<T> var2);

    default public <T> void write(OutputStream outputStream) {
        this.map(plainText -> {
            outputStream.write(plainText);
            return null;
        });
    }

    @FunctionalInterface
    public static interface ProtectedMapper<T> {
        public T apply(byte[] var1, char[] var2) throws Exception;
    }

    @FunctionalInterface
    public static interface Mapper<T> {
        public T apply(byte[] var1) throws Exception;
    }
}

