/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io.file;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;

public class PathEraser {
    public static void erase(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (Stream<Path> children = Files.walk(path, new FileVisitOption[0]);){
                    children.sorted(Comparator.reverseOrder()).forEach(child -> {
                        if (!path.equals(child)) {
                            try {
                                PathEraser.erase(child);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    });
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
            }
            Files.deleteIfExists(path);
        }
    }
}

