/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import oracle.dbtools.core.connections.storage.UnicodeSafeWalletSecrets;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public class ConnectionCredentials {
    public static final String DATABASE_PASSWORD = "dbtools.database.password.base64";
    public static final String PROXY_PASSWORD = "dbtools.proxy.password.base64";
    public static final String LEGACY_PASSWORD = "oracle.security.client.password1";
    private final TextSecret password;
    private final TextSecret proxyPassword;

    private ConnectionCredentials(Builder builder) {
        this.password = builder.password;
        this.proxyPassword = builder.proxyPassword;
    }

    private static TextSecret databasePassword(OracleSecretStore secretStore) throws OracleSecretStoreException {
        UnicodeSafeWalletSecrets secrets = UnicodeSafeWalletSecrets.of(secretStore);
        if (secretStore.containsAlias(DATABASE_PASSWORD)) {
            return secrets.read(DATABASE_PASSWORD);
        }
        if (secretStore.containsAlias(LEGACY_PASSWORD)) {
            char[] text = secretStore.getSecret(LEGACY_PASSWORD);
            return Secrets.instance().of(text, true);
        }
        return TextSecret.none();
    }

    private static TextSecret proxyPassword(OracleSecretStore secretStore) throws OracleSecretStoreException {
        UnicodeSafeWalletSecrets secrets = UnicodeSafeWalletSecrets.of(secretStore);
        if (secretStore.containsAlias(PROXY_PASSWORD)) {
            return secrets.read(PROXY_PASSWORD);
        }
        return TextSecret.none();
    }

    public static ConnectionCredentials of(OracleWallet wallet) {
        try {
            return ConnectionCredentials.of(wallet.getSecretStore());
        }
        catch (IOException | OracleSecretStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ConnectionCredentials of(OracleSecretStore secretStore) {
        try {
            return ConnectionCredentials.builder().password(ConnectionCredentials.databasePassword(secretStore)).proxyPassword(ConnectionCredentials.proxyPassword(secretStore)).build();
        }
        catch (OracleSecretStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder modify() {
        return ConnectionCredentials.builder().password(TextSecret.copyOf(this.password)).proxyPassword(TextSecret.copyOf(this.proxyPassword));
    }

    public OracleWallet write(OracleWallet wallet) {
        try {
            OracleSecretStore secretStore = wallet.getSecretStore();
            this.write(secretStore, DATABASE_PASSWORD, this.password);
            this.write(secretStore, PROXY_PASSWORD, this.proxyPassword);
            this.cleanupLegacyPasswords(secretStore);
            wallet.setSecretStore(secretStore);
        }
        catch (IOException | OracleSecretStoreException e) {
            throw new IllegalStateException(e);
        }
        return wallet;
    }

    private void cleanupLegacyPasswords(OracleSecretStore secretStore) {
        try {
            ArrayList<String> toRemove = new ArrayList<String>();
            Enumeration e = secretStore.internalAliases();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                String key = o.toString();
                if (!key.startsWith("oracle.security.client.connect_string") && !key.startsWith("oracle.security.client.username") && !key.startsWith("oracle.security.client.password")) continue;
                toRemove.add(key);
            }
            for (String remove : toRemove) {
                secretStore.deleteSecret(remove);
            }
        }
        catch (OracleSecretStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private OracleSecretStore write(OracleSecretStore secretStore, String secretAlias, TextSecret password) {
        try {
            UnicodeSafeWalletSecrets secrets = UnicodeSafeWalletSecrets.of(secretStore);
            secrets.write((CharSequence)secretAlias, password);
        }
        catch (OracleSecretStoreException e) {
            throw new IllegalStateException(e);
        }
        return secretStore;
    }

    public TextSecret password() {
        return this.password;
    }

    public TextSecret proxyPassword() {
        return this.proxyPassword;
    }

    public static final class Builder {
        private TextSecret password = TextSecret.none();
        private TextSecret proxyPassword = TextSecret.none();

        private Builder() {
        }

        public Builder password(TextSecret password) {
            this.password = password;
            return this;
        }

        public Builder password(char[] password) {
            return this.password(Secrets.instance().of(password, false));
        }

        public Builder proxyPassword(TextSecret proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder proxyPassword(char[] proxyPassword) {
            return this.proxyPassword(Secrets.instance().of(proxyPassword, false));
        }

        public ConnectionCredentials build() {
            return new ConnectionCredentials(this);
        }
    }
}

