/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.dbtools.connections.api.Connections;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.storage.Wallet;
import oracle.dbtools.core.secrets.TextSecret;

public abstract class ConnectionCloner {
    protected final ConnectionDefinition origin;
    private final Connections.Identifier destName;
    private Path destDir;
    private ConfigurationProperties dbToolsProps;
    private Wallet wallet;

    protected ConnectionCloner(Builder builder) {
        this.origin = builder.origin;
        this.destName = ConnectionIdentifiers.createIdentifier(builder.destName);
    }

    public abstract void handleCopyError(IOException var1);

    public void cloneConnection() throws IOException {
        if (this.origin == null) {
            throw new IllegalStateException("origin not set");
        }
        if (this.destName == null) {
            throw new IllegalStateException("destination not set");
        }
        Connections.Identifier originName = this.origin.getIdentifier();
        ConnectionStorage storage = ConnectionStorage.instance();
        this.destDir = storage.duplicateConnection(originName, this.destName, this::handleCopyError);
        Path dbTools = this.destDir.resolve("dbtools.properties");
        this.dbToolsProps = Files.exists(dbTools, new LinkOption[0]) ? ConnectionStorage.loadProperties(dbTools) : ConfigurationProperties.empty();
        this.dbToolsProps = this.dbToolsProps.withProperty("name", this.destName.toString());
    }

    public void updateUser(String user, boolean promptForPassword) throws IOException {
        this.updateUser(user, TextSecret.none(), promptForPassword);
    }

    protected abstract ConnectionHelper findHelper();

    public void updateUser(String user, TextSecret pwd, boolean promptForPassword) throws IOException {
        ConnectionHelper helper = this.findHelper();
        String spec = helper.getConnectionSpec();
        Path walletFile = this.destDir.resolve("credentials.sso");
        if (Files.exists(walletFile, new LinkOption[0])) {
            this.wallet = Wallet.createWallet(walletFile);
        }
        if (this.wallet == null) {
            this.wallet = Wallet.createEmptyWallet();
        }
        if (user != null) {
            this.dbToolsProps = this.dbToolsProps.withProperty("userName", user);
            if (promptForPassword) {
                String url;
                Credential credential;
                if (!(pwd != null && pwd.isPresent() || (credential = this.getUpdatedPassword(new Credential(user, spec, url = helper.getURL()))) == null)) {
                    pwd = credential.pwd;
                }
            } else {
                pwd = null;
            }
            this.wallet.updateCredentials(spec, user, pwd);
        } else {
            this.dbToolsProps.remove("userName");
            this.wallet.updateCredentials(spec, null, null);
        }
    }

    protected abstract Credential getUpdatedPassword(Credential var1);

    public void saveConnection() throws IOException {
        ConnectionStorage storage = ConnectionStorage.instance();
        if (!this.dbToolsProps.isEmpty()) {
            storage.storeObject(this.destName, "dbtools.properties", this.dbToolsProps, ConnectionDefinition::outputProperties);
        }
        if (this.wallet != null) {
            storage.storeObject(this.destName, "credentials.sso", this.wallet, Wallet::writeWallet);
        }
    }

    protected final class Credential {
        public final String spec;
        public final String url;
        public final String user;
        public final TextSecret pwd;

        private Credential(String user, String spec, String url, TextSecret pwd) {
            this.spec = spec;
            this.url = url;
            this.user = user;
            this.pwd = pwd;
        }

        private Credential(String user, String spec, String url) {
            this(user, spec, url, null);
        }

        public Credential copyOf(String user, TextSecret pwd) {
            return new Credential(user, this.spec, this.url, pwd);
        }
    }

    public static abstract class Builder<T extends Builder, C> {
        private ConnectionDefinition origin;
        private String destName;

        protected Builder() {
        }

        public T origin(ConnectionDefinition origin) {
            this.origin = origin;
            return (T)this;
        }

        public T destination(String dest) {
            this.destName = dest;
            return (T)this;
        }

        protected abstract C build();
    }
}

