/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.core;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.HashMap;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.MessageHandler;

public class CloudStorageUtils {
    public static final String dbms_cloudGetObject = "{? = call C##CLOUD$SERVICE.DBMS_CLOUD.GET_OBJECT(CREDENTIAL_NAME => ?, OBJECT_URI => ?, STARTOFFSET => ?, ENDOFFSET => ?)}";

    public static String getOssTempExtension(String fileUri) {
        String ext = "csv";
        int startIdx = fileUri.lastIndexOf(".");
        if (!(startIdx == -1 || (ext = fileUri.substring(startIdx + 1, fileUri.length())).equalsIgnoreCase("csv") || ext.equalsIgnoreCase("dsv") || ext.equalsIgnoreCase("tsv"))) {
            ext = "csv";
        }
        return ext;
    }

    public static byte[] getSampleBytes(ImportProperties iProps, String fileUri, String credential) throws Exception {
        return CloudStorageUtils.getSampleBytes((String)iProps.get(ImportKeys.CONNECTION_NAME), fileUri, credential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSampleBytes(String connName, String fileUri, String credential) throws Exception {
        long aBlobLength = 0L;
        byte[] aBlobBytes = null;
        Connection conn = null;
        Blob sample = null;
        CallableStatement stmt = null;
        try {
            conn = ConnectionResolver.getUniqueConnection((String)connName);
            if (LockManager.lock((Connection)conn)) {
                stmt = conn.prepareCall(dbms_cloudGetObject);
                stmt.registerOutParameter(1, 2004);
                stmt.setString(2, credential);
                stmt.setString(3, fileUri);
                stmt.setBigDecimal(4, new BigDecimal(0));
                stmt.setBigDecimal(5, new BigDecimal(20000));
                stmt.execute();
                sample = stmt.getBlob(1);
                if (sample != null) {
                    aBlobLength = sample.length();
                    byte[] byArray = aBlobBytes = sample.getBytes(1L, (int)aBlobLength);
                    return byArray;
                }
            }
        }
        finally {
            if (conn != null) {
                LockManager.unlock((Connection)conn);
                conn.close();
            }
        }
        return null;
    }

    public static String getSample(ImportProperties iProps, String fileUri, String credential) {
        return CloudStorageUtils.getSample((String)iProps.get(ImportKeys.CONNECTION_NAME), fileUri, credential);
    }

    public static String getSample(String connName, String fileUri, String credential) {
        return CloudStorageUtils.getSample(connName, fileUri, credential, new Integer(20000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSample(String connName, String fileUri, String credential, Integer limit) {
        String SAMPLE = "select to_clob(dbms_cloud.get_object(:CREDENTIAL, :FILE_URI,0,:LIMIT)) from dual";
        HashMap<String, Object> binds = new HashMap<String, Object>();
        String sample = null;
        Connection conn = null;
        try {
            conn = ConnectionResolver.getConnection((String)connName);
            binds.put("CREDENTIAL", credential);
            binds.put("FILE_URI", fileUri);
            binds.put("LIMIT", limit);
            if (LockManager.lock((Connection)conn)) {
                sample = DBUtil.getInstance((Connection)conn).executeReturnOneCol(SAMPLE, binds);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException((Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (conn != null) {
                LockManager.unlock((Connection)conn);
            }
        }
        if (sample != null && !sample.isEmpty()) {
            return sample;
        }
        MessageHandler.error(null, (String)ImportResources.format("OPEN_FILE_CRED_ERROR", fileUri, credential), (String)ImportResources.getString("OPEN_FILE_ERROR_TITLE"), (String)"OPEN_FILE_NO_DATA");
        return null;
    }
}

