/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract.models;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.util.Logger;

public class ExtractConnectionAccess {
    String _connName = null;
    String _connDisplayName = null;
    String _connUser = null;
    String _dbName = null;
    String _schemaName = null;
    Connection _conn = null;
    boolean _isConnOwner = false;
    boolean _isSpatial = false;
    boolean _isSpatialSet = false;

    public ExtractConnectionAccess(BasicDBObject dbo) {
        this._connName = dbo.getConnectionName();
        this._connDisplayName = ConnectionResolver.getDisplayName((String)this._connName);
        this._dbName = dbo.getCatalog();
        if (this._dbName == null) {
            this._dbName = "";
        }
        this._schemaName = dbo.getSchemaName();
        this._conn = dbo.getConnection();
        try {
            this._connUser = ExtractConnectionAccess.getConnUser(this._conn);
        }
        catch (Exception e) {
            Logger.warn(ExtractConnectionAccess.class, (Throwable)e);
        }
        if (this._connUser != null) {
            this._isConnOwner = !this._connUser.startsWith("\"") ? this._connUser.equalsIgnoreCase(this._schemaName) : this._schemaName.equals(this._connUser.substring(1, this._connUser.length() - 1));
        } else {
            this._connUser = this._schemaName;
        }
    }

    public static String getConnUser(Connection conn) throws SQLException {
        boolean lockAcquired = false;
        String user = "";
        if (conn != null) {
            if (ConnectionResolver.isOracle((Connection)conn)) {
                DBUtil dbutil = DBUtil.getInstance((Connection)conn);
                dbutil.setRaiseError(false);
                String ret = dbutil.executeReturnOneCol("select USER from dual");
                if (ret != null) {
                    return ret;
                }
            }
            if (lockAcquired = LockManager.lock((Connection)conn, (boolean)true)) {
                user = conn.getMetaData().getUserName();
            }
        }
        if (conn != null && lockAcquired) {
            LockManager.unlock((Connection)conn);
        }
        return user;
    }

    public String getConnectionName() {
        return this._connName;
    }

    public String getConnectionDisplayName() {
        return this._connDisplayName;
    }

    public String getConnectionUser() {
        return this._connUser;
    }

    public String getDbName() {
        return this._dbName;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public boolean isConnOwner() {
        return this._isConnOwner;
    }

    public void isSchemaSpatial(boolean isSpatial) {
        this._isSpatialSet = true;
    }

    public boolean isSchemaSpatial() {
        if (!this._isSpatialSet) {
            this.setSchemaSpatial();
        }
        return this._isSpatial;
    }

    public String getKey() {
        return this._connName + (this._dbName.isEmpty() ? "" : "_") + this._dbName + "_" + this._schemaName;
    }

    public String toString() {
        return this._connName;
    }

    public void setSchemaSpatial() {
        if (!this._isSpatialSet) {
            this._isSpatialSet = true;
            DBUtil util = DBUtil.getInstance((Connection)this._conn);
            String sql = "select count(*) from MDSYS.all_sdo_geom_metadata where OWNER = '" + this._schemaName + "'";
            String result = util.executeReturnOneCol(sql);
            SQLException ex = util.getLastException();
            if (ex != null) {
                Logger.warn(ExtractConnectionAccess.class, (Throwable)ex);
                this._isSpatial = false;
            } else {
                this._isSpatial = !result.equals("0");
            }
        }
    }
}

