/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.execute;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.ide.db.execute.DBRequestProcessor;

public class DBRequestProcessorImpl
extends AbstractExecutorService {
    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        if (runnable instanceof DBRequestProcessor.DBRunnable) {
            return new FutureImpl<T>((DBRequestProcessor.DBRunnable)runnable, t);
        }
        throw new IllegalArgumentException("Expected a DBRequestProcessor.DBRunnable");
    }

    @Override
    public void execute(final Runnable runnable) {
        DBRequestProcessor.DBRunnable dBRunnable;
        if (runnable instanceof FutureImpl) {
            dBRunnable = ((FutureImpl)runnable).m_run;
        } else if (runnable instanceof DBRequestProcessor.DBRunnable) {
            dBRunnable = (DBRequestProcessor.DBRunnable)runnable;
        } else {
            throw new IllegalArgumentException("Expected a DBRequestProcessor.DBRunnable");
        }
        RaptorTask raptorTask = new RaptorTask(dBRunnable.getName(), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Object doWork() throws TaskException {
                runnable.run();
                return null;
            }
        };
        raptorTask.setMessage(dBRunnable.getName());
        RaptorTaskManager.getInstance().addTask(raptorTask);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    private class FutureImpl<V>
    extends FutureTask<V> {
        private final DBRequestProcessor.DBRunnable m_run;

        FutureImpl(DBRequestProcessor.DBRunnable dBRunnable, V v) {
            super((Runnable)dBRunnable, v);
            this.m_run = dBRunnable;
        }
    }
}

