/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.table.JTableHeader;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

public abstract class GridContextMenuItem
implements ContextMenuListener,
Controller {
    protected RaptorGridTable _table = null;

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public final void menuWillShow(ContextMenu contextMenu) {
        this.setTableFromContext(contextMenu.getContext());
        if (this._table != null && this.canShow(contextMenu)) {
            this.createAndShowMenu(contextMenu);
        }
    }

    protected abstract boolean canShow(ContextMenu var1);

    protected abstract void createAndShowMenu(ContextMenu var1);

    protected IdeAction createAction(int n, String string, Icon icon) {
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n2 = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        IdeAction ideAction = IdeAction.findOrCreate((int)n, null, (String)string2, null, (Integer)n2, (Icon)icon, null, (boolean)true);
        ideAction.setEnabled(true);
        ideAction.addController((Controller)this);
        return ideAction;
    }

    protected void setTableFromContext(Context context) {
        this._table = RaptorGridTable.getRaptorGridTable(context);
        if (null == context) {
            return;
        }
        if (null == this._table) {
            this.setTableFromEvent(context.getEvent());
        }
    }

    private void setTableFromEvent(EventObject eventObject) {
        if (null == eventObject) {
            return;
        }
        Object object = eventObject.getSource();
        if (object instanceof RaptorGridTable) {
            this._table = (RaptorGridTable)object;
        } else if (object instanceof JTableHeader) {
            if (((JTableHeader)object).getTable() instanceof RaptorGridTable) {
                this._table = (RaptorGridTable)((JTableHeader)object).getTable();
            }
        } else {
            this._table = null;
        }
    }

    public void releaseGrid() {
        this._table = null;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }
}

