/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.StringValuableObject;

public class RaptorGridCell
implements Serializable,
StringValuableObject {
    private Object _cellData;
    private CellDataState _cellDataState;
    private int _cachedDisplayWidth;
    private String _cachedDisplayValue;

    public RaptorGridCell(Object object) {
        this(object, CellDataState.SET);
    }

    public RaptorGridCell() {
        this(null);
    }

    protected RaptorGridCell(Object object, CellDataState cellDataState) {
        this._cellData = object;
        this._cellDataState = cellDataState;
        this._cachedDisplayValue = null;
        this._cachedDisplayWidth = -1;
    }

    public final Object getCellData() {
        return this._cellData;
    }

    public boolean setCellData(Object object) {
        if (ModelUtil.areDifferent((Object)this._cellData, (Object)object)) {
            this.setCellData(object, CellDataState.UPDATED, true);
            return true;
        }
        return false;
    }

    protected void setCellData(Object object, CellDataState cellDataState, boolean bl) {
        this._cellData = object;
        this._cellDataState = cellDataState;
        if (bl) {
            this.clearCachedDisplayData();
        }
    }

    public final CellDataState getCellDataState() {
        return this._cellDataState;
    }

    public void setCellDataState(CellDataState cellDataState) {
        this._cellDataState = cellDataState;
    }

    public final boolean isUpdated() {
        return this._cellDataState == CellDataState.UPDATED;
    }

    public void makeUpdated() {
        this.setCellDataState(CellDataState.UPDATED);
    }

    public void clearCachedDisplayData() {
        this.clearCachedDisplayData(false);
    }

    public void clearCachedDisplayData(boolean bl) {
        if (bl || !bl) {
            this._cachedDisplayValue = null;
            this._cachedDisplayWidth = -1;
        }
    }

    protected final String getCachedDisplayValue() {
        return this._cachedDisplayValue;
    }

    protected final int getCachedDisplayWidth() {
        return this._cachedDisplayWidth;
    }

    public final String getDisplayValue(int n) {
        int n2;
        int n3 = n2 = n < 0 ? Integer.MAX_VALUE : n;
        if (this._cachedDisplayWidth >= 0 && n2 <= this._cachedDisplayWidth) {
            return this._cachedDisplayValue;
        }
        try {
            this._cachedDisplayValue = this.computeDisplayValue(n2);
            this._cachedDisplayWidth = n2;
        }
        catch (Exception exception) {
            this._cachedDisplayWidth = -1;
        }
        return this._cachedDisplayValue;
    }

    protected String computeDisplayValue(int n) {
        try {
            return this.stringValue(null, n, false, 3, null);
        }
        catch (Exception exception) {
            return this._cellData != null ? this._cellData.toString() : null;
        }
    }

    public String stringValue(Connection connection, int n, boolean bl, int n2, FormatType formatType) throws SQLException, IOException {
        return DataTypesUtil.stringValue((Object)this._cellData, (Connection)connection, (int)n, (boolean)bl, (int)n2, (FormatType)formatType);
    }

    public static enum CellDataState {
        SET,
        UPDATED;

    }
}

