/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public final class NumberOverlayIcon {
    private static Map<Icon, Map<Integer, Icon>> icons = new HashMap<Icon, Map<Integer, Icon>>();

    public static Icon getIcon(Icon icon, int n) {
        if (n < 1) {
            return icon;
        }
        Icon icon2 = null;
        Map<Integer, Icon> map = icons.get(icon);
        if (map != null) {
            icon2 = map.get(n);
        }
        if (icon2 == null) {
            icon2 = NumberOverlayIcon.createIcon(icon, n);
        }
        return icon2;
    }

    private static Icon createIcon(Icon icon, int n) {
        NumberIcon numberIcon = new NumberIcon(n);
        IconWithSmallOverlay iconWithSmallOverlay = new IconWithSmallOverlay(icon, numberIcon);
        Map<Integer, Icon> map = icons.get(icon);
        if (map == null) {
            map = new HashMap<Integer, Icon>();
        }
        map.put(n, iconWithSmallOverlay);
        icons.put(icon, map);
        return iconWithSmallOverlay;
    }

    private static class NumberIcon
    implements Icon {
        int number;
        Rectangle2D r;
        Font f;

        private NumberIcon(int n) {
            this.number = n;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.f == null) {
                this.f = new Font("Monospaced", 1, 9);
            }
            graphics2D.setFont(this.f);
            if (this.r == null) {
                this.r = graphics2D.getFontMetrics().getStringBounds("0", graphics2D);
            }
            n = (int)((double)n + ((double)this.getIconWidth() - this.r.getWidth()) / 2.0);
            n2 = (int)((double)n2 + (this.r.getHeight() - 1.0));
            graphics2D.setColor(Color.BLUE);
            graphics2D.drawString(Integer.toString(this.number), n, n2);
            graphics2D.dispose();
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private static class IconWithSmallOverlay
    implements Icon {
        private int m_width = -1;
        private int m_height = -1;
        private int m_originalWidth = -1;
        private Icon m_baseIcon = null;
        private Icon m_overlayIcon = null;

        public IconWithSmallOverlay(Icon icon, Icon icon2) {
            this.m_baseIcon = icon;
            this.m_overlayIcon = icon2;
            this.m_originalWidth = this.m_baseIcon.getIconWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.m_baseIcon.paintIcon(component, graphics, n, n2);
            if (this.m_overlayIcon != null) {
                this.m_overlayIcon.paintIcon(component, graphics, n + this.m_originalWidth, n2 - 4);
            }
        }

        @Override
        public int getIconWidth() {
            if (this.m_width == -1) {
                this.m_width = this.m_originalWidth + this.m_overlayIcon.getIconWidth() + 1;
            }
            return this.m_width;
        }

        @Override
        public int getIconHeight() {
            if (this.m_height == -1) {
                this.m_height = this.m_baseIcon.getIconHeight();
            }
            return this.m_height;
        }
    }
}

