/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.IPinnableTab;
import oracle.dbtools.raptor.controls.IRenameableCustomTab;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.controls.Messages;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.help.HelpSystem;

public class CustomTabbedPane
extends JPanel {
    protected static final long serialVersionUID = 1L;
    protected CustomTab _customTab;
    protected DefaultListModel _model;
    protected JPanel _content;
    protected List<ChangeListener> _listeners = new ArrayList<ChangeListener>();
    protected Map<CustomTabPage, List<ITabCloseListner>> _closeListenters = new HashMap<CustomTabPage, List<ITabCloseListner>>();
    private JMenuItem close_this = null;
    private JMenuItem close_others = null;
    private JMenuItem close_all = null;
    protected DefaultCustomTabPage clickedTab = null;
    private JMenuItem renameMenuItem;
    private CardLayout _cardLayout;

    public CustomTabbedPane() {
        this(new DefaultListModel(), 1);
    }

    public CustomTabbedPane(int n) {
        this(new DefaultListModel(), n);
    }

    private final void createStaticMenuItems() {
        if (this.close_this == null) {
            this.close_this = new JMenuItem(Messages.getString("CustomTabbedPane.1"));
            this.close_this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CustomTabbedPane.this.clickedTab != null) {
                        CustomTabbedPane.this.removeTab(CustomTabbedPane.this.clickedTab);
                    }
                    CustomTabbedPane.this.repaint();
                }
            });
        }
        if (this.close_others == null) {
            this.close_others = new JMenuItem(Messages.getString("CustomTabbedPane.2"));
            this.close_others.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CustomTabbedPane.this.clickedTab != null) {
                        for (int i = CustomTabbedPane.this._model.size() - 1; i >= 0; --i) {
                            Object e = CustomTabbedPane.this._model.getElementAt(i);
                            if (!(e instanceof DefaultCustomTabPage) || e == CustomTabbedPane.this.clickedTab) continue;
                            CustomTabbedPane.this.removeTab((DefaultCustomTabPage)e);
                        }
                    }
                }
            });
        }
        if (this.close_all == null) {
            this.close_all = new JMenuItem(Messages.getString("CustomTabbedPane.3"));
            this.close_all.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomTabbedPane.this.removeAllTabs();
                    CustomTabbedPane.this.repaint();
                }
            });
        }
        if (this.renameMenuItem == null) {
            this.renameMenuItem = new JMenuItem(Messages.getString("CustomTabbedPane.rename"));
            this.renameMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomTabbedPane.this.renameTab(actionEvent.getSource());
                }
            });
        }
    }

    protected void renameTab(Object object) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Messages.getString("CustomTabbedPane.rename"));
        jPanel.add((Component)jLabel, "West");
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._customTab.getPage(this.getSelectedIndex());
        final JTextField jTextField = new JTextField(defaultCustomTabPage.getLabel());
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    Component component = (Component)keyEvent.getSource();
                    Component component2 = null;
                    while (component2 == null) {
                        if (component instanceof JEWTDialog) {
                            component2 = component;
                            continue;
                        }
                        component = component.getParent();
                    }
                    ((JEWTDialog)component2).closeDialog(true);
                    CustomTabbedPane.this.doRename(jTextField.getText());
                }
            }
        });
        jPanel.add((Component)jTextField, "Center");
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_renametab_html");
        UIUtils.showPanelAsDialog(jPanel, Messages.getString("CustomTabbedPane.rename_dialog"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                CustomTabbedPane.this.doRename(jTextField.getText());
            }
        });
    }

    public void renameSelectedPage(String string) {
        this.doRename(this._customTab.getSelectedPage(), string);
    }

    private void doRename(String string) {
        DefaultCustomTabPage defaultCustomTabPage = this.clickedTab;
        this.doRename(this._customTab.searchPage((CustomTabPage)defaultCustomTabPage), string);
    }

    private void doRename(int n, String string) {
        if (n != -1) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._model.get(n);
            Component component = (Component)defaultCustomTabPage.getUserObject();
            if (component != null && component instanceof IRenameableCustomTab) {
                String string2 = this.getUniqueName(n, string);
                this._cardLayout.removeLayoutComponent((Component)defaultCustomTabPage.getUserObject());
                this._cardLayout.addLayoutComponent(string2, (Component)defaultCustomTabPage.getUserObject());
                defaultCustomTabPage.setLabel(string2);
                ((DefaultCustomTabPage)this._model.get(n)).setLabel(string2);
                defaultCustomTabPage.setTooltip(string2);
                ((IRenameableCustomTab)((Object)component)).setTabLabel(string2);
            }
            if (component != null && component instanceof IPinnableTab) {
                ((IPinnableTab)((Object)component)).setPinned(true);
            }
            this.setSelectedIndex(this.getSelectedIndex());
            this._customTab.whenTabChanged();
        }
    }

    protected String getUniqueName(int n, String string) {
        String string2 = string;
        Object object = string2;
        if (n > 0) {
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n2 = 0; n2 < this._model.getSize(); ++n2) {
                DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._model.get(n2);
                Component object2 = (Component)defaultCustomTabPage.getUserObject();
                if (object2 == null || !(object2 instanceof IRenameableCustomTab) || !((IRenameableCustomTab)((Object)object2)).getTabLabel().startsWith(string2)) continue;
                arrayList.add(((IRenameableCustomTab)((Object)object2)).getTabLabel());
            }
            if (arrayList.size() == 0) {
                object = string2;
            } else {
                n2 = 0;
                for (String string3 : arrayList) {
                    int n3 = this.getIndexFromTabLabel(string3);
                    n2 = Math.max(n2, n3);
                }
                object = string2 + " " + (n2 + 1);
            }
        }
        return object;
    }

    private int getIndexFromTabLabel(String string) {
        String string2 = string;
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isDigit(string.charAt(i))) continue;
            if (i + 1 >= string.length()) break;
            string2 = string.substring(i + 1);
            break;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        return n;
    }

    protected JMenuItem[] getStaticMenuItems() {
        return new JMenuItem[]{this.close_this, this.close_others, this.close_all};
    }

    protected JMenuItem[] getDynamicMenuItems(Object object) {
        return null;
    }

    protected void showPopup(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2;
        this.clickedTab = null;
        boolean bl = false;
        for (n2 = n = this._content.getComponentCount() - 1; n2 > -1; --n2) {
            object = (DefaultCustomTabPage)this._model.get(n2);
            if (!object.isCloseable()) continue;
            bl = true;
            break;
        }
        this.close_this.setEnabled(bl);
        this.close_all.setEnabled(bl);
        this.close_others.setEnabled(bl);
        n2 = ((CustomTab)mouseEvent.getSource()).getPageAt(mouseEvent.getPoint());
        this.clickedTab = (DefaultCustomTabPage)((CustomTab)mouseEvent.getSource()).getPage(n2);
        if (this.clickedTab != null) {
            if (!this.clickedTab.isCloseable()) {
                this.close_this.setEnabled(false);
            }
            object = this.clickedTab.getUserObject();
            ContextMenu contextMenu = new ContextMenu();
            UIUtils.addMnemonicSolver(contextMenu);
            JMenuItem[] jMenuItemArray = this.getStaticMenuItems();
            int n3 = jMenuItemArray.length;
            for (int i = 0; i < n3; ++i) {
                JMenuItem jMenuItem = jMenuItemArray[i];
                contextMenu.add((Component)jMenuItem);
            }
            if (this.getActivePanel() instanceof IRenameableCustomTab) {
                contextMenu.add((Component)this.renameMenuItem);
            }
            if ((jMenuItemArray = this.getDynamicMenuItems(object)) != null) {
                for (JMenuItem jMenuItem : jMenuItemArray) {
                    contextMenu.add((Component)jMenuItem);
                }
            }
            JPopupMenu jPopupMenu = (JPopupMenu)contextMenu.getGUI(true);
            jPopupMenu.setLabel(Messages.getString("CustomTabbedPane.0"));
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public CustomTabbedPane(ListModel listModel, int n) {
        this.createStaticMenuItems();
        this._customTab = new CustomTab(listModel, n);
        this._customTab.setCompressible(true);
        this._customTab.setGradientHighlight(true);
        this._customTab.addMouseListener((MouseListener)new UIUtils.MousePopupTriggerListener(){

            @Override
            protected void doPopup(MouseEvent mouseEvent) {
                CustomTabbedPane.this.showPopup(mouseEvent);
            }
        });
        this._model = (DefaultListModel)listModel;
        this._cardLayout = new CardLayout();
        this._content = new JPanel(this._cardLayout);
        this.setLayout(new BorderLayout());
        if (n == 3) {
            this.add((Component)this._customTab, "South");
        } else {
            this.add((Component)this._customTab, "North");
        }
        this.add((Component)this._content, "Center");
        if (this._model.getSize() > 0) {
            for (int i = 0; i < this._model.getSize(); ++i) {
                ((JPanel)((DefaultCustomTabPage)this._model.get(i)).getUserObject()).setVisible(false);
                this._content.add((Component)((JPanel)((DefaultCustomTabPage)this._model.get(i)).getUserObject()), ((DefaultCustomTabPage)this._model.get(i)).getLabel());
            }
            this.setSelectedIndex(0);
        }
        this._customTab.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CustomTabbedPane.this._customTab.getSelectedPage();
                CustomTabbedPane.this.setSelectedIndex(n);
            }
        });
        this._customTab.setCloseAction((Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof DefaultCustomTabPage) {
                    CustomTabbedPane.this.removeTab((DefaultCustomTabPage)actionEvent.getSource());
                }
            }
        });
    }

    public Component getActivePanel() {
        if (this._customTab.getSelectedPage() != -1) {
            return this._content.getComponent(this._customTab.getSelectedPage());
        }
        return null;
    }

    public int getPanelIndex(Component component) {
        int n = this._content.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (this._content.getComponent(i) != component) continue;
            return i;
        }
        return -1;
    }

    public String getSelectedPageLabel() {
        int n = this._customTab.getSelectedPage();
        if (n != -1) {
            return ((DefaultCustomTabPage)this._model.get(n)).getLabel();
        }
        return "";
    }

    public void setSelectedPageLabel(String string) {
        int n = this._customTab.getSelectedPage();
        if (n != -1) {
            ((DefaultCustomTabPage)this._model.get(n)).setLabel(string);
            ((CardLayout)this._content.getLayout()).show(this._content, string);
            ((JComponent)this._content.getComponent(n)).grabFocus();
            this.fireChangeListeners();
            this.repaint();
        }
    }

    public void setSelectedIndex(int n) {
        if (this._customTab.getSelectedPage() != n) {
            this._customTab.setSelectedPage(n);
        }
        String string = ((DefaultCustomTabPage)this._model.get(n)).getLabel();
        ((CardLayout)this._content.getLayout()).show(this._content, string);
        ((JComponent)this._content.getComponent(n)).grabFocus();
        this.fireChangeListeners();
    }

    public void setEnabledAt(int n, boolean bl) {
        String string = ((DefaultCustomTabPage)this._model.get(n)).getLabel();
        ((CardLayout)this._content.getLayout()).show(this._content, string);
        JComponent jComponent = (JComponent)this._content.getComponent(n);
        jComponent.setEnabled(bl);
        this.fireChangeListeners();
    }

    public void removeSelectedTab() {
        this._model.removeElementAt(this.getSelectedIndex());
        try {
            if (this._content.getComponentCount() == 1) {
                this._content.removeAll();
            } else {
                this._content.remove(this.getSelectedIndex() + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireChangeListeners();
    }

    public void removeTab(DefaultCustomTabPage defaultCustomTabPage) {
        List<ITabCloseListner> list;
        this._customTab.removePage((CustomTabPage)defaultCustomTabPage);
        this._model.removeElement(defaultCustomTabPage);
        if (defaultCustomTabPage.getUserObject() instanceof Component) {
            this._content.remove((Component)defaultCustomTabPage.getUserObject());
        }
        if ((list = this._closeListenters.get(defaultCustomTabPage)) != null) {
            for (ITabCloseListner iTabCloseListner : list) {
                if (iTabCloseListner == null) continue;
                iTabCloseListner.tabClosed();
            }
        }
        this._closeListenters.remove(defaultCustomTabPage);
        this.fireChangeListeners();
    }

    public void removeAllTabs() {
        int n;
        for (int i = n = this._content.getComponentCount() - 1; i > -1; --i) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._model.get(i);
            if (!defaultCustomTabPage.isCloseable()) continue;
            this.removeTab(defaultCustomTabPage);
        }
        this.fireChangeListeners();
    }

    public void addTab(Icon icon, String string, Component component, List<ITabCloseListner> list) {
        DefaultCustomTabPage defaultCustomTabPage = new DefaultCustomTabPage(icon, string, (Object)component);
        if (list != null && list.size() > 0) {
            defaultCustomTabPage.setCloseable(true);
        } else {
            defaultCustomTabPage.setCloseable(false);
        }
        defaultCustomTabPage.setTooltip(string);
        this._model.addElement(defaultCustomTabPage);
        component.setName(string);
        this._content.add(component, string);
        this._closeListenters.put((CustomTabPage)defaultCustomTabPage, list);
        this.setSelectedIndex(0);
    }

    public void addTab(Icon icon, String string, Component component) {
        this.addTab(icon, string, component, null);
    }

    public DefaultListModel getTabModel() {
        return this._model;
    }

    public int getSelectedIndex() {
        return this._customTab.getSelectedPage();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._listeners.remove(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listeners.add(changeListener);
    }

    public void fireChangeListeners() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).stateChanged(new ChangeEvent(this));
        }
    }

    public static void main(String[] stringArray) {
        CustomTabbedPane customTabbedPane = new CustomTabbedPane();
        for (int i = 1; i < 3; ++i) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(Color.BLUE);
            ITabCloseListner iTabCloseListner = new ITabCloseListner(){

                @Override
                public void tabClosed() {
                }
            };
            jPanel.add((Component)new JTextField("tab" + i), "Center");
            String string = "tab" + i;
            customTabbedPane.addTab(null, string, jPanel, Collections.singletonList(iTabCloseListner));
        }
        JDialog jDialog = new JDialog();
        jDialog.add(customTabbedPane);
        jDialog.setSize(400, 400);
        jDialog.setVisible(true);
    }

    public int getNumberOfTabs() {
        return this._content.getComponentCount();
    }

    public void navigateBack() {
        if (this.getNumberOfTabs() <= 1) {
            return;
        }
        int n = this.getSelectedIndex();
        if (n - 1 >= 0) {
            this.setSelectedIndex(n - 1);
        } else {
            this.setSelectedIndex(this.getNumberOfTabs() - 1);
        }
    }

    public void navigateForward() {
        if (this.getNumberOfTabs() <= 1) {
            return;
        }
        int n = this.getSelectedIndex();
        if (n + 1 <= this.getNumberOfTabs() - 1) {
            this.setSelectedIndex(n + 1);
        } else {
            this.setSelectedIndex(0);
        }
    }
}

