/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.awt.Component;
import java.sql.SQLException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.ui.Messages;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class RaptorTaskUtils {
    public static String getErrorMessage(Throwable throwable) {
        String string = "";
        if (throwable instanceof TaskException || throwable instanceof ExecutionException) {
            string = RaptorTaskUtils.getErrorMessage(throwable.getCause());
        } else if (throwable instanceof CancellationException) {
            string = Messages.getString("TaskProgressViewer.TaskCancelled");
        } else if (throwable != null) {
            string = throwable.getLocalizedMessage();
        }
        return string;
    }

    public static void showErrorMessage(String string, Component component, RaptorTaskDescriptor raptorTaskDescriptor, boolean bl) {
        Throwable throwable = raptorTaskDescriptor.getThrowable();
        if (throwable instanceof TaskException) {
            throwable = ((TaskException)throwable).getCause();
        } else if (throwable instanceof ExecutionException) {
            throwable = ((ExecutionException)throwable).getCause();
        }
        String string2 = raptorTaskDescriptor.getMessage();
        if (throwable instanceof CancellationException) {
            if (!bl) {
                String string3 = Messages.getString("TaskProgressViewer.TaskCancelled") + string2;
                MessageDialog.error((Component)component, (Object)string3, (String)Messages.getString("TaskProgressViewer.Title"), null);
                return;
            }
        } else {
            String string4;
            if (throwable instanceof SQLException) {
                String string5;
                String string6;
                int n;
                if (string2 != null && 0 < (n = string2.indexOf(string6 = "ignore ORA-")) && Integer.parseInt(string5 = string2.substring(n + string6.length(), n + string6.length() + 5)) == ((SQLException)throwable).getErrorCode()) {
                    return;
                }
                SQLErrorDialog.showErrorDialog(string, component, Messages.getString("TaskProgressViewer.Title"), (SQLException)throwable);
                return;
            }
            String string7 = string4 = throwable == null ? string2 : throwable.getMessage();
            if (string4 == null || string4.equals("")) {
                string4 = raptorTaskDescriptor.getThrowable().getMessage();
            }
            ExceptionDialog.showExceptionDialog((Component)component, (Throwable)throwable, (String)Messages.getString("TaskProgressViewer.Title"), (String)string4, null);
        }
    }

    public static void showErrorMessage(String string, Component component, RaptorTaskDescriptor raptorTaskDescriptor) {
        RaptorTaskUtils.showErrorMessage(string, component, raptorTaskDescriptor, false);
    }
}

