/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.jdk11;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.security.BoxedCode;
import ice.util.security.jdk11.URLClassLoader_jdk11;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;

public class SecurityManager_jdk11
extends SecurityManager {
    private final Class RuntimeClass = Runtime.class;
    private final Class SystemClass = System.class;
    private final Class ThreadClass = Thread.class;
    private final Class ThreadGroupClass = ThreadGroup.class;
    private final String PRIVILEGED_PROXY_NAME = PrivilegedProxy.class.getName();
    private final String UNTRUSTED_PROXY_NAME = UntrustedProxy.class.getName();
    private final Object lock = new Object();
    private ThreadGroup _unprivilegedGroupsRoot;
    private int _maxUnprivilegedPriority = Thread.currentThread().getPriority();
    private boolean _inGroupInit;

    private SecurityException securityException() {
        if (Debug.trace) {
            Debug.traceStack("constructing SecurityException");
        }
        return new SecurityException();
    }

    private boolean isTrusted() {
        return this.getUntrustedDepth() < 0;
    }

    private int getUntrustedDepth() {
        int privilegedDepth;
        int untrustedDepth = this.classDepth(this.UNTRUSTED_PROXY_NAME);
        int loaderDepth = this.classLoaderDepth();
        if (untrustedDepth >= 0) {
            if (0 <= loaderDepth && loaderDepth < untrustedDepth) {
                untrustedDepth = loaderDepth;
            }
        } else {
            untrustedDepth = loaderDepth;
        }
        if (untrustedDepth >= 0 && 0 <= (privilegedDepth = this.classDepth(this.PRIVILEGED_PROXY_NAME)) && privilegedDepth < untrustedDepth) {
            untrustedDepth = -1;
        }
        return untrustedDepth;
    }

    Object doPrivileged(BoxedCode privilegedCode) {
        int loaderDepth;
        if (2 != this.classDepth("ice.util.security.SecurityKit")) {
            Debug.bug();
        }
        if (0 <= (loaderDepth = this.classLoaderDepth()) && loaderDepth <= 4) {
            throw this.securityException();
        }
        return PrivilegedProxy.callPrivileged(privilegedCode);
    }

    Object doUntrusted(BoxedCode untrustedCode) {
        return UntrustedProxy.callUntrusted(untrustedCode);
    }

    private URLClassLoader_jdk11 currentURLClassLoader() {
        ClassLoader cl = this.currentClassLoader();
        if (cl instanceof URLClassLoader_jdk11) {
            return (URLClassLoader_jdk11)cl;
        }
        return null;
    }

    public Object getSecurityContext() {
        URLClassLoader_jdk11 loader = this.currentURLClassLoader();
        if (loader != null) {
            return loader.getSecurityContext();
        }
        return null;
    }

    public void checkCreateClassLoader() {
        if (this.isTrusted()) {
            return;
        }
        throw this.securityException();
    }

    public void checkAccess(Thread t) {
        if (this.isTrusted()) {
            return;
        }
        String name = t.getClass().getName();
        if (!name.equals("java.awt.EventDispatchThread")) {
            return;
        }
        throw this.securityException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup getThreadGroup() {
        Thread currentThread = Thread.currentThread();
        ThreadGroup group = currentThread.getThreadGroup();
        if (this.isTrusted()) {
            return group;
        }
        URLClassLoader_jdk11 loader = this.currentURLClassLoader();
        if (loader != null) {
            Object object = this.lock;
            synchronized (object) {
                this._inGroupInit = true;
                try {
                    group = this.getUnprivilegedGroup(loader);
                }
                finally {
                    this._inGroupInit = false;
                }
            }
            return group;
        }
        throw this.securityException();
    }

    private ThreadGroup getUnprivilegedGroup(URLClassLoader_jdk11 loader) {
        ThreadGroup group = loader._threadGroup;
        if (group == null) {
            if (this._unprivilegedGroupsRoot == null) {
                this._unprivilegedGroupsRoot = new ThreadGroup("Untrusted threads root");
            }
            if ((group = new UnprivilegedGroup(this._unprivilegedGroupsRoot)).getMaxPriority() > this._maxUnprivilegedPriority) {
                group.setMaxPriority(this._maxUnprivilegedPriority);
            }
            loader._threadGroup = group;
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAccess(ThreadGroup group) {
        Class<?>[] stack;
        int untrustedDepth = this.getUntrustedDepth();
        if (untrustedDepth < 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this._inGroupInit) {
                return;
            }
        }
        if (group instanceof UnprivilegedGroup && (stack = this.getClassContext())[1] == this.ThreadGroupClass && stack[2] == this.ThreadClass) {
            return;
        }
        int allowedDepth = this.classDepth("sun.awt.image.ImageFetcher");
        if (0 <= allowedDepth && allowedDepth < untrustedDepth) {
            return;
        }
        throw this.securityException();
    }

    public void checkExit(int status) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkExec(String cmd) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkLink(String lib) {
        int untrustedDepth = this.getUntrustedDepth();
        if (untrustedDepth < 0) {
            return;
        }
        Class<?>[] stack = this.getClassContext();
        if (stack[1] == this.RuntimeClass) {
            int callerDepth = 2;
            if (stack[callerDepth] == this.SystemClass) {
                ++callerDepth;
            }
            if (callerDepth < untrustedDepth) {
                String name;
                if (stack[callerDepth].getClassLoader() != null) {
                    Debug.bug();
                }
                if ((name = stack[callerDepth].getName()).startsWith("java.")) {
                    return;
                }
            }
        }
        throw this.securityException();
    }

    public void checkPropertiesAccess() {
        if (this.isTrusted()) {
            return;
        }
    }

    public void checkPropertyAccess(String key) {
        if (this.isTrusted()) {
            return;
        }
        if (key.equals("java.home") || key.equals("java.class.path") || key.startsWith("user.")) {
            throw this.securityException();
        }
    }

    public void checkRead(String file) {
        this.checkReadImpl(file, null);
    }

    public void checkRead(String file, Object context) {
        this.checkReadImpl(file, context);
    }

    private void checkReadImpl(String file, Object context) {
        int untrustedDepth = this.getUntrustedDepth();
        if (untrustedDepth < 0) {
            return;
        }
        int allowedDepth = this.classDepth("java.util.ResourceBundle");
        if (0 <= allowedDepth && allowedDepth < untrustedDepth) {
            return;
        }
        throw this.securityException();
    }

    public void checkWrite(String file) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkDelete(String file) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkRead(FileDescriptor fd) {
        if (fd.valid()) {
            int untrustedDepth = this.getUntrustedDepth();
            if (untrustedDepth < 0) {
                return;
            }
            int allowedDepth = this.classDepth("java.net.SocketInputStream");
            if (0 <= allowedDepth && allowedDepth < untrustedDepth) {
                return;
            }
        }
        throw this.securityException();
    }

    public void checkWrite(FileDescriptor fd) {
        if (fd.valid()) {
            int untrustedDepth = this.getUntrustedDepth();
            if (untrustedDepth < 0) {
                return;
            }
            int allowedDepth = this.classDepth("java.net.SocketOutputStream");
            if (0 <= allowedDepth && allowedDepth < untrustedDepth) {
                return;
            }
        }
        throw this.securityException();
    }

    public void checkListen(int port) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkAccept(String host, int port) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkMulticast(InetAddress maddr) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkConnect(String destinationHost, int port) {
        this.checkConnect(destinationHost, port, this.getSecurityContext());
    }

    public void checkConnect(String destinationHost, int port, Object context) {
        URL origin;
        String originHost;
        if (this.isTrusted()) {
            return;
        }
        if (context instanceof URL && this.canConnect(originHost = (origin = (URL)context).getHost(), destinationHost)) {
            return;
        }
        throw this.securityException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canConnect(String fromHost, String toHost) {
        boolean allowed;
        Object object = this.lock;
        synchronized (object) {
            try {
                this.inCheck = true;
                allowed = SecurityManager_jdk11.sameHosts(fromHost, toHost);
            }
            finally {
                this.inCheck = false;
            }
        }
        return allowed;
    }

    private static boolean sameHosts(String fromHost, String toHost) {
        if (fromHost.equals(toHost)) {
            return true;
        }
        if (toHost.length() == 0) {
            return true;
        }
        try {
            InetAddress toHostAddr = InetAddress.getByName(toHost);
            InetAddress fromHostAddr = InetAddress.getByName(fromHost);
            if (fromHostAddr.equals(toHostAddr)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public boolean checkTopLevelWindow(Object window) {
        return this.isTrusted();
    }

    public void checkPackageAccess(String pkg) {
        if (this.isTrusted()) {
            return;
        }
        boolean deny = false;
        if (pkg.startsWith("ice.util.security")) {
            deny = true;
        } else {
            String subpkg;
            int current_end = -1;
            do {
                subpkg = (current_end = pkg.indexOf(46, current_end + 1)) < 0 ? pkg : pkg.substring(0, current_end);
                if (!Defs.sysPropertyBoolean("package.restrict.access." + subpkg)) continue;
                deny = true;
                break;
            } while (subpkg != pkg);
        }
        if (deny) {
            throw this.securityException();
        }
    }

    public void checkPackageDefinition(String pkg) {
        if (this.isTrusted()) {
            return;
        }
        boolean deny = false;
        if (pkg.startsWith("ice.util.security")) {
            deny = true;
        } else if (pkg.startsWith("java.")) {
            deny = true;
        } else {
            String subpkg;
            int current_end = -1;
            do {
                subpkg = (current_end = pkg.indexOf(46, current_end + 1)) < 0 ? pkg : pkg.substring(0, current_end);
                if (!Defs.sysPropertyBoolean("package.restrict.definition." + subpkg)) continue;
                deny = true;
                break;
            } while (subpkg != pkg);
        }
        if (deny) {
            throw this.securityException();
        }
    }

    public void checkSetFactory() {
        if (this.isTrusted()) {
            return;
        }
        throw this.securityException();
    }

    public void checkPrintJobAccess() {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkSystemClipboardAccess() {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    public void checkMemberAccess(Class classObj, int which) {
        ClassLoader currentLoader;
        boolean deny = false;
        String className = classObj.getName();
        if (className.startsWith("ice.util.security.")) {
            deny = true;
        }
        if (which != 0 && (currentLoader = this.currentClassLoader()) != null && currentLoader != classObj.getClassLoader()) {
            deny = true;
        }
        if (deny) {
            throw this.securityException();
        }
    }

    public void checkSecurityAccess(String provider) {
        if (!this.isTrusted()) {
            throw this.securityException();
        }
    }

    private static class UntrustedProxy {
        private UntrustedProxy() {
        }

        static Object callUntrusted(BoxedCode untrustedCode) {
            try {
                return untrustedCode.run();
            }
            catch (RuntimeException ex) {
                if (Debug.trace) {
                    Debug.trace("Exception in " + untrustedCode + ": " + ex);
                }
                throw ex;
            }
        }
    }

    private static class PrivilegedProxy {
        private PrivilegedProxy() {
        }

        static Object callPrivileged(BoxedCode privilegedCode) {
            try {
                return privilegedCode.run();
            }
            catch (RuntimeException ex) {
                if (Debug.trace) {
                    Debug.trace("Exception in " + privilegedCode + ": " + ex);
                }
                throw ex;
            }
        }
    }

    private static class UnprivilegedGroup
    extends ThreadGroup {
        UnprivilegedGroup(ThreadGroup parent) {
            super(parent, "");
        }
    }
}

