/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.jdk11;

import ice.debug.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class JarCache_jdk11 {
    static final JarCache_jdk11 instance = new JarCache_jdk11();
    private Hashtable loadedJarFiles = new Hashtable();

    JarCache_jdk11() {
    }

    void clear() {
        this.loadedJarFiles.clear();
    }

    void addJarFile(URL jar_url) {
        block3: {
            String jar = jar_url.toString();
            if (this.loadedJarFiles.get(jar) != null) {
                return;
            }
            try {
                Hashtable entries = this.readJar(jar_url);
                this.loadedJarFiles.put(jar, entries);
            }
            catch (IOException ex) {
                if (!Debug.ex) break block3;
                Debug.ex(ex);
            }
        }
    }

    byte[] getJarData(String jar, String entryName) {
        Hashtable entries = (Hashtable)this.loadedJarFiles.get(jar);
        if (entries != null) {
            return (byte[])entries.get(entryName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable readJar(URL jar_url) throws IOException {
        Hashtable<String, byte[]> entries = new Hashtable<String, byte[]>();
        byte[] buffer = new byte[4096];
        URLConnection uc = jar_url.openConnection();
        InputStream jarStream = uc.getInputStream();
        try {
            ZipInputStream zis = new ZipInputStream(jarStream);
            try {
                ZipEntry ent;
                while ((ent = zis.getNextEntry()) != null) {
                    int n;
                    String name = ent.getName();
                    int size = 0;
                    while ((n = zis.read(buffer, size, buffer.length - size)) >= 0) {
                        if ((size += n) != buffer.length) continue;
                        byte[] tmp = new byte[buffer.length * 2];
                        System.arraycopy(buffer, 0, tmp, 0, size);
                        buffer = tmp;
                    }
                    byte[] body = new byte[size];
                    System.arraycopy(buffer, 0, body, 0, size);
                    entries.put(name, body);
                }
            }
            finally {
                zis.close();
            }
        }
        finally {
            jarStream.close();
        }
        return entries;
    }
}

