/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters;

import ice.scripters.MimeTypeList;
import ice.scripters.MimeTypeObj;
import ice.scripters.PluginList;
import ice.scripters.PluginObj;
import ice.scripters.WindowObj;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.PilotFactory;
import ice.storm.PilotInfo;
import ice.storm.StormBase;
import ice.util.Defs;
import ice.util.Emulation;
import ice.util.alg.HashArray;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

final class NavigatorObj
extends DynamicObject {
    private StormBase storm;
    private volatile PluginList pluginList;
    private volatile MimeTypeList mimeList;
    private boolean hideIceProperties = false;
    private static final int Field_appCodeName = 1;
    private static final int Field_appName = 2;
    private static final int Field_appVersion = 3;
    private static final int Field_appMinorVersion = 4;
    private static final int Field_browserLanguage = 5;
    private static final int Field_cookieEnabled = 6;
    private static final int Field_language = 7;
    private static final int Field_mimeTypes = 8;
    private static final int Field_platform = 9;
    private static final int Field_plugins = 10;
    private static final int Field_userAgent = 11;
    private static final int Field_userLanguage = 12;
    private static final int Field___ice_test = 13;
    private static final int Field___ice_version = 14;
    private static final int Method_javaEnabled = -1;
    private static final int Method_preference = -2;
    private static final int Method_taintEnabled = -3;
    private static final int Method___ice_debug = -4;

    NavigatorObj(StormBase storm) {
        this.storm = storm;
        String s = this.sysProperty("ice.scripters.hideIceProperties", null);
        if ("true".equalsIgnoreCase(s)) {
            this.hideIceProperties = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPluginInfo() {
        Vector<PluginObj> v = new Vector<PluginObj>();
        PilotFactory f = this.storm.getPilotFactory();
        Enumeration pilots = f.getAllPilotInfos();
        while (pilots.hasMoreElements()) {
            PilotInfo pilotInfo = (PilotInfo)pilots.nextElement();
            PluginObj plugin = new PluginObj(pilotInfo);
            v.addElement(plugin);
        }
        Object[] pluginArray = new PluginObj[v.size()];
        v.copyInto(pluginArray);
        HashArray mimeMap = new HashArray(Defs.NO_SYNCHRONIZATION);
        for (int i = 0; i != pluginArray.length; ++i) {
            Object plugin = pluginArray[i];
            for (int j = 0; j != ((PluginObj)plugin).types.length; ++j) {
                MimeTypeObj typeObj = ((PluginObj)plugin).types[j];
                mimeMap.put(typeObj.type, (Object)typeObj);
            }
        }
        Object[] mimeArray = new MimeTypeObj[mimeMap.size()];
        mimeMap.getValues(mimeArray, 0);
        PluginList pluginList = new PluginList(this, (PluginObj[])pluginArray);
        MimeTypeList mimeList = new MimeTypeList(this, (MimeTypeObj[])mimeArray, mimeMap);
        NavigatorObj navigatorObj = this;
        synchronized (navigatorObj) {
            if (this.pluginList == null) {
                this.pluginList = pluginList;
                this.mimeList = mimeList;
            }
        }
    }

    private String sysProperty(final String name, final String defaultValue) {
        return (String)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                return Defs.sysProperty(name, defaultValue);
            }
        });
    }

    private String getAppCodeName() {
        return (String)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                return Emulation.getEmulatedAppCodeName();
            }
        });
    }

    private String getAppName() {
        return (String)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                return Emulation.getEmulatedAppName();
            }
        });
    }

    private String getAppVersion() {
        return (String)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                return Emulation.getEmulatedAppVersion();
            }
        });
    }

    private boolean getCookieEnabled() {
        return true;
    }

    private String getLanguage() {
        return Locale.getDefault().toString();
    }

    private String getPlatform() {
        return (String)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                return Emulation.getEmulatedPlatform();
            }
        });
    }

    public String getUserAgent() {
        return (String)SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                return Emulation.getEmulatedUserAgent();
            }
        });
    }

    private String getAppMinorVersion() {
        return "0";
    }

    private String getBrowserLanguage() {
        return this.getLanguage();
    }

    private Object getPlugins() {
        if (this.pluginList == null) {
            this.buildPluginInfo();
        }
        return this.pluginList;
    }

    private MimeTypeList getMimeTypes() {
        if (this.mimeList == null) {
            this.buildPluginInfo();
        }
        return this.mimeList;
    }

    private Object getTestObject() {
        return null;
    }

    private String getIceVersion() {
        return "v6_1_3";
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = NavigatorObj.toDynamicId(name, this.hideIceProperties);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = NavigatorObj.toDynamicId(name, this.hideIceProperties);
        if (id < 0) {
            return 1;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = NavigatorObj.toDynamicId(name, this.hideIceProperties);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getAppCodeName();
            }
            case 2: {
                return this.getAppName();
            }
            case 3: {
                return this.getAppVersion();
            }
            case 4: {
                return this.getAppMinorVersion();
            }
            case 5: {
                return this.getBrowserLanguage();
            }
            case 6: {
                return env.wrapBoolean(this.getCookieEnabled());
            }
            case 7: {
                return this.getLanguage();
            }
            case 8: {
                return this.getMimeTypes();
            }
            case 9: {
                return this.getPlatform();
            }
            case 10: {
                return this.getPlugins();
            }
            case 11: {
                return this.getUserAgent();
            }
            case 12: {
                return this.getLanguage();
            }
            case 13: {
                return this.getTestObject();
            }
            case 14: {
                return this.getIceVersion();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        return 1;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                return env.wrapBoolean(true);
            }
            case -2: {
                return env.onNotImplemented();
            }
            case -3: {
                return env.wrapBoolean(false);
            }
            case -4: {
                WindowObj.script_debug(args, env);
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s, boolean hideIceProperties) {
        int id = NavigatorObj.toDynamicId(s);
        if (id != 0 && hideIceProperties && (id == 13 || id == 14 || id == -4)) {
            id = 0;
        }
        return id;
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 7: {
                char c = s.charAt(0);
                if (c == 'a') {
                    X = "appName";
                    id = 2;
                    break;
                }
                if (c != 'p') break;
                X = "plugins";
                id = 10;
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'l') {
                    X = "language";
                    id = 7;
                    break;
                }
                if (c != 'p') break;
                X = "platform";
                id = 9;
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'm') {
                    X = "mimeTypes";
                    id = 8;
                    break;
                }
                if (c != 'u') break;
                X = "userAgent";
                id = 11;
                break;
            }
            case 10: {
                char c = s.charAt(0);
                if (c == '_') {
                    X = "__ice_test";
                    id = 13;
                    break;
                }
                if (c == 'a') {
                    X = "appVersion";
                    id = 3;
                    break;
                }
                if (c != 'p') break;
                X = "preference";
                id = -2;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == '_') {
                    X = "__ice_debug";
                    id = -4;
                    break;
                }
                if (c == 'a') {
                    X = "appCodeName";
                    id = 1;
                    break;
                }
                if (c != 'j') break;
                X = "javaEnabled";
                id = -1;
                break;
            }
            case 12: {
                char c = s.charAt(0);
                if (c == 't') {
                    X = "taintEnabled";
                    id = -3;
                    break;
                }
                if (c != 'u') break;
                X = "userLanguage";
                id = 12;
                break;
            }
            case 13: {
                char c = s.charAt(0);
                if (c == '_') {
                    X = "__ice_version";
                    id = 14;
                    break;
                }
                if (c != 'c') break;
                X = "cookieEnabled";
                id = 6;
                break;
            }
            case 15: {
                char c = s.charAt(0);
                if (c == 'a') {
                    X = "appMinorVersion";
                    id = 4;
                    break;
                }
                if (c != 'b') break;
                X = "browserLanguage";
                id = 5;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

