/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.Resources;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public final class Parse {
    private static final String[] modifierNames = new String[]{"alt", "shift", "control", "ctrl", "meta"};
    private static final int[] modifiers = new int[]{8, 1, 2, 2, 4};
    private static final String[] keyNames = new String[]{"left", "right", "esc", "enter", "home", "end", "f1", "f2", "f3"};
    private static final int[] keys = new int[]{37, 39, 27, 10, 36, 35, 112, 113, 114};
    public static final int UNKNOWN = -1;
    public static final int OPEN = 1;
    public static final int SAVE = 2;
    public static final int OTHER_TEXT = 3;
    public static final int OTHER = 0;
    private static final String[] styleNames = new String[]{"plain", "bold", "italic"};
    private static final int[] styles = new int[]{0, 1, 2};
    private static final String[] booleanNames = new String[]{"yes", "no", "true", "false"};
    private static final boolean[] booleans = new boolean[]{true, false, true, false};
    private static final String[] positionNames = new String[]{"top", "bottom", "left", "right"};
    private static final String[] positions = new String[]{"North", "South", "West", "East"};
    private static final String[] horizontalNames = new String[]{"top", "bottom"};
    private static final String[] horizontals = new String[]{"North", "South"};
    private static final String[] colorNames = new String[]{" ", "white", "lightGray", "gray", "darkGray", "black", "red", "pink", "orange", "yellow", "green", "magenta", "cyan", "blue"};
    private static final Color[] colors = new Color[]{null, Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue};
    private static final String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    public static KeyStroke parseKey(String s, Resources errorShower) {
        char cTab;
        String errorRes = "parse.key";
        s = s.trim();
        int c1 = s.indexOf(43);
        int modifs = 0;
        while (c1 >= 0) {
            int modif = -1;
            String modifier = s.substring(0, c1).trim();
            for (int i = 0; i < modifiers.length; ++i) {
                if (!modifier.equalsIgnoreCase(modifierNames[i])) continue;
                modif = modifiers[i];
                if (modif != 2) break;
                modif = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                break;
            }
            if (modif < 0) {
                errorRes = "parse.key.modifier";
                if (errorShower != null) {
                    errorShower.displayError(errorRes);
                    return null;
                }
            } else {
                modifs += modif;
            }
            s = s.substring(c1 + 1);
            c1 = s.indexOf(43);
        }
        if (s.length() > 1) {
            int keyCode = -1;
            for (int i = 0; i < keyNames.length; ++i) {
                if (!s.equalsIgnoreCase(keyNames[i])) continue;
                keyCode = keys[i];
                break;
            }
            if (keyCode < 0) {
                errorRes = "parse.key";
                if (errorShower != null) {
                    errorShower.displayError(errorRes);
                }
                return null;
            }
            return KeyStroke.getKeyStroke(keyCode, modifs);
        }
        if (s.length() == 1 && Character.isLetterOrDigit(cTab = Character.toUpperCase(s.charAt(0)))) {
            return KeyStroke.getKeyStroke((int)cTab, modifs);
        }
        return null;
    }

    public static Color parseColor(String s, Resources errorShower) {
        s = s.trim();
        int c1 = s.indexOf(44);
        int c2 = s.indexOf(44, c1 + 1);
        if (c1 >= 0 && c2 >= 0) {
            try {
                int r = Integer.parseInt(s.substring(0, c1).trim());
                int g = Integer.parseInt(s.substring(c1 + 1, c2).trim());
                int b = Integer.parseInt(s.substring(c2 + 1).trim());
                if (0 <= r && r <= 255 && 0 <= g && g <= 255 && 0 <= b && b <= 255) {
                    return new Color(r, g, b);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (errorShower != null) {
                errorShower.displayError("parse.color.rgb", s);
            }
        } else {
            for (int i = 0; i < colorNames.length; ++i) {
                if (!s.equalsIgnoreCase(colorNames[i])) continue;
                return colors[i];
            }
            if (errorShower != null) {
                errorShower.displayError("parse.color.name", s);
            }
        }
        return null;
    }

    public static String getFontStyleName(Font font) {
        int style = font.getStyle();
        if (style == 0) {
            return styleNames[0];
        }
        if (style == 1) {
            return styleNames[1];
        }
        return styleNames[2];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Font parseFont(String name, String style, String size, Resources errorShower) {
        name = name.trim();
        String nameValue = null;
        int countName = -1;
        for (int i = 0; i < fonts.length && countName < 0; ++i) {
            if (!name.equalsIgnoreCase(fonts[i])) continue;
            countName = i;
        }
        if (countName < 0) {
            if (errorShower == null) return null;
            errorShower.displayError("parse.font", name);
            return null;
        }
        nameValue = fonts[countName];
        style = style.trim();
        int styleValue = 0;
        int countStyle = -1;
        int c1 = style.indexOf(44);
        if (c1 >= 0) {
            String first = style.substring(0, c1).trim();
            for (int i = 0; i < styleNames.length && countStyle < 0; ++i) {
                if (!first.equalsIgnoreCase(styleNames[i])) continue;
                countStyle = i;
            }
            if (countStyle < 0) {
                if (errorShower == null) return null;
                errorShower.displayError("parse.font.style", first);
                return null;
            }
            styleValue = styles[countStyle];
            String second = style.substring(c1 + 1).trim();
            countStyle = -1;
            for (int i = 0; i < styleNames.length && countStyle < 0; ++i) {
                if (!second.equalsIgnoreCase(styleNames[i])) continue;
                countStyle = i;
            }
            if (countStyle < 0) {
                if (errorShower == null) return null;
                errorShower.displayError("parse.font.style", second);
                return null;
            }
            if (styleValue != styles[countStyle]) {
                styleValue += styles[countStyle];
            }
        } else {
            for (int i = 0; i < styleNames.length && countStyle < 0; ++i) {
                if (!style.equalsIgnoreCase(styleNames[i])) continue;
                countStyle = i;
            }
            if (countStyle < 0) {
                if (errorShower == null) return null;
                errorShower.displayError("parse.font.style", style);
                return null;
            }
            styleValue = styles[countStyle];
        }
        size = size.trim();
        try {
            int sizeValue = Integer.parseInt(size);
            return new Font(nameValue, styleValue, sizeValue);
        }
        catch (NumberFormatException ex) {
            if (errorShower == null) return null;
            errorShower.displayError("parse.font.size", size);
            return null;
        }
    }

    public static Integer parseInteger(String s, Resources errorShower) {
        s = s.trim();
        try {
            return new Integer(s);
        }
        catch (NumberFormatException numberFormatException) {
            if (errorShower != null) {
                errorShower.displayError("parse.integer", s);
            }
            return null;
        }
    }

    public static Long parseLong(String s, Resources errorShower) {
        s = s.trim();
        try {
            return new Long(s);
        }
        catch (NumberFormatException numberFormatException) {
            if (errorShower != null) {
                errorShower.displayError("parse.integer", s);
            }
            return null;
        }
    }

    public static Double parseDouble(String s, Resources errorShower) {
        s = s.trim();
        try {
            return new Double(s);
        }
        catch (NumberFormatException numberFormatException) {
            if (errorShower != null) {
                errorShower.displayError("parse.double", s);
            }
            return null;
        }
    }

    public static Boolean parseBoolean(String s, Resources errorShower) {
        s = s.trim();
        for (int i = 0; i < booleanNames.length; ++i) {
            if (!s.equalsIgnoreCase(booleanNames[i])) continue;
            return booleans[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (errorShower != null) {
            errorShower.displayError("parse.choice", s);
        }
        return null;
    }

    public static int parseAction(String[] actionNames, int[] actions, String s, Resources errorShower) {
        s = s.trim();
        for (int i = 0; i < actionNames.length; ++i) {
            String name = actionNames[i];
            if (!s.regionMatches(true, 0, name, 0, name.length())) continue;
            return actions[i];
        }
        if (errorShower != null) {
            errorShower.displayError("parse.action", s);
        }
        return -2;
    }

    public static String parseLookAndFeel(String s, Resources errorShower) {
        s = s.trim();
        UIManager.LookAndFeelInfo[] looks = UIManager.getInstalledLookAndFeels();
        int countName = -1;
        for (int i = 0; i < looks.length; ++i) {
            if (!s.equalsIgnoreCase(looks[i].getName())) continue;
            return looks[i].getClassName();
        }
        if (errorShower != null) {
            errorShower.displayError("parse.laf", s);
        }
        return null;
    }

    public static boolean checkEncoding(String s) {
        try {
            "test".getBytes(s);
            return true;
        }
        catch (UnsupportedEncodingException ex) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    public static String parseEncoding(String s, Resources errorShower) {
        if (Parse.checkEncoding(s = s.trim())) {
            return s;
        }
        if (errorShower != null) {
            errorShower.displayError("parse.encoding", s);
        }
        return null;
    }

    public static String parsePosition(String s, Resources errorShower) {
        s = s.trim();
        for (int i = 0; i < positionNames.length; ++i) {
            if (!s.equalsIgnoreCase(positionNames[i])) continue;
            return positions[i];
        }
        if (errorShower != null) {
            errorShower.displayError("parse.position", s);
        }
        return null;
    }

    public static String parseHorizontal(String s, Resources errorShower) {
        s = s.trim();
        for (int i = 0; i < horizontalNames.length; ++i) {
            if (!s.equalsIgnoreCase(horizontalNames[i])) continue;
            return horizontals[i];
        }
        if (errorShower != null) {
            errorShower.displayError("parse.position", s);
        }
        return null;
    }

    private static boolean test_mime_type(String s, String type) {
        if (!s.startsWith(type)) {
            return false;
        }
        int len = type.length();
        return s.length() == len || s.charAt(len) == ';';
    }

    public static int parseMime(String s) {
        if (s == null) {
            return -1;
        }
        if (Parse.test_mime_type(s, "text/plain") || Parse.test_mime_type(s, "text/html") || Parse.test_mime_type(s, "image/gif") || Parse.test_mime_type(s, "image/jpeg")) {
            return 1;
        }
        if (s.startsWith("text/")) {
            return 3;
        }
        if (s.startsWith("application/")) {
            return 2;
        }
        return 0;
    }
}

