/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.PropertiesManager;
import ice.ri.swing.Resources;
import ice.ri.swing.WindowManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

final class Console
extends JFrame
implements ActionListener,
WindowListener {
    private WindowManager windowManager;
    private static final double SIZE_FACTOR = 0.66;
    private JTextArea outArea;
    private Component resetOut;
    private Component selectOut;
    private Component copyOut;
    private Component hide;

    public Console(WindowManager windowManager) {
        this.windowManager = windowManager;
        PropertiesManager properties = windowManager.getProperties();
        Resources res = properties.res;
        this.addWindowListener(this);
        this.outArea = new JTextArea();
        this.outArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.outArea, 20, 30);
        this.getContentPane().add((Component)scrollPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(res.str("menu.file"));
        this.hide = this.createMenuItem(menu, "console.hide");
        menu.add(new JSeparator());
        this.selectOut = this.createMenuItem(menu, "menu.selectall");
        this.copyOut = this.createMenuItem(menu, "menu.copy");
        this.resetOut = this.createMenuItem(menu, "console.out.reset");
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.setTitle(res.str("console.title"));
        int width = properties.getInt("application.width");
        int height = properties.getInt("application.height");
        this.setSize((int)((double)width * 0.66), (int)((double)height * 0.66));
    }

    private Component createMenuItem(JMenu menu, String title) {
        JMenuItem item = new JMenuItem(this.windowManager.getProperties().res.str(title));
        item.addActionListener(this);
        menu.add((Component)item);
        return item;
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.resetOut) {
            this.outArea.setText("");
        } else if (ev.getSource() == this.selectOut) {
            this.outArea.selectAll();
        } else if (ev.getSource() == this.copyOut) {
            this.outArea.copy();
        } else if (ev.getSource() == this.hide) {
            this.setVisible(false);
        }
    }

    public void windowOpened(WindowEvent e) {
        this.setupConsoleText();
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.setVisible(false);
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
        this.setupConsoleText();
    }

    public void windowActivated(WindowEvent e) {
        this.setupConsoleText();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    void setData(String text) {
        this.outArea.setText(text);
    }

    private void setupConsoleText() {
        this.setData(this.windowManager.consoleOut.getBufferAsText());
    }
}

