/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.awt;

import ice.ri.common.dialog.SettingsDialogPanelGroup;
import ice.ri.common.dialog.awt.AbstractSettingsDialog;
import ice.ri.common.dialog.awt.AbstractSettingsDialogPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class DefaultSettingsDialog
extends AbstractSettingsDialog {
    private GridBagConstraints constraints;
    private Panel buttonPanel;
    private Panel buttonTabsPanel;
    private Panel contentPanel;
    private Frame parentFrame;

    public DefaultSettingsDialog(Frame parent, String title) {
        super(parent, title);
        this.parentFrame = parent;
        this.contentPanel = new Panel(new GridLayout(1, 1, 0, 0));
        this.buttonTabsPanel = new Panel(new FlowLayout(2));
    }

    public void setGui() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.contentPanel, "Center");
        this.setResizable(false);
        GridBagLayout layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.buttonPanel = new Panel(layout);
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.anchor = 10;
        this.addGB(this.okButton, 0, 1);
        this.addGB(this.cancelButton, 1, 1);
        if (this.displayType == 1) {
            this.addGB(this.applyButton, 2, 1);
        }
        Panel buttonLayoutPanel = new Panel(new BorderLayout(0, 10));
        buttonLayoutPanel.add((Component)this.buttonTabsPanel, "Center");
        buttonLayoutPanel.add((Component)this.buttonPanel, "South");
        this.add((Component)buttonLayoutPanel, "South");
    }

    public void add(SettingsDialogPanelGroup group) {
        super.add(group);
        Vector groupPanels = group.getPanels();
        Enumeration panels = groupPanels.elements();
        while (panels.hasMoreElements()) {
            AbstractSettingsDialogPanel tmp = (AbstractSettingsDialogPanel)panels.nextElement();
            this.add(tmp);
        }
    }

    public void add(final AbstractSettingsDialogPanel panel) {
        super.add(panel);
        if (this.panels.size() == 1) {
            this.contentPanel.add(panel);
        } else {
            Button tmp = new Button(panel.getName());
            final int xCord = this.getBounds().x + 15;
            final int yCord = this.getBounds().y + 15;
            tmp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultSettingsDialog tmpDialog = new DefaultSettingsDialog(DefaultSettingsDialog.this.parentFrame, panel.getName());
                    tmpDialog.setButtonDisplay(2);
                    tmpDialog.add(panel);
                    tmpDialog.setLocation(xCord, yCord);
                    tmpDialog.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            DefaultSettingsDialog.this.cancel();
                            e.getWindow().setVisible(false);
                            e.getWindow().dispose();
                        }
                    });
                    tmpDialog.setVisible(true);
                }
            });
            this.buttonTabsPanel.add(tmp);
        }
    }

    private void addGB(Component component, int x, int y) {
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.buttonPanel.add(component, this.constraints);
    }
}

