/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.BreakBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSMatcher;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOM;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.FramesDivider;
import ice.pilots.html4.FramesetData;
import ice.pilots.html4.FramesetInfo;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.StormData;
import ice.pilots.html4.TableBox;
import ice.pilots.html4.TableCellBox;
import ice.pilots.html4.TableRowGroupBox;
import ice.pilots.html4.ThePilot;
import ice.storm.Viewport;
import ice.storm.print.AbstractStormPrinter;
import ice.storm.print.PageDecoration;
import ice.storm.print.StormPageFormat;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

class ThePrinter
extends AbstractStormPrinter {
    private static final double ZOOM_ADJUSTMENT_FACTOR = (double)Defs.intProperty("ice.pilots.html4.printScaleAdjustment", 77) / 100.0;
    private Vector pageLayoutCache = new Vector();
    private HTMLDocument htmlDocument;
    private Vector naturalPageBreaks = new Vector();
    private Vector forcedPageBreaks = new Vector();
    private Vector naturalTablePageBreaks = new Vector();
    private int originalWidth = 0;
    private Vector viewports = null;
    private Viewport viewport = null;
    private int zoom = (int)Math.round(256.0 * ZOOM_ADJUSTMENT_FACTOR);

    protected ThePrinter(StormData sdata, DDocument doc, CSSMatcher matcher) {
        this.htmlDocument = new HTMLDocument(sdata, doc, matcher);
        this.htmlDocument.layout((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        this.originalWidth = this.htmlDocument.getWidth();
    }

    protected ThePrinter(CSSLayout layout) {
        this.htmlDocument = (HTMLDocument)layout;
        this.htmlDocument.setPrintBack(this.pageFormat.isBackgroundVisible());
        this.htmlDocument.layout((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
    }

    protected ThePrinter(CSSLayout layout, Viewport viewport) {
        this.viewports = new Vector();
        viewport.getViewAndAllChildren(this.viewports);
        this.viewport = viewport;
        this.htmlDocument = (HTMLDocument)layout;
        if (viewport.getPilot() instanceof ThePilot) {
            ThePilot thePilot = (ThePilot)viewport.getPilot();
            FramesetData framesData = thePilot.framesetData;
            if (framesData != null) {
                framesData.layout(0, 0, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            }
        }
        this.htmlDocument.setPrintBack(this.pageFormat.isBackgroundVisible());
        this.htmlDocument.layout((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPage(Graphics g, int pageIndex) {
        if (this.numberOfPages > 0) {
            if (pageIndex < 0) {
                pageIndex = 0;
            } else if (pageIndex > this.numberOfPages - 1) {
                pageIndex = this.numberOfPages - 1;
            }
            Graphics gg = g.create((int)this.pageFormat.getMargin(2), (int)this.pageFormat.getMargin(1), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            Point[] tempPage = (Point[])this.pageLayoutCache.elementAt(pageIndex);
            gg.setClip(0, 0, tempPage[1].x - tempPage[0].x, tempPage[2].y - tempPage[0].y);
            gg.translate(-tempPage[0].x, -tempPage[0].y);
            this.htmlDocument.setImageablePrintArea(tempPage[0].x, tempPage[0].y, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            this.htmlDocument.paint(gg);
            try {
                this.paintChildViewports(this.viewport, gg, null);
            }
            catch (RuntimeException re) {
                Debug.ex(re);
            }
            finally {
                gg.dispose();
            }
            Graphics gd = g.create(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            gd.translate(0, 0);
            gd.setClip(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            Vector pageDecorations = this.pageFormat.getDecoration();
            for (int i = pageDecorations.size() - 1; i >= 0; --i) {
                PageDecoration tmp = (PageDecoration)pageDecorations.elementAt(i);
                tmp.paint(gd, pageIndex, this.numberOfPages, this.pageFormat);
            }
            gd.dispose();
        } else {
            g.setColor(Color.black);
            g.setFont(new Font("dialog", 0, 14));
            g.drawString("No renderable content", (int)this.pageFormat.getImageableWidth() / 2, (int)this.pageFormat.getImageableHeight() / 2);
        }
    }

    private void paintFrameset(FramesetInfo framesetdata, Graphics gg, int x, int y) {
        gg.setColor(Color.lightGray);
        gg.fillRect(x, y, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        int borderX = 4;
        int borderY = 4;
        int xFrame = x;
        int yFrame = y;
        int frameOffset = 0;
        for (int i = 0; i < framesetdata.children.size(); ++i) {
            Object next;
            Object tmp;
            int widthFrame = framesetdata.viewportSizes[frameOffset];
            int heightFrame = framesetdata.viewportSizes[frameOffset + 1];
            frameOffset = 2;
            if (framesetdata.children.elementAt(i) instanceof Viewport) {
                tmp = (Viewport)framesetdata.children.elementAt(i);
                borderX = ((FramesDivider)framesetdata.framesetDividers.elementAt((int)i)).x_width;
                borderY = ((FramesDivider)framesetdata.framesetDividers.elementAt((int)i)).y_width;
                if (((Viewport)tmp).getPilot() instanceof ThePilot) {
                    ThePilot pilot = (ThePilot)((Viewport)tmp).getPilot();
                    ThePrinter printer = (ThePrinter)pilot.createPrinter();
                    printer.setStormPageFormat(this.pageFormat);
                    Rectangle frameDim = new Rectangle(xFrame, yFrame, widthFrame, heightFrame);
                    int frameZoom = this.zoom;
                    if (this.pageFormat.isScaleToFitEnabled()) {
                        double scale = 1.0 / (double)pilot.getCSSLayout().getWidth() * (double)frameDim.width;
                        frameZoom = (int)Math.round(256.0 * scale);
                    }
                    printer.getCSSLayout().setLayoutZoom(frameZoom);
                    printer.getCSSLayout().layout(frameDim.width, frameDim.height);
                    Graphics p = gg.create(frameDim.x, frameDim.y, frameDim.width, frameDim.height);
                    printer.htmlDocument.paint(p);
                    p.dispose();
                    printer.dispose();
                }
            } else if (framesetdata.children.elementAt(i) instanceof FramesetInfo) {
                tmp = (FramesetInfo)framesetdata.children.elementAt(i);
                this.paintFrameset((FramesetInfo)tmp, gg, xFrame, yFrame);
            }
            if (framesetdata.children.size() <= i + 1 || !((next = framesetdata.children.elementAt(i + 1)) instanceof Viewport)) continue;
            Viewport nextViewport = (Viewport)next;
            yFrame = nextViewport.getPilotComponent().getY();
            xFrame = nextViewport.getPilotComponent().getX();
        }
    }

    private void paintChildViewports(Viewport viewport, Graphics gg, Rectangle rect) {
        if (viewport.getPilot() instanceof ThePilot) {
            ThePilot pilot = (ThePilot)viewport.getPilot();
            FramesetData framesetdata = pilot.framesetData;
            if (framesetdata != null) {
                if (rect != null) {
                    framesetdata.layout(0, 0, rect.width, rect.height);
                } else {
                    framesetdata.layout(0, 0, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
                }
                this.paintFrameset(framesetdata.frameset, gg, 0, 0);
            }
        }
        Enumeration nextView = viewport.getChildren();
        while (nextView != null && nextView.hasMoreElements()) {
            Object obj = nextView.nextElement();
            if (!(obj instanceof EmbeddedObject)) continue;
            EmbeddedObject embObj = (EmbeddedObject)obj;
            ObjectBox b = embObj.box;
            CSSAttribs css = b.css;
            if ((css.misc & 1) == 0 || !(embObj.getPilot() instanceof ThePilot)) continue;
            ThePilot pilot = (ThePilot)embObj.getPilot();
            ThePrinter printer = (ThePrinter)pilot.createPrinter();
            printer.setStormPageFormat(this.pageFormat);
            ObjectBox embBox = embObj.getBox();
            if (embBox == null) continue;
            pilot.getCSSLayout().setLayoutZoom(this.zoom);
            Rectangle r = new Rectangle();
            embBox.findAbsolutePosition(r);
            pilot.getCSSLayout().layout(r.width, r.height);
            Graphics p = gg.create(r.x, r.y, r.width, r.height);
            FramesetData framesData = pilot.framesetData;
            if (framesData != null) {
                this.paintChildViewports(pilot.getPilotViewport(), p, r);
            } else {
                printer.htmlDocument.paint(p);
            }
            p.dispose();
            printer.dispose();
        }
    }

    public Dimension getDimension() {
        return new Dimension(this.htmlDocument.getWidth(), this.htmlDocument.getHeight());
    }

    public void print(Graphics g) {
        Graphics gg = g.create(0, 0, this.htmlDocument.getWidth(), this.htmlDocument.getHeight());
        this.htmlDocument.setImageablePrintArea(0, 0, this.htmlDocument.getWidth(), this.htmlDocument.getHeight());
        this.htmlDocument.paint(gg);
        this.paintChildViewports(this.viewport, gg, null);
        gg.dispose();
    }

    public void dispose() {
        this.htmlDocument.clear();
        if (this.viewports != null) {
            this.viewports.removeAllElements();
        }
        if (this.pageLayoutCache != null) {
            this.pageLayoutCache.removeAllElements();
        }
        if (this.naturalPageBreaks != null) {
            this.naturalPageBreaks.removeAllElements();
        }
        if (this.forcedPageBreaks != null) {
            this.forcedPageBreaks.removeAllElements();
        }
        if (this.naturalTablePageBreaks != null) {
            this.naturalTablePageBreaks.removeAllElements();
        }
    }

    public void setStormPageFormat(StormPageFormat pageFormat) {
        this.htmlDocument.setPrintBack(pageFormat.isBackgroundVisible());
        super.setStormPageFormat(pageFormat);
        if (pageFormat.isPrintSelected()) {
            this.shortenDocumentViaSelection();
        }
    }

    public void setZoom(int zoom) {
        double pageFormatZoom = (double)Math.abs(zoom) / 256.0;
        this.pageFormat.setScale(pageFormatZoom);
        this.zoom = this.pageFormat.isScaleToFitEnabled() ? zoom : (int)Math.round((double)zoom * ZOOM_ADJUSTMENT_FACTOR);
        this.getPageCount();
    }

    public void paintCallback(Graphics g, ObjectPainter painter) {
        this.htmlDocument.paintCallback(g, painter);
    }

    public int getPageCount() {
        if (this.pageFormat == null) {
            this.pageFormat = new StormPageFormat();
        }
        if (this.pageFormat.hasImageableAreaChanged()) {
            if (this.pageFormat.isScaleToFitEnabled()) {
                double scale = 1.0 / (double)this.originalWidth * this.pageFormat.getImageableWidth();
                this.pageFormat.setScale(scale);
                this.zoom = (int)Math.round(256.0 * this.pageFormat.getScale());
            } else {
                this.zoom = (int)Math.round(256.0 * ZOOM_ADJUSTMENT_FACTOR * this.pageFormat.getScale());
            }
            this.htmlDocument.setLayoutZoom(this.zoom);
            this.htmlDocument.layout((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            this.pageLayoutCache = new Vector(5);
            this.naturalPageBreaks = new Vector();
            this.forcedPageBreaks = new Vector(5);
            this.naturalTablePageBreaks = new Vector(5);
            this.recordHorizontalPageBreaks(this.htmlDocument.topBox);
            ThePrinter.sortPageBreaks(this.naturalPageBreaks, true);
            ThePrinter.sortPageBreaks(this.forcedPageBreaks, false);
            int nextBreak = 0;
            Point[] previousPage = new Point[]{new Point(0, 0), new Point((int)this.pageFormat.getImageableWidth(), 0)};
            while (nextBreak < this.htmlDocument.getHeight()) {
                nextBreak = this.findHorizontalPageBreak(nextBreak, (int)this.pageFormat.getImageableHeight());
                Point[] tmpPage = new Point[]{new Point(previousPage[0].x, previousPage[0].y), new Point(previousPage[1].x, previousPage[1].y), new Point(0, nextBreak), new Point((int)this.pageFormat.getImageableWidth(), nextBreak)};
                this.pageLayoutCache.addElement(tmpPage);
                previousPage[0] = new Point(tmpPage[2].x, tmpPage[2].y);
                previousPage[1] = new Point(tmpPage[3].x, tmpPage[3].y);
            }
            this.naturalPageBreaks.removeAllElements();
            this.naturalPageBreaks = null;
            this.forcedPageBreaks.removeAllElements();
            this.forcedPageBreaks = null;
            Vector allPageLayoutCache = (Vector)this.pageLayoutCache.clone();
            if (allPageLayoutCache.size() > 0) {
                int count = 0;
                for (int j = 0; j < this.pageLayoutCache.size(); ++j) {
                    Point[] currentPage = (Point[])this.pageLayoutCache.elementAt(j);
                    Vector naturalVerticalPageBreaks = new Vector(10);
                    VerticalTablePageBreaks maxTableWidth = new VerticalTablePageBreaks(0, 0, 0, 0, null);
                    for (int i = 0; i < this.naturalTablePageBreaks.size(); ++i) {
                        VerticalTablePageBreaks temp = (VerticalTablePageBreaks)this.naturalTablePageBreaks.elementAt(i);
                        if (!temp.contains(currentPage) || temp.getTotalWidth() <= maxTableWidth.getTotalWidth()) continue;
                        maxTableWidth = temp;
                        Enumeration columnBreaks = maxTableWidth.getColumnBreaks().elements();
                        while (columnBreaks.hasMoreElements()) {
                            naturalVerticalPageBreaks.addElement(columnBreaks.nextElement());
                        }
                    }
                    ThePrinter.sortPageBreaks(naturalVerticalPageBreaks, false);
                    if (!((double)maxTableWidth.getTotalWidth() > this.pageFormat.getImageableWidth())) continue;
                    Vector tableColumns = maxTableWidth.getColumnBreaks();
                    if (tableColumns != null) {
                        nextBreak = 0;
                        previousPage[0] = currentPage[1];
                        previousPage[1] = currentPage[3];
                        int page = 0;
                        while (nextBreak <= maxTableWidth.getTotalWidth()) {
                            nextBreak = this.findVerticalPageBreak(nextBreak, (int)this.pageFormat.getImageableWidth(), naturalVerticalPageBreaks);
                            if (page == 0) {
                                currentPage[1].x = nextBreak;
                                currentPage[3].x = nextBreak;
                                previousPage[0] = currentPage[1];
                                previousPage[1] = currentPage[3];
                            } else {
                                Point[] tmpPage = new Point[]{previousPage[0], new Point(nextBreak, previousPage[0].y), previousPage[1], new Point(nextBreak, previousPage[1].y)};
                                allPageLayoutCache.insertElementAt(tmpPage, count + 1);
                                ++count;
                                previousPage[0] = tmpPage[1];
                                previousPage[1] = tmpPage[3];
                            }
                            ++page;
                        }
                    }
                    ++count;
                }
                this.pageLayoutCache = allPageLayoutCache;
                this.numberOfPages = this.pageLayoutCache.size();
                this.currentPageIndex = -1;
                this.pageFormat.setImageableAreaChangedFlag(false);
            }
        }
        return this.numberOfPages;
    }

    private void shortenDocumentViaSelection() {
        DElement element = this.htmlDocument.doc.getPilot().getCSSLayout().getSelectionDElement();
        if (element != null) {
            DOM dom = DOM.getInstance(this.htmlDocument.sdata);
            DDocument printDoc = new DDocument(this.htmlDocument.doc.getPilot(), dom);
            printDoc.appendDChild(element);
            this.htmlDocument = new HTMLDocument(this.htmlDocument.sdata, printDoc, this.htmlDocument.matcher);
        }
        this.pageFormat.setImageableAreaChangedFlag(true);
    }

    public int getZoom() {
        if (this.pageFormat.isScaleToFitEnabled()) {
            double scale = 1.0 / (double)this.originalWidth * this.pageFormat.getImageableWidth();
            this.pageFormat.setScale(scale);
            return (int)Math.round(this.pageFormat.getScale() * 256.0);
        }
        return (int)Math.round(this.pageFormat.getScale() * ZOOM_ADJUSTMENT_FACTOR * 256.0);
    }

    protected CSSLayout getCSSLayout() {
        return this.htmlDocument.getCSSLayout();
    }

    private int findHorizontalPageBreak(int startY, int pageHeight) {
        if (this.forcedPageBreaks.size() > 0) {
            for (int i = 0; i < this.forcedPageBreaks.size(); ++i) {
                int horizontalBreak = (Integer)this.forcedPageBreaks.elementAt(i);
                if (horizontalBreak <= startY || horizontalBreak > startY + pageHeight) continue;
                return horizontalBreak;
            }
        }
        if (this.pageFormat.isHtmlSmartPagingEnabled()) {
            int oneTenthPageHeight = pageHeight / 10;
            for (int i = 0; i < this.naturalPageBreaks.size() - 1; ++i) {
                PageBreak currentHorizontalBreak = (PageBreak)this.naturalPageBreaks.elementAt(i);
                PageBreak nextHorizontalBreak = (PageBreak)this.naturalPageBreaks.elementAt(i + 1);
                if (currentHorizontalBreak.y <= startY || currentHorizontalBreak.y > startY + pageHeight || currentHorizontalBreak.y <= startY + pageHeight / 4 || nextHorizontalBreak.y <= startY + pageHeight || nextHorizontalBreak.y >= startY + pageHeight + pageHeight) continue;
                if (!currentHorizontalBreak.tableBreak) {
                    for (int j = i - 1; j >= 0; --j) {
                        PageBreak tmpBreak = (PageBreak)this.naturalPageBreaks.elementAt(j);
                        if (currentHorizontalBreak.y - tmpBreak.y <= oneTenthPageHeight && tmpBreak.tableBreak) {
                            return tmpBreak.y;
                        }
                        if (currentHorizontalBreak.y - tmpBreak.y > oneTenthPageHeight) break;
                    }
                }
                return currentHorizontalBreak.y;
            }
        }
        return startY + pageHeight;
    }

    private int findVerticalPageBreak(int startX, int pageWidth, Vector columnWidths) {
        if (columnWidths.size() > 0 && this.pageFormat.isHtmlSmartPagingEnabled()) {
            for (int i = 0; i < columnWidths.size() - 1; ++i) {
                double ratio;
                int currentVerticalBreak = (Integer)columnWidths.elementAt(i);
                int nextVerticalBreak = (Integer)columnWidths.elementAt(i + 1);
                if (currentVerticalBreak <= startX || currentVerticalBreak >= startX + pageWidth || nextVerticalBreak <= startX + pageWidth || nextVerticalBreak >= startX + pageWidth + pageWidth || !((ratio = (double)(currentVerticalBreak - startX) / (double)pageWidth) > 0.5)) continue;
                return currentVerticalBreak;
            }
        }
        return startX + pageWidth;
    }

    private void recordHorizontalPageBreaks(CSSBox cssBox) {
        block22: {
            block24: {
                Point blockPosition;
                block23: {
                    block21: {
                        if (!(cssBox instanceof TableBox) || !this.pageFormat.isHtmlSmartPagingEnabled()) break block21;
                        TableBox tableBox = (TableBox)cssBox;
                        if ((double)tableBox.width > this.pageFormat.getImageableWidth() && tableBox.colWidth != null) {
                            this.naturalTablePageBreaks.addElement(new VerticalTablePageBreaks(tableBox));
                        }
                        CSSBox tableBoxFirstRowGroup = tableBox.getfirstRowGroup();
                        while (tableBoxFirstRowGroup != null && tableBoxFirstRowGroup instanceof TableRowGroupBox) {
                            CSSBox row = ((TableRowGroupBox)tableBoxFirstRowGroup).firstRow;
                            CSSBox lastRow = ((TableRowGroupBox)tableBoxFirstRowGroup).lastRow;
                            while (row != null) {
                                int topCorrection;
                                Point rowPosition = new Point();
                                row.findAbsolutePosition(rowPosition);
                                int tableBoxBorder = 0;
                                int tableBoxCellspacing = 0;
                                if (tableBox.element != null) {
                                    tableBoxBorder = tableBox.element.getAttributeAsInt("border");
                                    if (tableBoxBorder == -1) {
                                        tableBoxBorder = 0;
                                    }
                                    if ((tableBoxCellspacing = tableBox.element.getAttributeAsInt("cellspacing")) == -1) {
                                        tableBoxCellspacing = 0;
                                    }
                                }
                                if ((topCorrection = tableBox.css.border_top_width) == 0) {
                                    topCorrection = tableBoxBorder;
                                }
                                this.naturalPageBreaks.addElement(new PageBreak(rowPosition.y - (topCorrection += tableBoxCellspacing), true));
                                if (row.equals(lastRow)) {
                                    int bottomCorrection = tableBox.css.border_bottom_width;
                                    if (bottomCorrection == 0) {
                                        bottomCorrection = tableBoxBorder;
                                    }
                                    this.naturalPageBreaks.addElement(new PageBreak(rowPosition.y + row.height + (bottomCorrection += tableBoxCellspacing), true));
                                } else {
                                    this.naturalPageBreaks.addElement(new PageBreak(rowPosition.y + row.height, true));
                                }
                                CSSBox cBox = row.getFirstChild();
                                while (cBox != null) {
                                    this.recordHorizontalPageBreaks(cBox);
                                    cBox = cBox.next;
                                }
                                row = row.next;
                            }
                            tableBoxFirstRowGroup = tableBoxFirstRowGroup.next;
                        }
                        break block22;
                    }
                    if (!(cssBox instanceof BreakBox) || !this.pageFormat.isHtmlSmartPagingEnabled()) break block23;
                    Point position = new Point();
                    cssBox.findAbsolutePosition(position);
                    this.naturalPageBreaks.addElement(new PageBreak(position.y, false));
                    break block22;
                }
                if (!(cssBox instanceof BlockBox)) break block24;
                BlockBox blockBox = (BlockBox)cssBox;
                int before = blockBox.css.getPageBreak(0);
                int after = blockBox.css.getPageBreak(1);
                if (before != 0 || after != 0) {
                    blockPosition = new Point();
                    blockBox.findAbsolutePosition(blockPosition);
                    blockPosition.y -= blockBox.css.border_top_width;
                    if (before == 1) {
                        this.forcedPageBreaks.addElement(new Integer(blockPosition.y));
                    }
                    if (after == 1) {
                        this.forcedPageBreaks.addElement(new Integer(blockPosition.y + blockBox.height));
                    }
                }
                if (this.pageFormat.isHtmlSmartPagingEnabled()) {
                    blockPosition = new Point();
                    if (!(blockBox instanceof TableCellBox)) {
                        blockBox.findAbsolutePosition(blockPosition);
                        this.naturalPageBreaks.addElement(new PageBreak(blockPosition.y, false));
                    }
                    int line = 0;
                    int count = 0;
                    int newBreak = blockPosition.y;
                    int lastBreak = blockPosition.y;
                    while (count < 10 && line + 3 < blockBox.lines.length) {
                        if ((newBreak += blockBox.lines[line + 2]) != lastBreak) {
                            lastBreak = newBreak;
                            this.naturalPageBreaks.addElement(new PageBreak(newBreak, false));
                        }
                        line += 3;
                    }
                    this.naturalPageBreaks.addElement(new PageBreak(blockPosition.y + blockBox.height, false));
                }
                CSSBox nextBlockBox = blockBox.first;
                while (nextBlockBox != null) {
                    this.recordHorizontalPageBreaks(nextBlockBox);
                    nextBlockBox = nextBlockBox.next;
                }
                break block22;
            }
            if (!(cssBox instanceof InlineBox)) break block22;
            if (this.pageFormat.isHtmlSmartPagingEnabled()) {
                Point position = new Point();
                cssBox.findAbsolutePosition(position);
                this.naturalPageBreaks.addElement(new PageBreak(position.y, false));
            }
            CSSBox inlineChildBox = cssBox.getFirstChild();
            while (inlineChildBox != null) {
                this.recordHorizontalPageBreaks(inlineChildBox);
                inlineChildBox = inlineChildBox.next;
            }
        }
    }

    private static void sortPageBreaks(Vector breaks, boolean isNaturalBreaks) {
        ThePrinter.quickSort(breaks, 0, breaks.size() - 1, isNaturalBreaks);
        ThePrinter.removeDuplication(breaks, isNaturalBreaks);
    }

    private static void quickSort(Vector v, int left, int right, boolean isNaturalBreaks) {
        if (left >= right) {
            return;
        }
        ThePrinter.swap(v, left, (left + right) / 2);
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            int leftValue;
            int tmp;
            if (isNaturalBreaks) {
                tmp = ((PageBreak)v.elementAt((int)i)).y;
                leftValue = ((PageBreak)v.elementAt((int)left)).y;
            } else {
                tmp = (Integer)v.elementAt(i);
                leftValue = (Integer)v.elementAt(left);
            }
            if (tmp >= leftValue) continue;
            ThePrinter.swap(v, ++last, i);
        }
        ThePrinter.swap(v, left, last);
        ThePrinter.quickSort(v, left, last - 1, isNaturalBreaks);
        ThePrinter.quickSort(v, last + 1, right, isNaturalBreaks);
    }

    private static void swap(Vector v, int i, int j) {
        Object tmp = v.elementAt(i);
        v.setElementAt(v.elementAt(j), i);
        v.setElementAt(tmp, j);
    }

    private static void removeDuplication(Vector v, boolean isNaturalBreak) {
        for (int i = v.size() - 1; i > 1; --i) {
            int currentBreak;
            if (isNaturalBreak) {
                PageBreak previousBreak = (PageBreak)v.elementAt(i - 1);
                PageBreak currentBreak2 = (PageBreak)v.elementAt(i);
                if (previousBreak.y != currentBreak2.y) continue;
                if (previousBreak.tableBreak == currentBreak2.tableBreak || !currentBreak2.tableBreak) {
                    v.removeElementAt(i);
                    continue;
                }
                if (!currentBreak2.tableBreak) continue;
                v.removeElementAt(i - 1);
                continue;
            }
            int previousBreak = (Integer)v.elementAt(i - 1);
            if (previousBreak != (currentBreak = ((Integer)v.elementAt(i)).intValue())) continue;
            v.removeElementAt(i);
        }
    }

    class HTMLDocument
    extends CSSLayout {
        HTMLDocument(StormData sdata, DDocument doc, CSSMatcher matcher) {
            super(sdata, doc, matcher);
            this.inPrintMode = true;
            this.doc = doc;
        }

        void paintCallback(Graphics g, ObjectPainter painter) {
            if (painter instanceof Component) {
                ((Component)((Object)painter)).printAll(g);
            } else if (painter instanceof EmbeddedObject) {
                Component c = ((EmbeddedObject)painter).getPilotComponent();
                if (c != null && c.getSize().width > 2 && c.getSize().height > 2) {
                    c.printAll(g);
                } else {
                    super.paintCallback(g, painter);
                }
            } else {
                super.paintCallback(g, painter);
            }
        }

        CSSLayout getCSSLayout() {
            return this;
        }

        void setImageablePrintArea(int x, int y, int width, int height) {
            super.setImageablePrintArea(new Rectangle(x, y, width, height));
        }
    }

    class VerticalTablePageBreaks {
        private int x;
        private int y;
        private int width;
        private int height;
        private Vector columnBreaks;

        VerticalTablePageBreaks(int x, int y, int width, int height, Vector columnBreaks) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.columnBreaks = columnBreaks;
        }

        VerticalTablePageBreaks(TableBox tableBox) {
            int rightBorderWidth;
            this.x = tableBox.ox;
            this.y = tableBox.oy;
            this.width = tableBox.width;
            this.height = tableBox.height;
            int[] tableColumnWidths = tableBox.colWidth;
            this.columnBreaks = new Vector(tableColumnWidths.length);
            int verticalOffset = this.x;
            DElement tableElement = tableBox.element;
            int cellspacingWidth = tableElement == null ? 0 : tableElement.getAttributeAsInt("cellspacing");
            int leftBorderWidth = tableBox.css.border_left_width;
            if (leftBorderWidth == 0 && tableElement != null) {
                leftBorderWidth = tableElement.getAttributeAsInt("border");
            }
            if ((rightBorderWidth = tableBox.css.border_right_width) == 0 && tableElement != null) {
                rightBorderWidth = tableElement.getAttributeAsInt("border");
            }
            for (int i = 0; i < tableColumnWidths.length; ++i) {
                if (i == 0) {
                    verticalOffset += leftBorderWidth + cellspacingWidth + tableColumnWidths[i];
                    if (tableColumnWidths.length == 1) {
                        verticalOffset += cellspacingWidth + rightBorderWidth;
                    }
                    this.columnBreaks.addElement(new Integer(verticalOffset));
                    continue;
                }
                if (i == tableColumnWidths.length - 1) {
                    this.columnBreaks.addElement(new Integer(verticalOffset += tableColumnWidths[i] + cellspacingWidth + rightBorderWidth + cellspacingWidth));
                    continue;
                }
                this.columnBreaks.addElement(new Integer(verticalOffset += tableColumnWidths[i] + cellspacingWidth));
            }
        }

        public boolean contains(Point[] pageDimension) {
            boolean contains = false;
            if (pageDimension == null) {
                throw new NullPointerException();
            }
            int y0 = pageDimension[0].y;
            int y2 = pageDimension[2].y;
            int x0 = pageDimension[0].x;
            int x1 = pageDimension[1].x;
            if ((this.y >= y0 & this.y < y2 || this.y < y0 & (this.y + this.height >= y2 || this.y + this.height < y2 & this.y + this.height >= y0)) && (this.x >= x0 & this.x < x1 || this.x < x0 & (this.x + this.width >= x0 || this.x + this.width < x1 & this.x + this.height >= x0))) {
                contains = true;
            }
            return contains;
        }

        public String toString() {
            String output = "";
            output = output + "Table x=" + this.x + " y=" + this.y + " w=" + this.width + " h=" + this.height + " ";
            output = output + "Colum Breaks: ";
            Enumeration columns = this.columnBreaks.elements();
            while (columns.hasMoreElements()) {
                output = output + columns.nextElement() + " ";
            }
            return output;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getTableArea() {
            return this.width * this.height;
        }

        public int getTotalWidth() {
            return this.x + this.width;
        }

        public void setColumnBreaks(Vector columnBreaks) {
            this.columnBreaks = columnBreaks;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Vector getColumnBreaks() {
            return this.columnBreaks;
        }
    }

    private class PageBreak {
        int y;
        boolean tableBreak;

        PageBreak(int y, boolean tableBreak) {
            this.y = y;
            this.tableBreak = tableBreak;
        }
    }
}

