/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerURLMappings;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.ide.controls.Toolbar;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class ListenerURLMappingPanel
extends ListenerSettings {
    private static final String EMPTY = "";
    private static final String DOT = ".";
    private static final int RULE_TYPE = 0;
    private static final int RULE_PREFIX = 1;
    private static final int RESTFUL_SCHEMA = 2;
    private static final int RESTFUL_WORKSPACE = 3;
    private static final int UPDATED = 4;
    private JTable _table;
    private DefaultTableModel _tableModel;

    public ListenerURLMappingPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 275));
        this._tableModel = new DefaultTableModel();
        this._tableModel.addColumn(ListenerArb.getString("COL_HDR_RULE_TYPE"));
        this._tableModel.addColumn(ListenerArb.getString("COL_HDR_ROUTING_RULE"));
        this._tableModel.addColumn(ListenerArb.getString("COL_HDR_RESTFUL_SCHEMA"));
        this._tableModel.addColumn(ListenerArb.getString("COL_HDR_RESTFUL_WORKSPACE"));
        this._tableModel.addColumn(ListenerArb.getString("COL_HDR_UPDATED"));
        this._table = new JTable(this._tableModel){

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return new DefaultCellEditor(new JComboBox<String>(ListenerURLMappingPanel.this.getRuleTypes()));
                    }
                    case 1: {
                        return new DefaultCellEditor(new JTextField());
                    }
                    case 2: {
                        return new DefaultCellEditor(new JTextField());
                    }
                    case 3: {
                        return new DefaultCellEditor(new JTextField());
                    }
                }
                return new DefaultCellEditor(new JTextField());
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return new CustomCellRenderer();
            }
        };
        TableColumn tableColumn = this._table.getColumnModel().getColumn(4);
        this._table.removeColumn(tableColumn);
        JTextPane jTextPane = new JTextPane();
        jTextPane = new JTextPane();
        jTextPane.setText(ListenerArb.getString("URL_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        this._table.setPreferredScrollableViewportSize(new Dimension(200, 200));
        JScrollPane jScrollPane = new JScrollPane(this._table);
        JButton jButton = new JButton();
        jButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        jButton.setToolTipText(ListenerArb.getString("ADD_URL_BUTTON"));
        JButton jButton2 = new JButton();
        jButton2.setIcon(OracleIcons.getIcon((String)"delete.png"));
        jButton2.setToolTipText(ListenerArb.getString("REMOVE_URL_BUTTON"));
        Toolbar toolbar = new Toolbar();
        toolbar.setFloatable(false);
        toolbar.add((Component)jButton);
        toolbar.add((Component)jButton2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        int n = 0;
        if (jTextPane != null) {
            this.add((Component)jTextPane, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 1, new Insets(8, 0, 8, 8), 0, 0));
        }
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 1, 2, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 8), 0, 0));
        this._table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (ListenerURLMappingPanel.this._table.getEditingColumn() > -1 && ListenerURLMappingPanel.this._table.getEditingRow() > -1) {
                    ListenerURLMappingPanel.this._table.getCellEditor(ListenerURLMappingPanel.this._table.getEditingRow(), ListenerURLMappingPanel.this._table.getEditingColumn()).stopCellEditing();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListenerURLMappingPanel.this.addRow(null, null, null, null, null);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                while (ListenerURLMappingPanel.this._table.getSelectedRowCount() > 0) {
                    ListenerURLMappingPanel.this._tableModel.removeRow(ListenerURLMappingPanel.this._table.getSelectedRow());
                }
            }
        });
    }

    private void addRow(String string, String string2, String string3, String string4, String string5) {
        this._tableModel.addRow(new Object[]{string, string2, string3, string4, string5});
    }

    public void addURLPattern() {
        if (this._model.getUrlMappings() != null && this._model.getUrlMappings().getURLPatterns() != null) {
            for (ListenerURLMappings.URLPattern uRLPattern : this._model.getUrlMappings().getURLPatterns()) {
                if (uRLPattern == null) continue;
                this.addRow(uRLPattern.getRuleType().getNLSName(), uRLPattern.getURLPattern(), uRLPattern.getSchema(), uRLPattern.getWorkspace(), uRLPattern.getUpdated());
            }
        }
    }

    private void setURLPatterns() {
        if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
        ListenerURLMappings.ROUTING_RULE_TYPE rOUTING_RULE_TYPE = null;
        HashSet<String> hashSet = this.getLookupURLMap(this._model.getUrlMappings().getURLPatterns());
        ListenerURLMappings listenerURLMappings = this._model.getUrlMappings();
        listenerURLMappings.setURLPatterns(null);
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String string = (String)this._table.getModel().getValueAt(i, 1);
            String string2 = (String)this._table.getModel().getValueAt(i, 0);
            if (this.isEmpty(string) || this.isEmpty(string2)) continue;
            int n = this.getRuleTypeIndex(string2);
            rOUTING_RULE_TYPE = ListenerURLMappings.ROUTING_RULE_TYPE.values()[n];
            String string3 = (String)this._table.getModel().getValueAt(i, 2);
            String string4 = (String)this._table.getModel().getValueAt(i, 3);
            String string5 = (String)this._table.getModel().getValueAt(i, 4);
            if (!hashSet.contains(this.mappingLookupKey(rOUTING_RULE_TYPE, string, string3, string4))) {
                string5 = Timestamps.toString((long)System.currentTimeMillis());
            }
            listenerURLMappings.addURLPattern(rOUTING_RULE_TYPE, string, string3, string4, string5);
        }
    }

    private HashSet<String> getLookupURLMap(List<ListenerURLMappings.URLPattern> list) {
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            for (ListenerURLMappings.URLPattern uRLPattern : list) {
                hashSet.add(this.mappingLookupKey(uRLPattern.getRuleType(), uRLPattern.getURLPattern(), uRLPattern.getSchema(), uRLPattern.getWorkspace()));
            }
        }
        return hashSet;
    }

    private String mappingLookupKey(ListenerURLMappings.ROUTING_RULE_TYPE rOUTING_RULE_TYPE, String string, String string2, String string3) {
        String string4 = (rOUTING_RULE_TYPE == null ? EMPTY : rOUTING_RULE_TYPE.getType()) + DOT + (this.isEmpty(string) ? EMPTY : string.trim()) + DOT + (this.isEmpty(string2) ? EMPTY : string2.trim()) + DOT + (this.isEmpty(string3) ? EMPTY : string3.trim());
        return string4;
    }

    private int getRuleTypeIndex(String string) {
        for (ListenerURLMappings.ROUTING_RULE_TYPE rOUTING_RULE_TYPE : ListenerURLMappings.ROUTING_RULE_TYPE.values()) {
            if (!rOUTING_RULE_TYPE.getNLSName().equals(string)) continue;
            return rOUTING_RULE_TYPE.ordinal();
        }
        return 0;
    }

    private String[] getRuleTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ListenerURLMappings.ROUTING_RULE_TYPE rOUTING_RULE_TYPE : ListenerURLMappings.ROUTING_RULE_TYPE.values()) {
            arrayList.add(rOUTING_RULE_TYPE.getNLSName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty() || string.trim().length() == 0;
    }

    public boolean isValidURLMap() {
        if (this._table != null && this._table.getCellEditor() != null && this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            String string = (String)this._table.getModel().getValueAt(i, 1);
            String string2 = (String)this._table.getModel().getValueAt(i, 0);
            String string3 = (String)this._table.getModel().getValueAt(i, 2);
            String string4 = (String)this._table.getModel().getValueAt(i, 3);
            if ((string2 == null || string2.trim().length() == 0) && string != null && string.trim().length() != 0) {
                stringBuffer.append(ListenerArb.format("URL_MAP_ROW_RULE_TYPE_MISSING", Integer.toString(i + 1))).append("\n");
                continue;
            }
            if ((string == null || string.trim().length() == 0) && string2 != null && string2.trim().length() != 0) {
                stringBuffer.append(ListenerArb.format("URL_MAP_ROW_MISSING_PREFIX", Integer.toString(i + 1))).append("\n");
                continue;
            }
            if ((string3 == null || string3.trim().length() == 0) && (string4 == null || string4.trim().length() == 0) || string != null && string.trim().length() != 0 || string2 != null && string2.trim().length() != 0) continue;
            stringBuffer.append(ListenerArb.format("URL_MAP_ROW_MISSING_BOTH", Integer.toString(i + 1))).append("\n");
        }
        if (stringBuffer.length() > 0) {
            this.showErrors(stringBuffer.toString());
            return false;
        }
        return true;
    }

    private void showErrors(String string) {
        MessageDialog.error(null, (Object)string, (String)ListenerArb.getString("URL_ERROR_TITLE"), null);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        ListenerModel listenerModel3 = this._model = listenerModel2 == null ? listenerModel : listenerModel2;
        if (this._model != null && this._model.getUrlMappings() != null) {
            this.addURLPattern();
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getUrlMappings() != null) {
            this.setURLPatterns();
        }
        return this._model;
    }

    @Override
    public boolean resetSettings() {
        return false;
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl2) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
            } else {
                component.setBackground(Color.WHITE);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }
}

