/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.model;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.listener.ListenerArb;

public class ListenerURLMappings
implements Cloneable {
    public static final String RULETYPE_PATH = "base-path";
    public static final String RULETYPE_URL = "base-url";
    public static final String RULETYPE_REGEXPR = "uri-pattern";
    private List<URLPattern> _URLPatterns;
    private List<String> _errMsgs;

    public void setURLPatterns(List<URLPattern> list) {
        this._URLPatterns = list;
    }

    public List<URLPattern> getURLPatterns() {
        return this._URLPatterns;
    }

    public boolean addURLPattern(ROUTING_RULE_TYPE rOUTING_RULE_TYPE, String string, String string2, String string3, String string4) {
        if (this.isValidURLPattern(rOUTING_RULE_TYPE, string, string2, string3)) {
            if (this._URLPatterns == null) {
                this._URLPatterns = new ArrayList<URLPattern>();
            }
            if (string4 == null) {
                string4 = Timestamps.toString((long)System.currentTimeMillis());
            }
            this._URLPatterns.add(new URLPattern(rOUTING_RULE_TYPE, string, string2, string3, string4));
            return true;
        }
        return false;
    }

    public boolean deleteURLPattern(ROUTING_RULE_TYPE rOUTING_RULE_TYPE, String string, String string2, String string3) {
        for (int i = 0; i < this._URLPatterns.size(); ++i) {
            URLPattern uRLPattern = this._URLPatterns.get(i);
            if (!uRLPattern.isEqual(rOUTING_RULE_TYPE, string, string2, string3)) continue;
            this._URLPatterns.remove(i);
            return true;
        }
        return false;
    }

    private boolean isValidURLPattern(ROUTING_RULE_TYPE rOUTING_RULE_TYPE, String string, String string2, String string3) {
        if (this._errMsgs == null) {
            this._errMsgs = new ArrayList<String>();
        } else {
            this._errMsgs.clear();
        }
        if (rOUTING_RULE_TYPE == null) {
            this._errMsgs.add(ListenerArb.getString("URL_MAP_RULE_TYPE_MISSING"));
        }
        if (string == null || string.isEmpty()) {
            this._errMsgs.add(ListenerArb.getString("URL_MAP_ROUTE_RULE_MISSING"));
        }
        if (this.isURLPatternExists(rOUTING_RULE_TYPE, string, string2, string3)) {
            this._errMsgs.add(ListenerArb.getString("URL_MAP_ROUTE_RULE_EXISTS"));
        }
        return this._errMsgs.isEmpty();
    }

    public List<String> getErrorMessages() {
        if (this._errMsgs == null) {
            this._errMsgs = new ArrayList<String>();
        }
        return this._errMsgs;
    }

    private boolean isURLPatternExists(ROUTING_RULE_TYPE rOUTING_RULE_TYPE, String string, String string2, String string3) {
        if (this._URLPatterns == null) {
            return false;
        }
        for (URLPattern uRLPattern : this._URLPatterns) {
            if (!uRLPattern.isEqual(rOUTING_RULE_TYPE, string, string2, string3)) continue;
            return true;
        }
        return false;
    }

    public ListenerURLMappings clone() throws CloneNotSupportedException {
        ListenerURLMappings listenerURLMappings = (ListenerURLMappings)super.clone();
        listenerURLMappings._errMsgs = null;
        return listenerURLMappings;
    }

    public static enum ROUTING_RULE_TYPE {
        BASE_PATH("base-path", ListenerArb.getString("RULE_TYPE_PATH")),
        BASE_URL("base-url", ListenerArb.getString("RULE_TYPE_URL")),
        REG_EXPR("uri-pattern", ListenerArb.getString("RULE_TYPE_REG_EXPR"));

        private String type;
        private String nlsName;

        private ROUTING_RULE_TYPE(String string2, String string3) {
            this.type = string2;
            this.nlsName = string3;
        }

        public String getType() {
            return this.type;
        }

        public String getNLSName() {
            return this.nlsName;
        }
    }

    public class URLPattern {
        private static final String EMPTY = "";
        private static final String DOT = ".";
        private ROUTING_RULE_TYPE _ruleType;
        private String _URLPattern;
        private String _schema;
        private String _workspace;
        private String _updated;

        public URLPattern() {
        }

        public URLPattern(ROUTING_RULE_TYPE rOUTING_RULE_TYPE, String string, String string2, String string3, String string4) {
            this._ruleType = rOUTING_RULE_TYPE;
            this._URLPattern = string != null ? string.trim() : string;
            this._schema = string2 != null ? string2.trim() : string2;
            this._workspace = string3 != null ? string3.trim() : string3;
            this._updated = string4;
        }

        public void setRuleType(ROUTING_RULE_TYPE rOUTING_RULE_TYPE) {
            this._ruleType = rOUTING_RULE_TYPE;
        }

        public ROUTING_RULE_TYPE getRuleType() {
            return this._ruleType;
        }

        public void setURLPattern(String string) {
            this._URLPattern = string;
        }

        public String getURLPattern() {
            return this._URLPattern;
        }

        public void setSchema(String string) {
            this._schema = string;
        }

        public String getSchema() {
            return this._schema;
        }

        public void setWorkspace(String string) {
            this._workspace = string;
        }

        public String getWorkspace() {
            return this._workspace;
        }

        public void setUpdated(String string) {
            this._updated = string;
        }

        public String getUpdated() {
            return this._updated;
        }

        public boolean isEqual(ROUTING_RULE_TYPE rOUTING_RULE_TYPE, String string, String string2, String string3) {
            return this.formatPatternSchema(rOUTING_RULE_TYPE, string, string2, string3).equals(this.formatPatternSchema(this._ruleType, this._URLPattern, this._schema, this._workspace));
        }

        private String formatPatternSchema(ROUTING_RULE_TYPE rOUTING_RULE_TYPE, String string, String string2, String string3) {
            String string4 = (rOUTING_RULE_TYPE == null ? EMPTY : rOUTING_RULE_TYPE.getType()) + DOT + (this.isEmpty(string) ? EMPTY : string.trim()) + DOT + (this.isEmpty(string2) ? EMPTY : string2.trim()) + DOT + (this.isEmpty(string3) ? EMPTY : string3.trim());
            return string4;
        }

        private boolean isEmpty(String string) {
            return string == null || string.isEmpty() || string.trim().length() == 0;
        }
    }
}

