/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.gss.util.NLSLocaleInfo;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.util.LocaleMapper;

public class NLSLocale {
    public static final int NLSCHARSET = 0;
    public static final int JAVACHARSET = 1;
    public static final int IANACHARSET = 2;
    private static OraMapTable ISO_ORACLE_NAME_MAPPING = null;
    private Enumeration m_enumJavaLocales;
    private Enumeration m_enumNLSLocales;
    private Locale[] m_comLocales = null;

    NLSLocale() {
    }

    public static NLSLocale getInstance(int n) {
        return NLSLocale.getInstance();
    }

    public static synchronized NLSLocale getInstance() {
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        return new NLSLocaleInfo();
    }

    public Locale getJavaLocale(String string) {
        return LocaleMapper.getJavaLocale(string);
    }

    public Locale getJavaLocale(String string, String string2) {
        return LocaleMapper.getJavaLocale(string, string2);
    }

    public String getJavaLanguage(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_LANG_2_ISO_A2_LANG");
        return (String)hashMap.get(string.toUpperCase(Locale.US));
    }

    public String getJavaTerritory(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_TERR_2_ISO_A2_TERR");
        return (String)hashMap.get(string.toUpperCase(Locale.US));
    }

    private Locale[] getCommonLocales() {
        if (this.m_comLocales == null) {
            String[] stringArray = ISO_ORACLE_NAME_MAPPING.getStringArrayAttribute("COMMON_LOCALES");
            this.m_comLocales = new Locale[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_comLocales[i] = LocaleMapper.getLocaleFromString(stringArray[i]);
            }
        }
        return this.m_comLocales;
    }

    public synchronized Enumeration enumNLSLocales() {
        if (this.m_enumNLSLocales == null) {
            Locale[] localeArray = this.getCommonLocales();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < localeArray.length; ++i) {
                arrayList.add(LocaleMapper.getOraLocale(localeArray[i]));
            }
            this.m_enumNLSLocales = Collections.enumeration(arrayList);
        }
        return this.m_enumNLSLocales;
    }

    public synchronized Enumeration enumJavaLocales() {
        if (this.m_enumJavaLocales == null) {
            Locale[] localeArray = this.getCommonLocales();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < localeArray.length; ++i) {
                arrayList.add(localeArray[i].toString());
            }
            this.m_enumJavaLocales = Collections.enumeration(arrayList);
        }
        return this.m_enumJavaLocales;
    }

    public String getJavaCharset(String string) {
        return this.getJavaCharset(0, string);
    }

    public String getJavaCharset(int n, String string) {
        String string2;
        switch (n) {
            case 0: {
                string2 = LocaleMapper.getJavaCharacterSet(1, string);
                break;
            }
            case 2: {
                string2 = LocaleMapper.getJavaCharacterSet(2, string);
                break;
            }
            default: {
                string2 = string;
            }
        }
        return "".equals(string2) ? null : string2;
    }

    public String getNLSCharset(int n, String string) {
        String string2;
        switch (n) {
            case 1: {
                string2 = LocaleMapper.getOraCharacterSet(3, string);
                break;
            }
            case 2: {
                string2 = LocaleMapper.getOraCharacterSet(2, string);
                break;
            }
            default: {
                string2 = string;
            }
        }
        return "".equals(string2) ? null : string2;
    }

    public String getIANACharset(int n, String string) {
        String string2;
        switch (n) {
            case 0: {
                string2 = LocaleMapper.getIANACharacterSet(1, string);
                break;
            }
            case 1: {
                string2 = LocaleMapper.getIANACharacterSet(3, string);
                break;
            }
            default: {
                return string;
            }
        }
        return "".equals(string2) ? null : string2;
    }

    public String getNLSCharset(String string) {
        return this.getNLSCharset(1, string);
    }

    public Enumeration enumNLSCharsets() {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("NLS_CHARSET_2_JAVA_CHARSET");
        HashMap hashMap2 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_2_IANA");
        Vector vector = new Vector();
        vector.addAll(hashMap.keySet());
        vector.removeAll(hashMap2.keySet());
        vector.addAll(hashMap2.keySet());
        Collections.sort(vector);
        return Collections.enumeration(vector);
    }

    public Enumeration enumJavaCharsets() {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_NLS_CHARSET");
        Vector vector = new Vector();
        vector.addAll(hashMap.keySet());
        Collections.sort(vector);
        return Collections.enumeration(vector);
    }

    public Enumeration enumIANACharsets() {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_2_ORACLE");
        Map map = ISO_ORACLE_NAME_MAPPING.getElementAttributes("IANA_2_ORACLE");
        Vector vector = new Vector();
        Set set = hashMap.keySet();
        vector.addAll(set);
        HashSet hashSet = new HashSet();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            Map map2 = (Map)map.get(e);
            if (!"invalid".equals(map2.get("p1"))) continue;
            hashSet.add(e);
        }
        vector.removeAll(hashSet);
        Collections.sort(vector);
        return Collections.enumeration(vector);
    }

    public String getNLSLocale() {
        return this.getNLSLocale(Locale.getDefault());
    }

    public String getNLSLocale(Locale locale) {
        return LocaleMapper.getOraLocale(locale);
    }

    public String getNLSLanguage(Locale locale) {
        return LocaleMapper.getOraLanguage(locale);
    }

    public String getNLSTerritory(Locale locale) {
        return LocaleMapper.getOraTerritory(locale);
    }

    public String getNLSLanguage(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_LANG_2_ORACLE_LANG");
        return (String)hashMap.get(string);
    }

    public String getNLSTerritory(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_TERR_2_ORACLE_TERR");
        return (String)hashMap.get(string.toUpperCase(Locale.US));
    }
}

