/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartDeployCloudUtil;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.JTextFieldLimit;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.cloud.controls.CloudConnectionComboBox;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;
import oracle.ide.util.ResourceUtils;
import oracle.jdbc.OracleConnection;

public class DbCartDeployAuthPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int PREFERENCES = 0;
    public static int WIZARD = 1;
    public static String USER = DbCartAddinArb.getString("USER_AUTH");
    public static String KEY_FILE = DbCartAddinArb.getString("KEY_FILE_AUTH");
    public static final String KEY_FILE_PATH = "KEY_FILE_PATH";
    public static String[] AUTHS = new String[]{USER, KEY_FILE};
    private JPanel _authPanel;
    private JPanel _userPanel;
    CloudConnectionComboBox _cloudConns;
    JLabel _lblSchema = new JLabel();
    JComboBox<String> _cmbSchema = new JComboBox();
    private JLabel _labelTitle = new JLabel();
    private JTextField _textTitle = new JTextField();
    private int m_usage;
    private Connection _conn;
    private String _connName = "";
    private boolean _isConnClone;
    private String _user;
    private String _server;
    private int _port;
    char[] _sftpPass;

    public DbCartDeployAuthPanel() {
        this(WIZARD);
    }

    public DbCartDeployAuthPanel(int n) {
        this.m_usage = n;
    }

    public JPanel getPanel() {
        this._connName = "";
        this._conn = null;
        this._isConnClone = false;
        this._authPanel = new JPanel(new GridBagLayout());
        this._userPanel = new JPanel(new GridBagLayout());
        this._cloudConns = new CloudConnectionComboBox();
        JComboBox jComboBox = this._cloudConns.getComboBox();
        jComboBox.setToolTipText(DbCartAddinArb.getString("CLOUD_CONNECTION_TIP"));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jComboBox, (String)DbCartAddinArb.getString("CLOUD_CONNECTION"));
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DbCartDeployAuthPanel.this.updateConnectionDetails((String)itemEvent.getItem());
                }
            }
        });
        this.updateConnectionDetails(this._cloudConns.getCurrentConnectionName());
        ResourceUtils.resLabel((JLabel)this._lblSchema, this._cmbSchema, (String)ControlsArb.getString((String)"_LABEL_SCHEMA"));
        this._cmbSchema.getAccessibleContext().setAccessibleName(ControlsArb.getString((String)"LABEL_SCHEMA"));
        this._authPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._authPanel.add((Component)jComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        this._authPanel.add((Component)this._lblSchema, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._authPanel.add(this._cmbSchema, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.5, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        this._labelTitle.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("DEPLOY_TITLE")));
        this._labelTitle.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("DEPLOY_TITLE")));
        this._labelTitle.setLabelFor(this._textTitle);
        this._textTitle.setDocument(new JTextFieldLimit(30));
        this._textTitle.setText(DbCartUtil.getTabPageName());
        this._authPanel.add((Component)this._labelTitle, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._authPanel.add((Component)this._textTitle, new GridBagConstraints(1, 2, 3, 1, 1.0, 1.0, 17, 2, new Insets(8, 8, 8, 8), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._authPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._userPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        JLabel jLabel2 = new JLabel(DbCartAddinArb.getString("CLOUD"));
        TitledPane titledPane = new TitledPane((Component)jLabel2, (Component)jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)titledPane, "Center");
        return jPanel3;
    }

    public int getUsage() {
        return this.m_usage;
    }

    public String getUser() {
        return this._user;
    }

    public String getTitle() {
        return this._textTitle.getText();
    }

    public void setTitle(String string) {
        this._textTitle.setText(string);
    }

    public char[] getPass() {
        return this._sftpPass;
    }

    public String getConnName() {
        this.updateConnectionDetails(this._cloudConns.getCurrentConnectionName());
        return this._cloudConns.getCurrentConnectionName();
    }

    public Connection getConnection() {
        return this._conn;
    }

    public boolean isCloneConn() {
        return this._isConnClone;
    }

    public JComboBox getConnJCombo() {
        return this._cloudConns.getComboBox();
    }

    public boolean isPdbCloud() {
        if (this._cloudConns != null && this._cloudConns.getCurrentConnectionName() != null) {
            return DbCartDeployCloudUtil.isPdbCloud(this._cloudConns.getCurrentConnectionName());
        }
        return false;
    }

    public String getSchema() {
        try {
            if (this._cmbSchema.isVisible()) {
                if (this._cmbSchema.getSelectedItem() == null) {
                    return this.getConnection().getSchema();
                }
                return (String)this._cmbSchema.getSelectedItem();
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return null;
    }

    public JComboBox getSchemaJCombo() {
        return this._cmbSchema;
    }

    public String getServer() {
        return this._server;
    }

    public int getPort() {
        return this._port;
    }

    public void updateConnectionDetails(String string) {
        if (string != null && !string.isEmpty() && !this._connName.equals(string)) {
            String string2;
            boolean bl;
            this._connName = string;
            SessionInfo.SftpInfo sftpInfo = DbCartDeployCloudUtil.getSftpInfo(string);
            SessionInfo.OssInfo ossInfo = DbCartDeployCloudUtil.getOssInfo(string);
            boolean bl2 = bl = ossInfo != null && ossInfo.isOssEnabled();
            if (bl) {
                this._user = ossInfo.getOssUserName();
                this._server = string2 = ossInfo.getOssServiceUrl();
                this._port = 0;
            } else if (sftpInfo != null) {
                this._user = sftpInfo.getSftpUser();
                this._server = sftpInfo.getSftpHost();
                this._port = sftpInfo.getSftpPort();
                this._sftpPass = sftpInfo.getSftpPass();
            } else {
                this._user = "";
                this._server = "";
                this._port = 22;
            }
            if (DbCartDeployCloudUtil.isPdbCloud(string)) {
                try {
                    if (this._conn != null && this._isConnClone) {
                        this._conn.close();
                    }
                    this._conn = Connections.getInstance().cloneConnection(string);
                    this._isConnClone = true;
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                }
                this._authPanel.remove(this._cmbSchema);
                string2 = this.getSchemaModel(this._conn);
                if (string2 != null) {
                    string2.setDelayed(false);
                    this._cmbSchema = new JComboBox(string2);
                    this._cmbSchema.setEnabled(true);
                    this._lblSchema.setEnabled(true);
                }
                this._lblSchema.setVisible(true);
                this._cmbSchema.setVisible(true);
                this._authPanel.add(this._cmbSchema, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.5, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
            } else {
                try {
                    this._conn = Connections.getInstance().getConnection(string);
                    this._isConnClone = false;
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                }
                this._lblSchema.setVisible(false);
                this._cmbSchema.setVisible(false);
            }
        } else if (string == null || string.isEmpty()) {
            this._lblSchema.setVisible(false);
            this._cmbSchema.setVisible(false);
        }
    }

    private SQLComboxModel getSchemaModel(Connection connection) {
        SQLComboxModel sQLComboxModel = null;
        if (connection != null) {
            sQLComboxModel = new SQLComboxModel(connection, "select username from sys.all_users union select 'ALL' from dual order by username", null, this.getSchemaName(connection));
            sQLComboxModel.setDelayed(true);
        }
        return sQLComboxModel;
    }

    protected String getSchemaName(Connection connection) {
        if (connection != null) {
            try {
                if (connection != null && connection instanceof OracleConnection) {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string = dBUtil.executeReturnOneCol("select USER from dual");
                    if (string != null) {
                        return string;
                    }
                }
                return connection.getMetaData().getUserName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Connection resetClonedConnection() {
        this.closeConnectionClone();
        try {
            this._conn = Connections.getInstance().cloneConnection(this._connName);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
            ExceptionHandler.handleException((Throwable)exception);
            this._conn = null;
        }
        this._isConnClone = this._conn != null;
        return this._conn;
    }

    public void closeConnectionClone() {
        try {
            if (this._conn != null && this._isConnClone) {
                this._conn.close();
                this._conn = null;
                this._isConnClone = false;
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }
}

