/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import java.util.HashMap;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.model.TechnologyScope;
import oracle.jdeveloper.wizard.apptemplate.WizardDefaultsProvider;

public class WizardDefaultsProviderManager {
    private static WizardDefaultsProviderManager INSTANCE = null;
    private Map<String, Map<String, String>> techScope2KeyValues = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, MetaClass<? extends WizardDefaultsProvider>>> techScope2KeyMetas = new HashMap<String, Map<String, MetaClass<? extends WizardDefaultsProvider>>>();

    private WizardDefaultsProviderManager() {
    }

    public static WizardDefaultsProviderManager getManager() {
        if (INSTANCE == null) {
            INSTANCE = new WizardDefaultsProviderManager();
        }
        return INSTANCE;
    }

    public void registerDefaultsByDelegate(String wizardKey, MetaClass<? extends WizardDefaultsProvider> delegate, String techScopeKey) {
        if (this.techScope2KeyMetas.containsKey(techScopeKey) && this.techScope2KeyMetas.get(techScopeKey).containsKey(wizardKey) || this.techScope2KeyValues.containsKey(techScopeKey) && this.techScope2KeyValues.get(techScopeKey).containsKey(wizardKey)) {
            throw new IllegalStateException("cannot register a second defaults delegator for tech scope " + techScopeKey);
        }
        if (!this.techScope2KeyMetas.containsKey(techScopeKey)) {
            this.techScope2KeyMetas.put(techScopeKey, new HashMap());
        }
        this.techScope2KeyMetas.get(techScopeKey).put(wizardKey, delegate);
    }

    public void registerDefaultsByValue(String wizardKey, String value, String techScopeKey) {
        if (this.containsDefaultForKey(techScopeKey, wizardKey)) {
            throw new IllegalStateException("cannot register a second defaults delegator for tech scope " + techScopeKey);
        }
        if (!this.techScope2KeyValues.containsKey(techScopeKey)) {
            this.techScope2KeyValues.put(techScopeKey, new HashMap());
        }
        this.techScope2KeyValues.get(techScopeKey).put(wizardKey, value);
    }

    public boolean containsDefaultForKey(String techScopeKey, String wizardKey) {
        return this.techScope2KeyMetas.containsKey(techScopeKey) && this.techScope2KeyMetas.get(techScopeKey).containsKey(wizardKey) || this.techScope2KeyValues.containsKey(techScopeKey) && this.techScope2KeyValues.get(techScopeKey).containsKey(wizardKey);
    }

    public boolean containsDefaultForTechnologyScope(TechnologyScope techScope, String wizardKey) {
        for (String techKey : techScope.getTechnologyKeys()) {
            if (!this.containsDefaultForKey(techKey, wizardKey)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultForTechScope(TechnologyScope techScope, String wizardKey) {
        for (String techScopeKey : techScope.getTechnologyKeys()) {
            if (this.techScope2KeyValues.containsKey(techScopeKey)) {
                return this.techScope2KeyValues.get(techScopeKey).get(wizardKey);
            }
            if (!this.techScope2KeyMetas.containsKey(techScopeKey)) continue;
            MetaClass<? extends WizardDefaultsProvider> meta = this.techScope2KeyMetas.get(techScopeKey).get(wizardKey);
            try {
                Class clazz = meta.toClass();
                WizardDefaultsProvider wdp = (WizardDefaultsProvider)clazz.newInstance();
                return wdp.getDefaultFor(wizardKey);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to load meta class " + meta.toString(), cnfe);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Unable to instatntiate meta class " + meta.toString(), e);
            }
        }
        return null;
    }
}

