/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.template.AbstractTemplate;
import oracle.jdeveloper.template.ApplicationTemplate;
import oracle.jdeveloper.template.DefaultTemplateData;
import oracle.jdeveloper.template.ProjectTemplate;
import oracle.jdeveloper.template.TemplateData;
import oracle.jdeveloper.template.TemplateFactory;
import oracle.jdeveloper.template.TemplateManager;
import oracle.jdeveloper.template.TemplateRegistrar;
import oracle.jdeveloper.template.TemplateUtils;

public class TemplateManagerImpl
extends TemplateManager {
    private ArrayList<TemplateData> templateData_ = new ArrayList();
    private DefaultTemplateData defaultTemplateData_ = new DefaultTemplateData(DEFAULT_TEMPLATEDATA_URL);
    private Logger logger_ = Logger.getLogger(TemplateManager.class.getName());
    static final String TEMPLATES_ROOT_ELEMENT = "templates";
    static final String TEMPLATE_DATA_FILE = "template-data.xml";
    static final String TEMPLATES_FILE = "templates.xml";
    static final URL DEFAULT_TEMPLATEDATA_URL = URLFactory.newURL((String)"http://xmlns.oracle.com/ide/extension/templates");

    public TemplateManagerImpl() {
        this.init();
        TemplateRegistrar.getInstance().registerAllTemplates(this);
    }

    @Override
    public List<ProjectTemplate> getProjectTemplates() {
        return this.getTemplatesForClass(ProjectTemplate.class);
    }

    @Override
    public List<ApplicationTemplate> getApplicationTemplates() {
        return this.getTemplatesForClass(ApplicationTemplate.class);
    }

    @Override
    public List<AbstractTemplate> getAllTemplates() {
        ArrayList<AbstractTemplate> list = new ArrayList<AbstractTemplate>();
        list.addAll(this.defaultTemplateData_.getAllTemplates());
        for (TemplateData td : this.templateData_) {
            list.addAll(td.getAllTemplates());
        }
        return list;
    }

    public AbstractTemplate getTemplateById(String id) {
        Assert.precondition((id != null ? 1 : 0) != 0);
        for (int i = this.templateData_.size() - 1; i >= 0; --i) {
            AbstractTemplate template = this.templateData_.get(i).getTemplateById(id);
            if (template == null) continue;
            return template;
        }
        Assert.printStackTrace((boolean)true, (String)("Template with id=" + id + " not found"));
        return null;
    }

    private <T> List<T> getTemplatesForClass(Class<T> clazz) {
        Assert.precondition((clazz != null ? 1 : 0) != 0);
        ArrayList<T> templates = new ArrayList<T>();
        templates.addAll(this.defaultTemplateData_.getTemplateByClass(clazz));
        for (int i = 0; i < this.templateData_.size(); ++i) {
            templates.addAll(this.templateData_.get(i).getTemplateByClass(clazz));
        }
        return templates;
    }

    @Override
    public void registerTemplate(HashStructure hash) {
        try {
            this.registerTemplate(TemplateFactory.getInstance().createTemplate(hash));
        }
        catch (ClassNotFoundException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
        catch (NoSuchMethodException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
        catch (InstantiationException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
        catch (IllegalAccessException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
        catch (InvocationTargetException e) {
            TemplateUtils.logTemplateCreationException(hash, e);
        }
    }

    @Override
    public void registerTemplate(AbstractTemplate template) {
        this.getDefaultTemplateData().addTemplate(template);
    }

    @Override
    public synchronized Logger getLogger() {
        return this.logger_;
    }

    void setLogger(Logger logger) {
        this.logger_ = logger;
    }

    @Override
    public void save(URL url) throws IOException {
        ListStructureIO io = new ListStructureIO("http://xmlns.oracle.com/ide/extension", TEMPLATES_ROOT_ELEMENT);
        ListStructure list = ListStructure.newInstance();
        for (TemplateData td : this.templateData_) {
            DefaultTemplateData dtd;
            if (td instanceof DefaultTemplateData) {
                dtd = (DefaultTemplateData)td;
            } else {
                dtd = new DefaultTemplateData(td.getURL());
                dtd.setParent(td.getParent());
                for (AbstractTemplate at : td.getAllTemplates()) {
                    dtd.addTemplate(at);
                }
            }
            list.add((Object)dtd.getHashStructure());
        }
        io.save(url, (Object)list);
    }

    @Override
    public void load(URL url) throws IOException {
        this.clear();
        ListStructureIO io = new ListStructureIO("http://xmlns.oracle.com/ide/extension", TEMPLATES_ROOT_ELEMENT);
        ListStructure list = (ListStructure)io.load(url);
        for (Object h : list) {
            HashStructure hash = (HashStructure)h;
            this.templateData_.add(new DefaultTemplateData(hash));
        }
    }

    @Override
    public void clear() {
        this.init();
    }

    private void init() {
        this.templateData_.clear();
    }

    @Override
    public DefaultTemplateData getDefaultTemplateData() {
        return this.defaultTemplateData_;
    }

    @Override
    public void setDefaultTemplateData(DefaultTemplateData td) {
        this.defaultTemplateData_ = td;
    }

    @Override
    public void addTemplateData(TemplateData templateData) {
        if (templateData.getURL() == null) {
            throw new IllegalArgumentException("Cannot add TempalateData with null URL");
        }
        for (TemplateData td : this.templateData_) {
            if (!td.getURL().toExternalForm().equals(templateData.getURL().toExternalForm())) continue;
            throw new IllegalArgumentException("Duplicate URL. Template with URL " + td.getURL() + " already exists");
        }
        this.templateData_.add(templateData);
        if (templateData instanceof DefaultTemplateData) {
            ((DefaultTemplateData)templateData).setParent(this.defaultTemplateData_);
        }
    }

    @Override
    public TemplateData removeTemplateData(TemplateData templateData) {
        Iterator<TemplateData> iter = this.templateData_.iterator();
        if (iter.hasNext()) {
            TemplateData td = iter.next();
            if (td.equals(templateData)) {
                if (td instanceof DefaultTemplateData) {
                    ((DefaultTemplateData)templateData).setParent(null);
                }
                iter.remove();
            }
            return td;
        }
        return null;
    }

    @Override
    public TemplateData removeTemplateData(URL url) {
        Iterator<TemplateData> iter = this.templateData_.iterator();
        while (iter.hasNext()) {
            TemplateData td = iter.next();
            if (!td.getURL().toString().equals(url.toString())) continue;
            if (td instanceof DefaultTemplateData) {
                ((DefaultTemplateData)td).setParent(null);
            }
            iter.remove();
            return td;
        }
        return null;
    }

    @Override
    public List<AbstractTemplate> findTemplateById(String id) {
        ArrayList<AbstractTemplate> list = new ArrayList<AbstractTemplate>();
        AbstractTemplate found = this.getDefaultTemplateData().findTemplateById(id);
        if (found != null) {
            list.add(found);
        }
        for (TemplateData td : this.templateData_) {
            found = td.findTemplateById(id);
            if (found == null) continue;
            list.add(found);
        }
        return list;
    }

    @Override
    public List<TemplateData> getAllTemplateData() {
        ArrayList<TemplateData> list = new ArrayList<TemplateData>();
        list.add(this.defaultTemplateData_);
        list.addAll(this.templateData_);
        return list;
    }

    @Override
    public TemplateData getTemplateData(URL url) {
        Assert.precondition((url != null ? 1 : 0) != 0);
        if (url.toExternalForm().equals(this.getDefaultTemplateData().getURL().toExternalForm())) {
            return this.getDefaultTemplateData();
        }
        for (TemplateData td : this.templateData_) {
            if (td.getURL() == null || url == null || !url.toExternalForm().equals(td.getURL().toExternalForm())) continue;
            return td;
        }
        return null;
    }

    static URL getDefaultTemplateDataURL() {
        return DEFAULT_TEMPLATEDATA_URL;
    }

    static URL getUserTemplateDataURL() {
        URL dirURL = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.jdeveloper");
        return URLFactory.newDirURL((URL)dirURL, (String)TEMPLATE_DATA_FILE);
    }
}

