/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;

public final class TemplateCustomizationHook
extends HashStructureHook {
    private boolean initialized = false;
    private String _defaultTemplateId;
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/customization", "template-customizations");
    private static final String DEFAULT_TEMPLATE = "default-template";
    private static final String TEMPLATE_ID = "template-id";
    private static final Logger LOGGER = Logger.getLogger(TemplateCustomizationHook.class.getName());

    public void start(ElementStartContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            super.start(context);
        }
    }

    public void end(ElementEndContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            super.end(context);
        }
    }

    public static TemplateCustomizationHook get() {
        return (TemplateCustomizationHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    public boolean isDefaultTemplateDefined() {
        return this.getDefaultTemplateId() != null;
    }

    public String getDefaultTemplateId() {
        this.initializeHook();
        return this._defaultTemplateId;
    }

    private void initializeHook() {
        if (!this.initialized) {
            this.initialized = true;
            this.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    Assert.printStackTrace((Throwable)new IllegalStateException("Default template must be defined only once in the role file."));
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    HashStructure hash = e.getCombinedHashStructure();
                    TemplateCustomizationHook.this.processHook(hash);
                }
            });
        }
    }

    private void processHook(HashStructure hashStructure) {
        if (hashStructure == null) {
            return;
        }
        if (hashStructure.containsKey(DEFAULT_TEMPLATE)) {
            HashStructure defTemplateHash = hashStructure.getHashStructure(DEFAULT_TEMPLATE);
            if (defTemplateHash == null) {
                LOGGER.log(Level.SEVERE, "Default template is not defined correctly in role file");
                return;
            }
            HashStructure templateIdHash = defTemplateHash.getHashStructure(TEMPLATE_ID);
            if (templateIdHash == null) {
                LOGGER.log(Level.SEVERE, "Default template is not defined correctly in role file; template-id is missing.");
                return;
            }
            this._defaultTemplateId = templateIdHash.getString("#text");
        }
    }
}

