/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.Component;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.validate.DBValidationComponent;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.ideimpl.db.validate.DBValidationListCellRenderer;
import oracle.ideimpl.db.validate.DBValidationTreeCellRenderer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.validators.DBObjectValidationModel;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.ui.StatusIndicator;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.MultiItemTemplate;
import oracle.javatools.ui.infotip.templates.SingleItemTemplate;
import oracle.javatools.ui.infotip.templates.Template;

public abstract class DBValidationManager {
    private static Reference<Icon> s_invalidIcon;
    private static Reference<Icon> s_emptyIcon;

    public abstract DBValidationHandler createHandler(DBEditorConfig var1, ComponentFactory var2);

    public abstract DBObjectValidationModel getValidationModel();

    public Component processRendererComponent(Component component, DBObject dBObject, String string) {
        Object object;
        Object object2;
        Component component2 = component;
        DBObjectValidationModel dBObjectValidationModel = this.getValidationModel();
        if (dBObjectValidationModel != null && string != null && component instanceof JComponent) {
            object2 = DBValidationComponent.findOrCreateValidationComponent((JComponent)component, null);
            object = (Collection)dBObjectValidationModel.getValidationMap(dBObject).get(string);
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ValidationException validationException = (ValidationException)((Object)iterator.next());
                    ((DBValidationComponent)((Object)object2)).addValidationException(validationException);
                }
            }
        }
        if (component instanceof JLabel) {
            object2 = (JLabel)component;
            if (dBObjectValidationModel != null && (string == null || "name".equals(string))) {
                object = null;
                boolean bl = false;
                boolean bl2 = dBObjectValidationModel.isValid(dBObject);
                if (bl2) {
                    Object object3;
                    DBObject dBObject2 = dBObject.getParent();
                    String string2 = DBUtil.getParentProperty((DBObject)dBObject);
                    if (string2 != null && (object3 = dBObject2.getProperty(string2)) instanceof DBObject[]) {
                        boolean bl3 = false;
                        for (DBObject dBObject3 : (DBObject[])object3) {
                            if (dBObject3 == dBObject || dBObjectValidationModel.isValid(dBObject3)) continue;
                            bl3 = true;
                            break;
                        }
                        if (bl3) {
                            bl = true;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    object = bl2 ? DBValidationManager.getEmptyLabelIcon() : DBValidationManager.getInvalidLabelIcon();
                }
                ((JLabel)object2).setIcon((Icon)object);
                ((JComponent)object2).putClientProperty("DBValidationManager.ICON_KEY", object);
            } else {
                object = ((JLabel)object2).getIcon();
                if (object != null && ((JComponent)object2).getClientProperty("DBValidationManager.ICON_KEY") == object) {
                    ((JLabel)object2).setIcon(null);
                }
                ((JComponent)object2).putClientProperty("DBValidationManager.ICON_KEY", null);
            }
        }
        return component2;
    }

    public TreeCellRenderer wrapTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        return new DBValidationTreeCellRenderer(this, treeCellRenderer);
    }

    public ListCellRenderer wrapListCellRenderer(ListCellRenderer listCellRenderer) {
        return new DBValidationListCellRenderer(this, listCellRenderer);
    }

    public static TreeCellRenderer wrapTreeCellRenderer(TreeCellRenderer treeCellRenderer, Namespace namespace) {
        TreeCellRenderer treeCellRenderer2 = treeCellRenderer;
        DBValidationManager dBValidationManager = (DBValidationManager)namespace.find(DBValidationManager.class);
        if (dBValidationManager != null) {
            treeCellRenderer2 = dBValidationManager.wrapTreeCellRenderer(treeCellRenderer);
        }
        return treeCellRenderer2;
    }

    public static ListCellRenderer wrapListCellRenderer(ListCellRenderer listCellRenderer, Namespace namespace) {
        ListCellRenderer listCellRenderer2 = listCellRenderer;
        DBValidationManager dBValidationManager = (DBValidationManager)namespace.find(DBValidationManager.class);
        if (dBValidationManager != null) {
            listCellRenderer2 = dBValidationManager.wrapListCellRenderer(listCellRenderer);
        }
        return listCellRenderer2;
    }

    public static Icon getInvalidLabelIcon() {
        Icon icon;
        Reference<Icon> reference = s_invalidIcon;
        Icon icon2 = icon = reference == null ? null : reference.get();
        if (icon == null) {
            StatusIndicator statusIndicator = new StatusIndicator();
            statusIndicator.setStatus(StatusIndicator.Status.ERROR);
            icon = statusIndicator.getIcon(StatusIndicator.OkPolicy.HIDE);
            s_invalidIcon = new SoftReference<Icon>(icon);
        }
        return icon;
    }

    public static Icon getEmptyLabelIcon() {
        Icon icon;
        Reference<Icon> reference = s_emptyIcon;
        Icon icon2 = icon = reference == null ? null : reference.get();
        if (icon == null) {
            StatusIndicator statusIndicator = new StatusIndicator();
            statusIndicator.setStatus(StatusIndicator.Status.OK);
            icon = statusIndicator.getIcon(StatusIndicator.OkPolicy.HIDE);
            s_emptyIcon = new SoftReference<Icon>(icon);
        }
        return icon;
    }

    public static Icon getLabelIcon(Icon icon, boolean bl) {
        Icon icon2 = DBValidationManager.getInvalidLabelIcon();
        if (icon == icon2) {
            icon = null;
        }
        Icon icon3 = bl ? icon : icon2;
        return icon3;
    }

    public static Template createInfoTipContent(Collection<ValidationException> collection) {
        ArrayList<SingleItemTemplate> arrayList = new ArrayList<SingleItemTemplate>();
        for (ValidationException validationException : collection) {
            SingleItemTemplate singleItemTemplate = new SingleItemTemplate(SingleItemTemplate.Severity.ERROR, validationException.getMessage(), null, Collections.emptyList(), InfoTipStyles.DEFAULT);
            arrayList.add(singleItemTemplate);
        }
        Template template = null;
        if (arrayList.size() == 1) {
            template = (Template)arrayList.get(0);
        } else if (arrayList.size() > 1) {
            template = new MultiItemTemplate(arrayList);
        }
        return template;
    }
}

