/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.ExpressionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.View;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

public class OrderByPanel
extends BaseSQLQueryBuilderPanel
implements ActionListener,
DocumentListener,
ExpressionPanel.FragmentProvider {
    private SQLQueryBuilder m_builder;
    private JWrappedLabel m_desc = new JWrappedLabel(UIBundle.get("ORDERBY_DESC"));
    private ExpressionPanel m_expPanel;
    private boolean m_init;
    private JPanel m_editor;
    private JLabel m_expLabel = new JLabel();
    private JTextField m_exp = new JTextField();
    private CompletionSupport m_completionSupport;
    private JLabel m_ascLabel = new JLabel();
    private JComboBox m_asc = new JComboBox();
    private JLabel m_nullsLabel = new JLabel();
    private JComboBox m_nulls = new JComboBox();
    private JButton m_validate = new JButton();
    private JCheckBox m_chkOrderSiblings = new JCheckBox();
    private OrderByObject m_current;
    private boolean m_commitPending;
    private boolean m_new;

    @Override
    protected String getLayoutOnlyMessage(SQLQuery sQLQuery, SQLQueryBuilder sQLQueryBuilder) {
        String string = super.getLayoutOnlyMessage(sQLQuery, sQLQueryBuilder);
        if (string == null) {
            View.Restriction restriction;
            Object t = this.getUpdatedObject();
            View.Restriction restriction2 = restriction = t instanceof View ? ((View)t).getRestriction() : null;
            if (restriction != null) {
                string = UIBundle.format("ORDERBY_QUERY_RESTRICTION", restriction);
            }
        }
        return string;
    }

    @Override
    protected void layoutComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_desc, "North");
        if (this.m_expPanel == null) {
            this.m_expPanel = new ExpressionPanel(this);
        }
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper(this.getComponentNamePrefix());
        dBUIResourceHelper.resButton(this.m_chkOrderSiblings, UIBundle.get("ORDERBY_SIBLINGS"), "OrderSiblings");
        this.add(this.m_chkOrderSiblings, "Last");
        this.m_chkOrderSiblings.addActionListener(this);
        this.add(this.m_expPanel, "Center");
    }

    @Override
    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        this.m_builder = sQLQueryBuilder;
        List list = this.getProvider().getDescriptor().listBuiltInFunctions();
        if (!this.m_init) {
            this.m_expPanel.setDBObjectProvider(this.getProvider());
            this.m_expPanel.addFunctions(list);
            this.m_init = true;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        this.m_expPanel.clearTemplates();
        FromObject[] fromObjectArray = this.m_builder.listAllFromObjects();
        for (int i = 0; i < fromObjectArray.length; ++i) {
            this.m_expPanel.addTemplate((SQLFragment)fromObjectArray[i], true);
            hashSet.add(fromObjectArray[i]);
        }
        hashSet.addAll(Arrays.asList(list));
        if (this.m_completionSupport == null) {
            this.m_completionSupport = this.getCompletionSupport(this.m_exp);
        }
        OrderByObject orderByObject = dBObject instanceof OrderByObject ? (OrderByObject)dBObject : null;
        this.m_expPanel.entered((SQLFragment[])this.m_builder.getSQLQuery().getOrderByObjects(), (SQLFragment)orderByObject);
        this.m_chkOrderSiblings.setSelected(this.m_builder.getSQLQuery().isOrderSiblings());
    }

    @Override
    public void commitPanel() throws TraversalException {
        TraversableContext traversableContext = (TraversableContext)this.getDataContext();
        if (this.m_expPanel != null) {
            this.m_expPanel.exited();
        }
    }

    private void updateCurrentFrag() throws SQLQueryException {
        String string = this.m_exp.getText().trim();
        if (this.m_current != null) {
            OrderByObject orderByObject = new OrderByObject(this.m_current.getExpression(), this.m_current.getOrder(), this.m_current.getNullOrdering());
            SQLFragment sQLFragment = this.m_builder.parseOrderByExpression(string);
            this.m_current.setExpression(sQLFragment);
            this.m_current.setOrder((String)this.m_asc.getSelectedItem());
            this.m_current.setNullOrdering((String)this.m_nulls.getSelectedItem());
            if (this.m_new) {
                this.m_builder.addOrderByObject(this.m_current);
                this.m_new = false;
            } else {
                this.m_builder.replaceOrderByObject(orderByObject, this.m_current);
            }
        }
    }

    private void enableComponents(boolean bl) {
        this.m_expLabel.setEnabled(bl);
        this.m_exp.setEnabled(bl);
        this.m_ascLabel.setEnabled(bl);
        this.m_asc.setEnabled(bl);
        this.m_nullsLabel.setEnabled(bl);
        this.m_nulls.setEnabled(bl);
        this.m_validate.setEnabled(bl);
        this.m_chkOrderSiblings.setEnabled(bl && this.m_builder.getSQLQuery().getHierarchicalQueryObject() != null);
        if (!bl) {
            this.m_exp.setText(null);
            this.m_asc.setSelectedItem("");
            this.m_nulls.setSelectedItem("");
            this.m_commitPending = false;
        }
    }

    @Override
    public SQLFragment newFragment() {
        this.m_current = new OrderByObject();
        this.edit((SQLFragment)this.m_current);
        this.m_commitPending = true;
        this.m_new = true;
        return this.m_current;
    }

    @Override
    public boolean removeFragment(SQLFragment sQLFragment) {
        if (this.m_new) {
            this.m_new = false;
            return true;
        }
        return this.m_builder.removeOrderByObject((OrderByObject)sQLFragment);
    }

    @Override
    public void moveFragment(SQLFragment sQLFragment, int n) {
        this.m_builder.getSQLQuery().moveOrderByObject((OrderByObject)sQLFragment, n);
    }

    @Override
    public void commit() throws TraversalException {
        if (this.m_commitPending) {
            SQLFragment sQLFragment = this.m_current == null ? null : this.m_current.getExpression();
            String string = sQLFragment == null ? null : sQLFragment.getSQLText();
            String string2 = this.m_exp.getText().trim();
            if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
                try {
                    this.updateCurrentFrag();
                }
                catch (SQLQueryException sQLQueryException) {
                    throw new TraversalException(UIBundle.get("EXP_PARSE_ERROR") + " " + sQLQueryException.getMessage());
                }
            } else {
                this.m_current.setNullOrdering((String)this.m_nulls.getSelectedItem());
                this.m_current.setOrder((String)this.m_asc.getSelectedItem());
            }
            this.m_builder.getSQLQuery().setOrderSiblings(this.m_chkOrderSiblings.isSelected());
            this.m_commitPending = false;
        }
    }

    @Override
    public void edit(SQLFragment sQLFragment) {
        OrderByObject orderByObject = this.m_current = sQLFragment instanceof OrderByObject ? (OrderByObject)sQLFragment : null;
        if (this.m_current == null) {
            this.enableComponents(false);
        } else {
            this.enableComponents(true);
            SQLFragment sQLFragment2 = this.m_current == null ? null : this.m_current.getExpression();
            this.m_exp.getDocument().removeDocumentListener(this);
            this.m_exp.setText(sQLFragment2 == null ? "" : sQLFragment2.getSQLText());
            this.m_exp.getDocument().addDocumentListener(this);
            String string = this.m_current.getOrder();
            string = ModelUtil.hasLength((String)string) ? string.toUpperCase() : "";
            String string2 = this.m_current.getNullOrdering();
            string2 = ModelUtil.hasLength((String)string2) ? string2.toUpperCase() : "";
            this.m_asc.setSelectedItem(string);
            this.m_nulls.setSelectedItem(string2);
            this.m_exp.requestFocusInWindow();
            this.m_exp.selectAll();
            this.m_commitPending = false;
        }
    }

    @Override
    public String getComponentNamePrefix() {
        return "OrderByPanel";
    }

    @Override
    public JPanel getEditorUI() {
        if (this.m_editor == null) {
            this.m_editor = new JPanel();
            this.m_editor.setLayout(new GridBagLayout());
            this.m_editor.setName(this.getComponentNamePrefix());
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper(this.getComponentNamePrefix());
            ToolTipManager.sharedInstance().registerComponent(this.m_exp);
            dBUIResourceHelper.resLabel(this.m_expLabel, this.m_exp, UIBundle.get("EXP_EXPRESSION"), "Expression");
            this.m_editor.add((Component)this.m_expLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_editor.add((Component)this.m_exp, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_validate.addActionListener(this);
            dBUIResourceHelper.resButton(this.m_validate, UIBundle.get("EXP_VALIDATE"), "Validate");
            this.m_editor.add((Component)this.m_validate, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.m_asc.addActionListener(this);
            dBUIResourceHelper.resLabel(this.m_ascLabel, this.m_asc, UIBundle.get("ORDERBY_ASC"), "Order");
            this.m_editor.add((Component)this.m_ascLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_asc.setEditable(false);
            this.m_asc.addItem("");
            this.m_asc.addItem("ASC");
            this.m_asc.addItem("DESC");
            this.m_editor.add((Component)this.m_asc, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            dBUIResourceHelper.resLabel(this.m_nullsLabel, this.m_nulls, UIBundle.get("ORDERBY_NULLS"), "Nulls");
            this.m_editor.add((Component)this.m_nullsLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.m_nulls.addActionListener(this);
            this.m_nulls.setEditable(false);
            this.m_nulls.addItem("");
            this.m_nulls.addItem("NULLS FIRST");
            this.m_nulls.addItem("NULLS LAST");
            this.m_editor.add((Component)this.m_nulls, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.m_editor.add(Box.createVerticalGlue(), new GridBagConstraints(1, 6, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.enableComponents(false);
        return this.m_editor;
    }

    @Override
    public void addToExpression(String string) {
        OrderByPanel.addText(this.m_exp, string);
    }

    @Override
    public String getEditorName() {
        return UIBundle.get("ORDERBY_EDITOR");
    }

    @Override
    public String getListTitle() {
        return UIBundle.get("ORDERBY_LIST_TITLE");
    }

    @Override
    public String getTemplateTitle() {
        return UIBundle.get("EXP_PALETTE");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_validate) {
            try {
                this.updateCurrentFrag();
                DBObjectRenderer.setToolTipText(this.m_exp, null);
                this.m_expPanel.repaint();
            }
            catch (SQLQueryException sQLQueryException) {
                String string = sQLQueryException.getMessage();
                this.m_expPanel.showInvalidExpressionDialog(new TraversalException(string));
                DBObjectRenderer.setToolTipText(this.m_exp, string);
            }
        } else {
            this.m_commitPending = true;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }
}

