/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.plsql;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

public class TriggerBaseObjectIdPanel
extends JPanel {
    private PropertyInfo m_propertyInfo;
    private DBObjectProvider m_prov;
    private Schema m_defaultSchema;
    private JLabel m_schemaLabel;
    private DBObjectChooser m_cmbSchema;
    private JLabel m_lblRelation;
    private DBObjectChooser m_cmbRelation;
    private Trigger.BaseType m_baseType;
    private boolean m_flat;
    private Collection<DBObjectChooser.ChangeListener> m_listeners = new HashSet<DBObjectChooser.ChangeListener>();

    public void initialisePanel(ComponentContext componentContext, Schema schema, String string) {
        this.m_propertyInfo = componentContext.getPropertyInfo();
        this.m_prov = componentContext.getProvider();
        this.m_flat = componentContext.isInFlatEditor();
        this.m_defaultSchema = schema;
        String string2 = this.m_propertyInfo.getPropertyName();
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("");
        this.m_cmbSchema = new DBObjectChooser("SCHEMA");
        this.m_schemaLabel = new JLabel();
        dBUIResourceHelper.resLabel(this.m_schemaLabel, this.m_cmbSchema, UIBundle.format("LABEL_IDPROP_SCHEMA", string), string2 + "_schema");
        this.m_cmbRelation = new DBObjectChooser(this.m_cmbSchema, "TABLE", "VIEW");
        this.m_cmbRelation.setShowIcon(false);
        this.m_lblRelation = new JLabel();
        String string3 = string;
        dBUIResourceHelper.resLabel(this.m_lblRelation, this.m_cmbRelation, string3 + ":", string2 + "_object");
        this.m_cmbSchema.setProvider(this.m_prov);
        this.m_cmbSchema.setDBObject(null);
        this.setName(string2);
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this, componentContext.isInFlatEditor());
        dBUILayoutHelper.setMarginTop(0);
        dBUILayoutHelper.add(this.m_schemaLabel);
        dBUILayoutHelper.add(this.m_cmbSchema);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.m_lblRelation);
        dBUILayoutHelper.add(this.m_cmbRelation);
        dBUILayoutHelper.layout();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_cmbSchema.setEnabled(bl && (this.m_baseType == Trigger.BaseType.SCHEMA || !this.m_flat));
        this.m_schemaLabel.setEnabled(bl && (this.m_baseType == Trigger.BaseType.SCHEMA || !this.m_flat));
        this.m_cmbRelation.setEnabled(bl && (this.m_baseType == Trigger.BaseType.TABLE || this.m_baseType == Trigger.BaseType.VIEW));
        this.m_lblRelation.setEnabled(bl && (this.m_baseType == Trigger.BaseType.TABLE || this.m_baseType == Trigger.BaseType.VIEW));
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.m_cmbSchema.setVisible(bl);
        this.m_schemaLabel.setVisible(bl);
        boolean bl2 = this.m_baseType == null || this.m_baseType == Trigger.BaseType.TABLE || this.m_baseType == Trigger.BaseType.VIEW;
        this.m_cmbRelation.setVisible(bl && bl2);
        this.m_lblRelation.setVisible(bl && bl2);
    }

    private void setSelectedSchema(DBObjectID dBObjectID) {
        if (this.m_cmbSchema != null) {
            String string;
            String string2;
            if (dBObjectID instanceof BaseObjectID) {
                string2 = "SCHEMA".equals(dBObjectID.getType()) ? ((BaseObjectID)dBObjectID).getName() : ((BaseObjectID)dBObjectID).getSchemaName();
                string = ((BaseObjectID)dBObjectID).getDatabaseName();
            } else {
                string2 = DBUtil.getSchemaName((DBObjectID)dBObjectID);
                string = null;
            }
            if (ModelUtil.hasLength(string) || ModelUtil.hasLength((String)string2)) {
                NameBasedID nameBasedID = null;
                try {
                    DBObjectCriteria dBObjectCriteria = new DBObjectCriteria(Schema.class, new String[0]);
                    dBObjectCriteria.setDatabaseName(string);
                    dBObjectCriteria.setName(string2);
                    Schema schema = (Schema)this.m_prov.getObject(dBObjectCriteria);
                    if (schema != null) {
                        nameBasedID = schema.getID();
                    }
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning(dBException.getMessage());
                }
                if (nameBasedID == null) {
                    nameBasedID = new NameBasedID("SCHEMA", null, string2);
                    nameBasedID.setDatabaseName(string);
                }
                this.m_cmbSchema.setDBObjectID((DBObjectID)nameBasedID);
            } else if (this.m_defaultSchema != null && ModelUtil.areDifferent((Object)this.m_defaultSchema.getName(), (Object)this.m_prov.getDescriptor().getPublicSchemaName())) {
                this.m_cmbSchema.setDBObject((DBObject)this.m_defaultSchema);
            } else {
                try {
                    this.m_cmbSchema.setDBObject((DBObject)this.m_prov.getDefaultSchema());
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning(dBException.getMessage());
                }
            }
        }
    }

    public void setDBObjectID(DBObjectID dBObjectID) {
        DBObjectID dBObjectID2 = this.getDBObjectID();
        if (ModelUtil.areDifferent((Object)dBObjectID2, (Object)dBObjectID)) {
            if (this.m_baseType == Trigger.BaseType.SCHEMA) {
                DBObjectID dBObjectID3 = DBUtil.getUppermostParent((DBObjectID)dBObjectID);
                this.setSelectedSchema(dBObjectID3);
            } else if (this.m_baseType != Trigger.BaseType.DATABASE) {
                DBObjectID dBObjectID4 = DBUtil.getUppermostParent((DBObjectID)dBObjectID);
                this.setSelectedSchema(dBObjectID4);
                this.m_cmbRelation.setDBObjectID(dBObjectID);
            }
        }
        if (this.m_defaultSchema != null && dBObjectID == null && ModelUtil.areDifferent((Object)this.m_defaultSchema.getName(), (Object)this.m_prov.getDescriptor().getPublicSchemaName())) {
            this.m_cmbSchema.setDBObject((DBObject)this.m_defaultSchema);
        }
    }

    public DBObjectID getDBObjectID() {
        DBObjectID dBObjectID = null;
        if (this.m_baseType == Trigger.BaseType.SCHEMA) {
            dBObjectID = this.m_cmbSchema.getDBObjectID();
        } else if (this.m_baseType != Trigger.BaseType.DATABASE) {
            dBObjectID = this.m_cmbRelation.getDBObjectID();
        }
        return dBObjectID;
    }

    public void reset() {
        this.m_cmbRelation.resetCaches();
        this.m_cmbRelation.setDBObjectID(null);
    }

    public void setActiveImpl(boolean bl, boolean bl2) {
        this.m_cmbSchema.setActive(bl, bl2, bl2);
        this.m_cmbRelation.setActive(bl, bl2, bl2);
    }

    public final void addChangeListener(DBObjectChooser.ChangeListener changeListener) {
        this.setListenersOnactiveComponent(false);
        this.m_listeners.add(changeListener);
        this.setListenersOnactiveComponent(true);
    }

    public final void removeChangeListener(DBObjectChooser.ChangeListener changeListener) {
        this.setListenersOnactiveComponent(false);
        this.m_listeners.remove(changeListener);
        this.setListenersOnactiveComponent(true);
    }

    private void setListenersOnactiveComponent(boolean bl) {
        DBObjectChooser dBObjectChooser = this.m_baseType == Trigger.BaseType.SCHEMA ? this.m_cmbSchema : this.m_cmbRelation;
        for (DBObjectChooser.ChangeListener changeListener : this.m_listeners) {
            if (bl) {
                dBObjectChooser.addChangeListener(changeListener);
                continue;
            }
            dBObjectChooser.removeChangeListener(changeListener);
        }
    }

    public String getSchemaComponentName() {
        return this.m_cmbSchema == null ? null : this.m_cmbSchema.getDelegateName();
    }

    public String getDBObjectComponentName() {
        return this.m_cmbRelation == null ? null : this.m_cmbRelation.getDelegateName();
    }

    public void setBaseType(Trigger.BaseType baseType) {
        if (this.m_baseType != baseType) {
            this.setListenersOnactiveComponent(false);
            this.m_baseType = baseType;
            this.m_schemaLabel.setVisible(baseType != Trigger.BaseType.DATABASE);
            this.m_cmbSchema.setVisible(baseType != Trigger.BaseType.DATABASE);
            this.m_lblRelation.setVisible(baseType == Trigger.BaseType.TABLE || baseType == Trigger.BaseType.VIEW);
            this.m_cmbRelation.setVisible(baseType == Trigger.BaseType.TABLE || baseType == Trigger.BaseType.VIEW);
            this.m_cmbRelation.resetCaches();
            this.m_cmbRelation.setDBObjectID(null);
            if (baseType == Trigger.BaseType.TABLE) {
                this.m_cmbRelation.setFilter(dBObject -> "TABLE".equals(dBObject.getType()));
            } else if (baseType == Trigger.BaseType.VIEW) {
                this.m_cmbRelation.setFilter(dBObject -> "VIEW".equals(dBObject.getType()));
            }
            this.setListenersOnactiveComponent(true);
        }
    }
}

