/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.partition.HashPartitionComboBox;
import oracle.ideimpl.db.panels.partition.HashPartitionComboBoxListener;
import oracle.ideimpl.db.panels.partition.OraclePartitionsHandler;
import oracle.ideimpl.db.panels.partition.PartitionDetailsPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.util.ModelUtil;

class PartitionTreeDetailsPanel
extends PartitionDetailsPanel {
    private final JCheckBox m_check = new JCheckBox();
    private final PropertyChangeListener m_pcl;
    private final HashPartitionComboBox m_combo;
    private final HashPartitionComboBoxListener m_listener;
    private TitledSeparator m_subTitle;

    PartitionTreeDetailsPanel(ActionListener actionListener, PropertyChangeListener propertyChangeListener) {
        super(PartitionProperty.PARTITIONS);
        this.m_check.addActionListener(actionListener);
        this.m_pcl = propertyChangeListener;
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper(this.getName());
        this.m_combo = new HashPartitionComboBox(dBUIResourceHelper, "HashPartitionType", true);
        this.m_listener = new HashPartitionComboBoxListenerImpl();
    }

    @Override
    protected void initialiseChildComponents() {
        this.getComponentFactory().getResourceHelper().resButton(this.m_check, UIBundle.get("PART_SUBPART_TEMPLATE"), "SubPartitionTemplateCheck");
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.add(this.m_check, 2, 1, true, false);
        dBUILayoutHelper.nextRowWithGap();
        this.initialiseChildComponentsImpl(dBUILayoutHelper);
        this.initialiseSpecificChildComponents(dBUILayoutHelper);
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
        if (this.m_pcl != null) {
            ComponentWrapper componentWrapper = this.getComponentFactory().findComponentWrapper("name");
            componentWrapper.addListener(this.m_pcl);
            ComponentWrapper componentWrapper2 = this.getComponentFactory().findComponentWrapper("values");
            componentWrapper2.addListener(this.m_pcl);
        }
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        TablePartition tablePartition = (TablePartition)this.getChildObject();
        OracleTablePartitions.PartitionType partitionType = tablePartition == null ? null : tablePartition.getPartitionType();
        OracleTablePartitions.ObjectType objectType = tablePartition == null ? null : tablePartition.getObjectType();
        PropertyHelper propertyHelper = this.getPropertyHelper();
        Object t = this.getUpdatedObject();
        this.enableWrappers();
        if (tablePartition != null && partitionType == OracleTablePartitions.PartitionType.REFERENCE) {
            this.showHashComponentsImpl(null);
            this.m_check.setVisible(false);
        } else {
            OracleTablePartitions oracleTablePartitions;
            OracleTablePartitions oracleTablePartitions2;
            Object object;
            Integer n;
            Object[] objectArray = (TablePartition[])propertyHelper.getPropertyValue(t, PartitionProperty.SUBPARTITIONS_FOR_TABLE);
            boolean bl = ModelUtil.hasNonNullElement((Object[])objectArray);
            if (!bl) {
                n = (Integer)propertyHelper.getPropertyValue(t, PartitionProperty.SUBPARTITION_TEMPLATE_HASH_QUANTITY);
                bl = n != null;
            }
            n = (OracleTablePartitions)propertyHelper.getPropertyValue(t, PartitionProperty.SUBPARTITIONING_FOR_TABLE);
            boolean bl2 = tablePartition != null && objectType == OracleTablePartitions.ObjectType.PARTITION && partitionType != OracleTablePartitions.PartitionType.REFERENCE && n != null;
            boolean bl3 = false;
            if (bl2 && bl) {
                object = tablePartition.getPartitionLevelSubpartitions();
                oracleTablePartitions2 = object == null ? null : object.getPartitions();
                boolean bl4 = bl3 = object == null || oracleTablePartitions2 == null || ((TablePartition[])oracleTablePartitions2).length == 0;
                if (bl3 && object != null && object.getPartitionType() == OracleTablePartitions.PartitionType.HASH && object.getHashQuantity() != null) {
                    bl3 = false;
                }
            }
            this.m_check.setVisible(bl2);
            this.m_check.setEnabled(bl && partitionType != OracleTablePartitions.PartitionType.HASH);
            this.m_check.setSelected(!bl3 && partitionType != OracleTablePartitions.PartitionType.HASH);
            object = null;
            if (tablePartition != null && objectType == OracleTablePartitions.ObjectType.PARTITION && !bl3 && (oracleTablePartitions = (oracleTablePartitions2 = (OracleTablePartitions)tablePartition.getParent()).getSubpartitionModel()) != null && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                object = HashPartitionComboBox.Item.Default;
                OracleTablePartitions oracleTablePartitions3 = tablePartition.getPartitionLevelSubpartitions();
                if (oracleTablePartitions3 == null) {
                    oracleTablePartitions3 = oracleTablePartitions;
                }
                TablePartition[] tablePartitionArray = oracleTablePartitions3.getPartitions();
                if (oracleTablePartitions3.getHashQuantity() != null) {
                    object = HashPartitionComboBox.Item.Quantity;
                } else if (tablePartitionArray != null && tablePartitionArray.length > 0) {
                    object = HashPartitionComboBox.Item.Individual;
                }
            }
            this.showHashComponentsImpl((HashPartitionComboBox.Item)((Object)object));
            oracleTablePartitions2 = this.m_combo.getComboBox();
            oracleTablePartitions2.removeActionListener(this.m_listener);
            oracleTablePartitions2.setSelectedItem(object);
            oracleTablePartitions2.addActionListener(this.m_listener);
        }
    }

    private TablePartition enableWrappers() {
        TablePartition tablePartition = (TablePartition)this.getChildObject();
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        boolean bl = true;
        bl = oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE ? tablePartition != null && tablePartition.getParent() != null : tablePartition == null || tablePartition.getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE;
        this.enableWrapper("name", bl);
        this.enableValuesWrapper(bl);
        this.enableWrapper(Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), bl);
        this.enableWrapper("OracleInMemoryProperties", bl);
        this.enableWrapper("segmentAttributes", bl);
        this.enableLobWrapper(bl);
        return tablePartition;
    }

    private void enableWrapper(String string, boolean bl) {
        ComponentWrapper componentWrapper = this.getComponentFactory().findComponentWrapper(string);
        if (componentWrapper != null) {
            componentWrapper.setEnabled(bl);
        }
    }

    private void initialiseSpecificChildComponents(DBUILayoutHelper dBUILayoutHelper) {
        DBUILayoutHelper dBUILayoutHelper2 = dBUILayoutHelper.newTitledHelper(UIBundle.get("HASH_PARTITIONS_TITLE_SEP_LABEL"), 3, 1, true, false);
        this.m_subTitle = dBUILayoutHelper2.getTitleSeparator();
        dBUILayoutHelper2.add(this.m_combo.getLabel(), 1, 1, false, false);
        dBUILayoutHelper2.add(this.m_combo.getComboBox(), 2, 1, true, false);
        dBUILayoutHelper2.nextRow();
        ComponentWrapper componentWrapper = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_HASH_QUANTITY);
        dBUILayoutHelper2.add(componentWrapper.getLabel(), 1, 1, false, false);
        dBUILayoutHelper2.add(componentWrapper.getComponent(), 2, 1, true, false);
        dBUILayoutHelper2.nextRow();
        ComponentWrapper componentWrapper2 = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_HASH_TABLESPACES);
        dBUILayoutHelper2.add(componentWrapper2.getLabel(), 1, 1, false, false);
        dBUILayoutHelper2.add(componentWrapper2.getComponent(), 2, 1, true, false);
        dBUILayoutHelper2.nextRow();
        dBUILayoutHelper2.layout();
    }

    @Override
    protected void refreshComponents() {
        TablePartition tablePartition = (TablePartition)this.getChildObject();
        String string = PartitionProperty.PARTITIONS;
        if (tablePartition != null && tablePartition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
            string = PartitionProperty.SUBPARTITIONS_FOR_TABLE;
        }
        this.getComponentFactory().setBasePath(string);
        super.refreshComponents();
    }

    private void showHashComponentsImpl(HashPartitionComboBox.Item item) {
        ComponentWrapper componentWrapper;
        this.m_combo.setVisible(item != null);
        if (this.m_subTitle != null) {
            this.m_subTitle.setVisible(item != null);
        }
        boolean bl = item == HashPartitionComboBox.Item.Quantity;
        ComponentWrapper componentWrapper2 = this.getComponentFactory().findComponentWrapper(PartitionProperty.SUBPARTITION_HASH_QUANTITY);
        if (componentWrapper2 != null) {
            componentWrapper2.setVisible(bl);
        }
        if ((componentWrapper = this.getComponentFactory().findComponentWrapper(PartitionProperty.SUBPARTITION_HASH_TABLESPACES)) != null) {
            componentWrapper.setVisible(bl);
        }
    }

    private final class HashPartitionComboBoxListenerImpl
    extends HashPartitionComboBoxListener {
        private HashPartitionComboBoxListenerImpl() {
        }

        @Override
        final OraclePartitionsHandler getPartitionsHandler() {
            TablePartition tablePartition = (TablePartition)PartitionTreeDetailsPanel.this.getChildObject();
            OracleTablePartitions oracleTablePartitions = tablePartition.getPartitionLevelSubpartitions();
            return oracleTablePartitions == null ? null : OraclePartitionsHandler.create((DBObject)oracleTablePartitions);
        }

        @Override
        final void actionPerformedImpl(ActionEvent actionEvent) {
            HashPartitionComboBox.Item item = PartitionTreeDetailsPanel.this.m_combo.getSelectedItem();
            PartitionTreeDetailsPanel.this.showHashComponentsImpl(item);
            TablePartition tablePartition = (TablePartition)PartitionTreeDetailsPanel.this.getChildObject();
            if (item == null || item == HashPartitionComboBox.Item.Default) {
                tablePartition.setPartitionLevelSubpartitions(null);
            } else {
                OracleTablePartitions oracleTablePartitions = tablePartition.getPartitionLevelSubpartitions();
                if (oracleTablePartitions == null) {
                    oracleTablePartitions = new OracleTablePartitions();
                    tablePartition.setPartitionLevelSubpartitions(oracleTablePartitions);
                }
                oracleTablePartitions.setPartitionType(OracleTablePartitions.PartitionType.HASH);
                oracleTablePartitions.setObjectType(OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
            }
        }
    }
}

