/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.table.LobColumnPropertiesPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.property.DisplayNames;

public class LobDescriptorsPanel
extends ChildListEditorPanel<LOBDescriptor, Table> {
    public LobDescriptorsPanel() {
        super("LobDescriptorsPanel");
        this.getComponentFactory().setBasePath(PartitionProperty.PARTITIONS);
        this.setHelpID("f1_odbtalobdescriptors_html");
    }

    @Override
    protected ChildObjectEditorPanel<LOBDescriptor, Table> createChildPanel() {
        return new DetailPanel();
    }

    @Override
    protected Class<LOBDescriptor> getChildClass() {
        return LOBDescriptor.class;
    }

    @Override
    protected String getChildProperty() {
        return "LOBDescriptors";
    }

    @Override
    protected String getListLabel() {
        return DisplayNames.getPropertyDisplayName((String)"LOBDescriptors");
    }

    @Override
    protected ChildSelectableComponentEditorPanel.DefaultButtonsHelper createButtonsHelper() {
        return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public boolean includeReorderButtons() {
                return false;
            }

            @Override
            public boolean canAdd() {
                boolean bl = super.canAdd();
                bl = this.canAddAndRemove(bl);
                return bl;
            }

            @Override
            public boolean canRemove() {
                boolean bl = super.canRemove();
                bl = this.canAddAndRemove(bl);
                return bl;
            }

            private boolean canAddAndRemove(boolean bl) {
                LOBDescriptor lOBDescriptor;
                if (bl && LobDescriptorsPanel.this.getProvider() instanceof Database && (lOBDescriptor = (LOBDescriptor)LobDescriptorsPanel.this.getCurrentChild()) != null) {
                    bl = DBUtil.getOriginalID((DBObject)lOBDescriptor) == null;
                }
                return bl;
            }
        };
    }

    @Override
    protected DBObjectRenderer createItemRenderer() {
        return new LOBDescriptorListRenderer();
    }

    private static final class DetailPanel
    extends ChildObjectEditorPanel<LOBDescriptor, Table> {
        DetailPanel() {
            super("LobDescriptorsPanel", PartitionProperty.LOB_DESCRIPTORS);
        }

        @Override
        protected void initialisePanel() {
            super.initialisePanel();
            if (this.getChildObject() != null) {
                this.enableComponents();
            }
        }

        @Override
        protected void initialiseChildComponents() {
            super.initialiseChildComponents();
            DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
            dBUILayoutHelper.setMargins(0);
            ComponentWrapper componentWrapper = this.getOrCreateWrapper("columns");
            dBUILayoutHelper.add(componentWrapper.getLabel(), 4, 1);
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(componentWrapper.getComponent(), 4, 1, true, true);
            dBUILayoutHelper.nextRow();
            LobColumnPropertiesPanel.initialiseLobComponents(this, (DBEditorConfig)this.getDataContext().find(DBEditorConfig.class), dBUILayoutHelper);
            dBUILayoutHelper.layout();
            componentWrapper.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object == null) {
                        this.enableName(0);
                    } else if (object instanceof DBObjectID[]) {
                        DBObjectID[] dBObjectIDArray = (DBObjectID[])object;
                        this.enableName(dBObjectIDArray.length);
                    }
                }
            });
        }

        private void enableComponents() {
            ComponentWrapper componentWrapper = this.getOrCreateWrapper("columns");
            ComponentWrapper componentWrapper2 = this.getOrCreateWrapper("chunk");
            ComponentWrapper componentWrapper3 = this.getOrCreateWrapper("storageInRow");
            boolean bl = !(this.getProvider() instanceof Database) || this.getProvider() instanceof Database && this.getOriginalChildObject() == null;
            componentWrapper.setVisible(bl);
            componentWrapper2.setEnabled(bl);
            componentWrapper3.setEnabled(bl);
            this.enableName(((LOBDescriptor)this.getChildObject()).getColumns().length);
        }

        private void enableName(int n) {
            ComponentWrapper componentWrapper = this.getOrCreateWrapper("LOBSegName");
            boolean bl = !(this.getProvider() instanceof Database) || this.getProvider() instanceof Database && this.getOriginalChildObject() == null;
            componentWrapper.setEnabled(bl && n <= 1);
            if (n > 1) {
                componentWrapper.setPropertyValue(null);
            }
        }
    }

    private class LOBDescriptorListRenderer
    extends DBObjectRenderer {
        private LOBDescriptorListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
            LOBDescriptor lOBDescriptor = (LOBDescriptor)object;
            StringBuilder stringBuilder = new StringBuilder();
            if (lOBDescriptor.getColumns() != null) {
                boolean bl3 = false;
                for (DBObjectID dBObjectID : lOBDescriptor.getColumns()) {
                    if (bl3) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(DBUtil.getDBObjectName((DBObjectID)dBObjectID));
                    bl3 = true;
                }
            }
            jLabel.setText(stringBuilder.length() == 0 ? UIBundle.get("LOB_PARAM_NO_COLUMNS") : stringBuilder.toString());
            return jLabel;
        }
    }
}

