/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.PropertyDisplayListCellRenderer;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.components.ComponentFactoryImpl;
import oracle.ideimpl.db.panels.BaseChildrenEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ReorderableBar;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.ui.table.ReorderableTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;
import oracle.javatools.util.ModelUtil;

public abstract class ChildTableEditorPanel<C extends ChildDBObject, P extends DBObject>
extends BaseChildrenEditorPanel<C, P> {
    private ComponentWrapperTableModel m_wrapperTableModel;
    private final GenericTable m_wrapperTable;
    private final ComponentFactory m_tableComponentFactory = new ComponentFactoryImpl(null, this.getComponentFactory());
    private ReorderableTableWithTitleBar m_reorderTable;
    private AbstractButton m_btnAddColumn;
    private AbstractButton m_btnRemoveColumn;
    private SearchField m_searchField;
    private TableToolbar m_toolBar;
    private boolean m_showSearch;
    private boolean m_searchInitiated;
    private DBObjectListener m_childListener;
    private Boolean m_canChangeProperty;
    private PropertyChangeListener m_pcl;
    private NavigableSet<Integer> m_deleting;

    public ChildTableEditorPanel(String string) {
        super(string);
        this.m_wrapperTable = new ComponentWrapperTable();
        this.m_childListener = this.createChildObjectListener();
        this.m_pcl = propertyChangeEvent -> this.processChildPanelFocusUpdate(propertyChangeEvent);
    }

    @Override
    protected void initialisePanel() {
        int n;
        Object object;
        this.stopCellEditing(true);
        Object c = null;
        int n2 = this.m_wrapperTableModel.getCurrentRowIndx();
        if (n2 >= 0 && n2 < this.m_wrapperTableModel.getRowCount() && (object = this.m_wrapperTableModel.getRow(n2)) != null) {
            c = ((RowInfo)object).getRowObject();
        }
        this.getWrapperTableModel().resetColumns();
        object = this.getChildList();
        if (object != null) {
            for (n = 0; n < object.size(); ++n) {
                this.addRow(n, (ChildDBObject)object.get(n));
            }
        }
        if (this.m_searchInitiated) {
            this.getWrapperTableModel().filterRows(this.m_searchField.getText());
        }
        this.setCurrentChild(null);
        n = this.m_wrapperTableModel.getRowCount();
        if (n > 0) {
            C c2 = this.getInitialChild(c);
            int n3 = this.m_wrapperTableModel.getRowIndex(c2);
            this.m_wrapperTable.changeSelection(n3, n3, false, false);
            this.selectChild(c2);
        } else {
            this.selectChild(null);
        }
        this.m_canChangeProperty = null;
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (!this.stopCellEditing() || !this.exitChildPanel()) {
            throw new TraversalException(null);
        }
    }

    @Override
    public Component getDefaultFocusComponent() {
        Object object = this.m_wrapperTable.getRowCount() == 0 && this.m_btnAddColumn != null ? this.m_btnAddColumn : this.m_wrapperTable;
        return object;
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        String string;
        int n;
        boolean bl = false;
        if (this.isInitialSelectionProcessed() && (n = this.m_wrapperTableModel.m_columnProps.indexOf(string = this.getEditorConfig().getProperty())) >= 0) {
            bl = true;
            int n2 = this.m_wrapperTable.getSelectedRowInModel();
            if (n2 >= 0 && this.m_wrapperTable.editCellAt(n2, n)) {
                this.m_wrapperTable.getEditorComponent().requestFocusInWindow();
            }
        }
        if (!bl) {
            bl = super.requestFocusForEditorConfig();
        }
        return bl;
    }

    protected boolean stopCellEditingWhenChildPanelFocused() {
        return false;
    }

    protected boolean useSplitter() {
        return false;
    }

    protected JComponent createSplitPane(Component component, Component component2) {
        JSplitPane jSplitPane = new JSplitPane(this.isHorizontalSplit() ? 1 : 0, component, component2);
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return jSplitPane;
    }

    protected DBObjectListener createChildObjectListener() {
        return null;
    }

    private void setChildDBObjectListener(C c, C c2) {
        if (this.m_childListener != null) {
            if (c != null) {
                c.removeObjectListener(this.m_childListener);
            }
            if (c2 != null) {
                c2.addObjectListener(this.m_childListener);
            }
        }
    }

    protected final boolean isSearchInProgress() {
        return this.m_searchInitiated;
    }

    protected NewChildInsertPolicy getNewChildInsertPolicy() {
        return NewChildInsertPolicy.AFTER_SELECTED_ROW;
    }

    public boolean canMoveRowDown() {
        return this.canChangeProperty();
    }

    public boolean canMoveRowToTop() {
        return this.canChangeProperty();
    }

    public boolean canMoveRowToBottom() {
        return this.canChangeProperty();
    }

    public boolean canMoveRowUp() {
        return this.canChangeProperty();
    }

    public boolean canAddRow() {
        return this.canChangeProperty();
    }

    public boolean canRemoveRow(int n) {
        return this.canChangeProperty() && this.m_wrapperTable.getSelectedRowCount() > 0;
    }

    protected boolean confirmRowCanBeDeleted(int n) {
        RowInfo rowInfo = this.getWrapperTableModel().getRow(n);
        Object c = rowInfo.getRowObject();
        return this.confirmCascadeDelete(c);
    }

    @Override
    protected void cascadeChildDelete(DBObject dBObject, DBObject dBObject2, Collection<DBObject> collection) throws DBException {
        super.cascadeChildDelete(dBObject, dBObject2, collection);
        if (this.m_deleting != null) {
            Class clazz = this.getChildClass();
            for (DBObject dBObject3 : collection) {
                int n;
                ChildDBObject childDBObject = (ChildDBObject)DBUtil.findParentOfType((DBObject)dBObject3, clazz);
                if (childDBObject == null || (n = this.getWrapperTableModel().getRowIndex(childDBObject)) < 0) continue;
                this.m_deleting.add(n);
            }
        }
    }

    @Override
    protected void initialiseComponents() {
        this.configureTable();
        this.initialiseTableColumns(false);
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_wrapperTable);
        if (this.isInFlatEditor()) {
            jScrollPane = new ResizeComponent((JComponent)jScrollPane);
            jScrollPane.setPreferredSize(new Dimension(250, 190));
        }
        this.m_reorderTable = new ReorderableTableWithTitleBar((JTable)this.m_wrapperTable, (JComponent)jScrollPane, this.preserveListOrder(), true);
        this.m_toolBar = new TableToolbar((JTable)this.m_wrapperTable, null);
        this.m_reorderTable.setTableToolbar(this.m_toolBar);
        this.m_reorderTable.setReorderableTable(new ReorderableTable((JTable)this.m_wrapperTable){

            public boolean isSelectionDownwardlyMobile() {
                return super.isSelectionDownwardlyMobile() && ChildTableEditorPanel.this.canMoveRowDown();
            }

            public boolean isSelectionTopMobile() {
                return super.isSelectionTopMobile() && ChildTableEditorPanel.this.canMoveRowToTop();
            }

            public boolean isSelectionUpwardlyMobile() {
                return super.isSelectionUpwardlyMobile() && ChildTableEditorPanel.this.canMoveRowUp();
            }

            public boolean isSelectionBottomMobile() {
                return super.isSelectionBottomMobile() && ChildTableEditorPanel.this.canMoveRowToBottom();
            }
        });
        this.configureToolBar(this.m_toolBar);
        ComponentWrapper<GenericTable> componentWrapper = new ComponentWrapper<GenericTable>(this.m_wrapperTable){

            @Override
            public Object getPropertyValue() {
                return null;
            }

            @Override
            public void setPropertyValue(Object object) {
            }

            @Override
            protected void initialiseComponentListener() {
            }

            @Override
            protected Component getDefaultValidationComponent() {
                return ChildTableEditorPanel.this.m_toolBar;
            }
        };
        componentWrapper.initialise(this.createComponentContext(this.getChildProperty()));
        this.getComponentFactory().registerComponentWrapper(componentWrapper);
        DBUIResourceHelper dBUIResourceHelper = this.getComponentFactory().getResourceHelper();
        dBUIResourceHelper.setName((Component)this.m_wrapperTable, "ColumnTable");
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        ChildObjectEditorPanel childObjectEditorPanel = this.getChildPanel();
        if (!this.isInFlatEditor() && this.useSplitter()) {
            JComponent jComponent = this.createSplitPane((Component)this.m_reorderTable, (Component)((Object)this.getChildPanel()));
            dBUIResourceHelper.setName(jComponent, "SplitPane");
            dBUILayoutHelper.add(jComponent);
        } else {
            boolean bl = childObjectEditorPanel == null || !this.isInFlatEditor();
            boolean bl2 = this.isHorizontalSplit();
            dBUILayoutHelper.add((Component)this.m_reorderTable, 1, 1, true, bl);
            if (childObjectEditorPanel != null) {
                Component component = dBUILayoutHelper.wrapForInvisibility(childObjectEditorPanel.getComponent());
                if (bl2) {
                    dBUILayoutHelper.add(component, 1, 1, true, true);
                    dBUILayoutHelper.nextRow();
                } else {
                    dBUILayoutHelper.nextRow();
                    dBUILayoutHelper.add(component, 1, 1, true, true);
                }
            }
        }
        dBUILayoutHelper.layout();
    }

    @Override
    protected ChildObjectEditorPanel<C, P> createChildPanel() {
        return null;
    }

    @Override
    protected final void selectChild(C c) {
        if (this.stopCellEditing()) {
            Object c2 = this.getCurrentChild();
            if (c2 != c) {
                if (c2 == null || this.exitChildPanel()) {
                    this.enterChildPanel(c);
                } else {
                    c = c2;
                }
            } else {
                ChildObjectEditorPanel childObjectEditorPanel = this.getChildPanel();
                if (childObjectEditorPanel != null && !childObjectEditorPanel.isEntered()) {
                    this.enterChildPanel(c);
                }
            }
            this.setChildDBObjectListener(c2, c);
            this.setCurrentChild(c);
            this.enableButtons();
            int n = this.m_wrapperTableModel.getRowIndex(c);
            this.m_wrapperTableModel.setCurrentRowIndx(n);
            this.m_wrapperTable.getSelectionModel().setSelectionInterval(n, n);
            Rectangle rectangle = this.m_wrapperTable.getCellRect(n >= 0 ? n - 1 : -1, 0, true);
            this.m_wrapperTable.scrollRectToVisible(rectangle);
        }
    }

    protected void enableButtons() {
        boolean bl = this.isEnabled();
        this.m_btnAddColumn.setEnabled(bl && this.canAddRow());
        boolean bl2 = false;
        if (bl && this.m_wrapperTable.getSelectedRowCount() > 0) {
            bl2 = true;
            for (int n : this.m_wrapperTable.getSelectedRowsInModel()) {
                if (this.canRemoveRow(n)) continue;
                bl2 = false;
                break;
            }
        }
        this.m_btnRemoveColumn.setEnabled(bl2);
    }

    @Override
    protected C[] getChildren() {
        ChildDBObject[] childDBObjectArray = (ChildDBObject[])Array.newInstance(this.getChildClass(), this.m_wrapperTableModel.getRowCount());
        for (int i = 0; i < childDBObjectArray.length; ++i) {
            childDBObjectArray[i] = this.m_wrapperTableModel.getRow(i).getRowObject();
        }
        return childDBObjectArray;
    }

    protected abstract String[] getPropertiesForRow();

    protected final void addDefaultChildRow() {
        if (this.exitChildPanel()) {
            Object c = this.newChild();
            this.addChildRow(new ChildDBObject[]{c});
        }
    }

    protected final void addChildRow(C ... CArray) {
        if (this.stopCellEditing()) {
            int n = -1;
            if (this.m_wrapperTableModel.getRowCount() > 0) {
                int[] nArray = this.m_wrapperTable.getSelectedRows();
                n = this.getNewChildInsertPolicy() == NewChildInsertPolicy.AT_END || this.isSearchInProgress() || nArray.length == 0 ? this.m_wrapperTableModel.getRowCount() - 1 : nArray[nArray.length - 1];
            }
            int n2 = n;
            for (C c : CArray) {
                this.m_wrapperTableModel.addRow(++n2, c, false);
            }
            this.m_wrapperTable.setRowSelectionInterval(n + 1, n2);
            this.m_wrapperTable.requestFocusInWindow();
            this.commitChildProperty();
        }
    }

    protected void initialiseTableComponents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectedRows() {
        int[] nArray = this.m_wrapperTable.getSelectedRows();
        if (nArray.length > 0) {
            Arrays.sort(nArray);
            try {
                this.m_deleting = new TreeSet<Integer>();
                TableCellEditor tableCellEditor = this.m_wrapperTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.cancelCellEditing();
                }
                this.setCurrentChild(null);
                this.m_wrapperTable.clearSelection();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    if (nArray[i] < 0 || !this.confirmRowCanBeDeleted(nArray[i])) continue;
                    this.m_deleting.add(nArray[i]);
                }
                Iterator<Integer> iterator = this.m_deleting.descendingIterator();
                while (iterator.hasNext()) {
                    Integer n = iterator.next();
                    this.m_wrapperTableModel.deleteRow(n);
                }
                int n = this.m_wrapperTableModel.getRowCount();
                if (n == 0) {
                    this.enterChildPanel(null);
                    this.m_btnAddColumn.requestFocusInWindow();
                } else {
                    int n2 = nArray[nArray.length - 1];
                    if (n2 >= n) {
                        n2 = n - 1;
                    }
                    this.m_wrapperTable.getSelectionModel().setSelectionInterval(n2, n2);
                    this.m_wrapperTable.requestFocusInWindow();
                }
            }
            finally {
                this.m_deleting = null;
            }
        }
    }

    public void addRow(int n, C c) {
        this.m_wrapperTableModel.addRow(n, c, true);
    }

    public final void addColumn(int n, String string, Class clazz, NonPropertyColumnLogic<C> nonPropertyColumnLogic) {
        this.addColumn(n, string, clazz, nonPropertyColumnLogic, null);
    }

    public final void addColumn(int n, String string, Class clazz, NonPropertyColumnLogic<C> nonPropertyColumnLogic, TableCellRenderer tableCellRenderer) {
        this.m_wrapperTableModel.addColumn(string, n, clazz, nonPropertyColumnLogic, tableCellRenderer);
    }

    protected void initialiseTableColumns(boolean bl) {
        this.m_wrapperTableModel = new ComponentWrapperTableModel();
        this.m_wrapperTable.setModel((TableModel)this.m_wrapperTableModel);
        if (bl) {
            TableColumnModel tableColumnModel = this.m_wrapperTable.getColumnModel();
            while (tableColumnModel.getColumnCount() > 0) {
                TableColumn tableColumn = tableColumnModel.getColumn(tableColumnModel.getColumnCount() - 1);
                this.m_wrapperTable.removeColumn(tableColumn);
            }
        }
        this.initialiseTableHeaders();
        this.initialiseTableComponents();
        this.initialiseCellEditors();
    }

    private void initialiseTableHeaders() {
        this.m_tableComponentFactory.setBasePath(this.getChildProperty());
        this.m_tableComponentFactory.setDataContext(this.getDataContext());
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        String[] stringArray = this.getPropertiesForRow();
        PropertyManager propertyManager = this.getProvider().getPropertyManager();
        for (String string : stringArray) {
            PropertyInfo propertyInfo;
            String string2 = Property.createPath((String[])new String[]{this.getComponentFactory().getBasePath(), this.getChildProperty(), string});
            if (!propertyManager.canCreateProperty(this.getEditorConfig().getUpdatedObject(), string2) || (propertyInfo = propertyManager.findPropertyInfo(this.getChildClass(), string)) == null) continue;
            if (string.equals("name")) {
                this.m_showSearch = true;
            }
            arrayList.add(propertyInfo);
        }
        this.m_wrapperTableModel.initialiseColumnHeaders(arrayList);
    }

    private void configureToolBar(TableToolbar tableToolbar) {
        DBUIResourceHelper dBUIResourceHelper = this.getComponentFactory().getResourceHelper();
        this.m_btnAddColumn = this.createAddButton();
        dBUIResourceHelper.setName(this.m_btnAddColumn, "Add");
        this.m_btnRemoveColumn = this.createRemoveButton();
        dBUIResourceHelper.setName(this.m_btnRemoveColumn, "Remove");
        this.setLayout(new BorderLayout(10, 0));
        JLabel jLabel = new JLabel();
        dBUIResourceHelper.resLabel(jLabel, (Component)this.m_wrapperTable, UIBundle.get("COLUMN_INFO_LABEL_COLUMNS"), "ColumnTable");
        tableToolbar.setBackground(Color.white);
        tableToolbar.setOpaque(false);
        if (this.m_showSearch) {
            this.addSearchField(tableToolbar);
        }
        tableToolbar.addActionControl((Component)this.m_btnAddColumn);
        tableToolbar.addActionControl((Component)this.m_btnRemoveColumn);
        String string = PropertyDisplayRegistry.getDisplayName(this.getChildProperty()) + ":";
        tableToolbar.setLabel(string);
    }

    private void addSearchField(TableToolbar tableToolbar) {
        this.m_searchField = new SearchField(SearchField.Style.FILTER);
        this.m_searchField.setEnabled(true);
        this.m_searchField.setTypingDelay(SearchField.TypingDelay.FAST);
        this.m_searchField.setAllowEmptySearch(true);
        this.m_searchField.setPrompt(UIBundle.get("TABLE_SEARCH_NAME"));
        Dimension dimension = this.m_searchField.getPreferredSize();
        dimension.width = 100;
        this.m_searchField.setPreferredSize(dimension);
        this.m_searchField.setMaximumSize(dimension);
        this.m_searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                ChildTableEditorPanel.this.stopCellEditing(true);
                String string = searchEvent.getSearchText();
                if (searchEvent.isFromClear()) {
                    string = "";
                    ChildTableEditorPanel.this.m_searchInitiated = false;
                } else {
                    ChildTableEditorPanel.this.m_searchInitiated = true;
                }
                ChildTableEditorPanel.this.m_reorderTable.getReorderableBar().setEnabled(!ChildTableEditorPanel.this.m_searchInitiated);
                ChildTableEditorPanel.this.m_wrapperTableModel.filterRows(string);
                int n = ChildTableEditorPanel.this.m_wrapperTable.getSelectedRowInModel();
                if (n == -1 && ChildTableEditorPanel.this.m_wrapperTableModel.getRowCount() > 0) {
                    ChildTableEditorPanel.this.m_wrapperTable.setRowSelectionInterval(0, 0);
                }
                ChildTableEditorPanel.this.initialiseCellEditors();
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        tableToolbar.addActionControl((Component)this.m_searchField, false);
        tableToolbar.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
    }

    protected AbstractButton createAddButton() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChildTableEditorPanel.this.stopCellEditing()) {
                    if (ChildTableEditorPanel.this.isSearchInProgress()) {
                        ChildTableEditorPanel.this.m_searchField.clear();
                        int n = ChildTableEditorPanel.this.m_wrapperTableModel.getRowCount();
                        ChildTableEditorPanel.this.m_wrapperTable.getSelectionModel().setSelectionInterval(n, n);
                        ChildTableEditorPanel.this.m_wrapperTable.scrollToSelection();
                    }
                    ChildTableEditorPanel.this.addDefaultChildRow();
                }
            }
        };
        String string = DBTypeDisplayRegistry.getSingularDisplayName(this.getChildType());
        abstractAction.putValue("SmallIcon", OracleIcons.getIcon((String)"add.png"));
        abstractAction.putValue("ShortDescription", UIBundle.format("LIST_BUTTONS_ADD_TYPE", string));
        JButton jButton = new JButton();
        jButton.setAction(abstractAction);
        return jButton;
    }

    protected AbstractButton createRemoveButton() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChildTableEditorPanel.this.removeSelectedRows();
            }
        };
        String string = DBTypeDisplayRegistry.getSingularDisplayName(this.getChildType());
        abstractAction.putValue("SmallIcon", OracleIcons.getIcon((String)"delete.png"));
        abstractAction.putValue("ShortDescription", UIBundle.format("LIST_BUTTONS_REMOVE_TYPE", string));
        JButton jButton = new JButton();
        jButton.setAction(abstractAction);
        AsynchronousComponentWrapper.registerCancellingComponent(jButton, (Component)this.m_wrapperTable);
        return jButton;
    }

    protected void addToolBarButton(JButton jButton) {
        this.m_toolBar.addActionControl((Component)jButton);
    }

    private void configureTable() {
        this.m_wrapperTable.setAutoCreateColumnsFromModel(false);
        this.m_wrapperTable.setResizeColumnOnDoubleClick(true);
        this.m_wrapperTable.setColumnSelectionAllowed(false);
        this.m_wrapperTable.setColumnSelectorAvailable(false);
        this.m_wrapperTable.setColumnHeaderSelectionEnabled(false);
        this.m_wrapperTable.setPreferredVisibleRowCount(5);
        this.m_wrapperTable.setRolloverHighlightingEnabled(true);
        this.m_wrapperTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ChildTableEditorPanel.this.isEntered() && !listSelectionEvent.getValueIsAdjusting()) {
                    ChildTableEditorPanel.this.tableSelectionChanged();
                }
            }
        });
        if (!Modifier.isAbstract(this.getChildClass().getModifiers())) {
            this.m_wrapperTable.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if (keyEvent.getKeyCode() == 40 && (n = ChildTableEditorPanel.this.m_wrapperTable.getSelectedRow()) == ChildTableEditorPanel.this.m_wrapperTable.getRowCount() - 1) {
                        ChildTableEditorPanel.this.addDefaultChildRow();
                    }
                }
            });
        }
        this.m_wrapperTable.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, false), "cancelEdit");
        this.m_wrapperTable.getActionMap().put("cancelEdit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChildTableEditorPanel.this.m_wrapperTable.isEditing()) {
                    int n = ChildTableEditorPanel.this.m_wrapperTable.getEditingRow();
                    int n2 = ChildTableEditorPanel.this.m_wrapperTable.getEditingColumn();
                    ChildTableEditorPanel.this.m_wrapperTable.getCellEditor(n, n2).cancelCellEditing();
                }
            }
        });
    }

    private void tableSelectionChanged() {
        int n = this.m_wrapperTable.getSelectedRowCount();
        C c = null;
        int n2 = -1;
        if (n == 1) {
            RowInfo rowInfo;
            n2 = this.m_wrapperTable.getSelectedRowInModel();
            if (n2 > this.m_wrapperTableModel.getRowCount() - 1) {
                n2 = this.m_wrapperTableModel.getRowCount() - 1;
            }
            if ((rowInfo = this.m_wrapperTableModel.getRow(n2)) != null) {
                c = rowInfo.getRowObject();
            }
        }
        this.selectChild(c);
    }

    private void initialiseCellEditors() {
        int n = this.m_wrapperTableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumnModel tableColumnModel = this.m_wrapperTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            Class clazz = this.m_wrapperTableModel.getColumnClass(i);
            if (this.m_wrapperTableModel.isComponentWrapperCell(i)) {
                tableColumn.setCellEditor(new ComponentWrapperCellEditor());
                continue;
            }
            if (clazz.equals(String.class)) {
                tableColumn.setCellEditor(new StringCellEditor());
                continue;
            }
            if (!clazz.equals(Boolean.class)) continue;
            Font font = this.m_wrapperTable.getTableHeader().getFont();
            String string = this.m_wrapperTableModel.getColumnName(i);
            int n2 = SwingUtilities.computeStringWidth(this.getFontMetrics(font), string) + 16;
            if (n2 < 30) {
                n2 = 30;
            }
            tableColumn.setMinWidth(n2);
            tableColumn.setMaxWidth(n2);
        }
    }

    private ComponentWrapper getOrCreateTableComponentWrapper(C c, String string) {
        ComponentWrapper componentWrapper = this.m_tableComponentFactory.findComponentWrapper(string);
        if (componentWrapper == null) {
            componentWrapper = this.m_tableComponentFactory.createWrapper(this.createTableComponentContext(c, string));
            if (this.isEntered()) {
                componentWrapper.setActive(true);
            }
            this.m_tableComponentFactory.registerComponentWrapper(componentWrapper);
            if (string.equals("name")) {
                componentWrapper.addVetoListener(propertyChangeEvent -> this.vetoInvalidNameChange(propertyChangeEvent));
                if (!this.isInFlatEditor()) {
                    componentWrapper.addListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            Object object = propertyChangeEvent.getOldValue();
                            Object object2 = propertyChangeEvent.getNewValue();
                            Object c = ChildTableEditorPanel.this.getCurrentChild();
                            Object t = ChildTableEditorPanel.this.getUpdatedObject();
                            if (c != null && t instanceof SystemObject && ModelUtil.areDifferent((Object)object, (Object)object2) && ModelUtil.areEqual((Object)c.getName(), (Object)object2)) {
                                try {
                                    DBUtil.cascadeInternalRename((SystemObject)((SystemObject)t), c, (String)((String)object), (String)((String)object2), (DBObjectProvider)ChildTableEditorPanel.this.getProvider());
                                }
                                catch (DBException dBException) {
                                    DBExceptionDialog.showErrorDialog((Component)((Object)ChildTableEditorPanel.this), ProviderOperator.getErrorTitle(ChildTableEditorPanel.this.getEditorConfig()), dBException);
                                }
                            }
                        }
                    });
                }
            }
        }
        return componentWrapper;
    }

    private void vetoInvalidNameChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Object object;
        Object object2;
        if (this.isEntered() && ModelUtil.areDifferent((Object)(object2 = propertyChangeEvent.getOldValue()), (Object)(object = propertyChangeEvent.getNewValue()))) {
            String string;
            String string2 = null;
            String string3 = string = object == null ? null : object.toString();
            if (!ModelUtil.hasLength((String)string)) {
                string2 = UIBundle.get("MISSING_NAME_ERROR");
            } else {
                try {
                    DBObject dBObject = this.getParentUpdatedObject();
                    this.getProvider().validateUniqueName(this.getChildType(), dBObject, string);
                }
                catch (NameInUseException nameInUseException) {
                    string2 = nameInUseException.getMessage();
                }
            }
            if (string2 != null) {
                throw new PropertyVetoException(string2, propertyChangeEvent);
            }
        }
    }

    private ComponentContext createTableComponentContext(C c, String string) {
        if (c == null) {
            throw new IllegalStateException("Cannot create a child component context without a child.");
        }
        ChildDBObject childDBObject = null;
        DBObjectID dBObjectID = c.getID();
        if (dBObjectID instanceof TemporaryObjectID) {
            childDBObject = (ChildDBObject)TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)dBObjectID));
        }
        ComponentContext componentContext = this.m_tableComponentFactory.createComponentContext(string, (DBObject)childDBObject, (DBObject)c);
        componentContext.setInTable(true);
        return componentContext;
    }

    public final void setDefaultRenderer(Class clazz, TableCellRenderer tableCellRenderer) {
        this.m_wrapperTable.setDefaultRenderer(clazz, tableCellRenderer);
    }

    public final void setColumnCellRenderer(String string, TableCellRenderer tableCellRenderer) {
        block2: {
            TableColumnModel tableColumnModel = this.m_wrapperTable.getColumnModel();
            try {
                tableColumnModel.getColumn(tableColumnModel.getColumnIndex(string)).setCellRenderer(new ValidationCellRenderer(tableCellRenderer));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String[] stringArray = this.getPropertiesForRow();
                if (stringArray != null && Arrays.asList(stringArray).contains(string)) break block2;
                this.getLogger().warning("No column found for property " + string);
            }
        }
    }

    protected final GenericTable getWrapperTable() {
        return this.m_wrapperTable;
    }

    public final ComponentWrapperTableModel getWrapperTableModel() {
        return this.m_wrapperTableModel;
    }

    protected final boolean stopCellEditing() {
        return this.stopCellEditing(null);
    }

    private boolean stopCellEditing(Boolean bl) {
        TableCellEditor tableCellEditor;
        boolean bl2 = true;
        if (Boolean.TRUE.equals(bl)) {
            this.commitOrCancelCurrentWrapper();
        }
        if ((tableCellEditor = this.m_wrapperTable.getCellEditor()) != null && !(bl2 = tableCellEditor.stopCellEditing()) && bl != null) {
            tableCellEditor.cancelCellEditing();
        }
        return bl2;
    }

    protected List<String> getHeaderPanelProperties() {
        return Collections.emptyList();
    }

    public boolean isTableCellEditable(int n, int n2) {
        return true;
    }

    private boolean canChangeProperty() {
        if (this.m_canChangeProperty == null) {
            Object t = this.getUpdatedObject();
            if (t instanceof SystemObject && this.disableButtonsIfPropertyCannotChange()) {
                SystemObject systemObject = (SystemObject)t;
                SystemObject systemObject2 = (SystemObject)this.getOriginalObject();
                this.m_canChangeProperty = this.getProvider().getPropertyManager().canChangeProperty(systemObject2, systemObject, this.getChildProperty()) != null;
            } else {
                this.m_canChangeProperty = true;
            }
        }
        return this.m_canChangeProperty;
    }

    protected boolean disableButtonsIfPropertyCannotChange() {
        return true;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.m_reorderTable != null) {
            ReorderableBar reorderableBar = this.m_reorderTable.getReorderableBar();
            if (reorderableBar != null) {
                reorderableBar.setEnabled(!this.m_searchInitiated && bl);
            }
            this.enableButtons();
        }
    }

    private void processChildPanelFocusUpdate(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if ("permanentFocusOwner".equals(propertyChangeEvent.getPropertyName()) && (object = propertyChangeEvent.getNewValue()) instanceof Component && SwingUtilities.isDescendingFrom((Component)object, (Component)((Object)this.getChildPanel()))) {
            this.stopCellEditing();
        }
    }

    private void addFocusManagerPropertyChangeListener() {
        if (this.stopCellEditingWhenChildPanelFocused()) {
            this.removeFocusManagerPropertyChangeListener();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.m_pcl);
        }
    }

    private void removeFocusManagerPropertyChangeListener() {
        if (this.stopCellEditingWhenChildPanelFocused()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.m_pcl);
        }
    }

    private void cancelCurrentWrapper() {
        AsynchronousComponentWrapper.cancelCurrentWrapper(this.getDataContext());
    }

    private class ComponentWrapperTable
    extends GenericTable {
        private ComponentWrapperTable() {
        }

        protected void createDefaultRenderers() {
            super.createDefaultRenderers();
            for (Object k : this.defaultRenderersByColumnClass.keySet()) {
                Class clazz = (Class)k;
                this.setDefaultRenderer(clazz, this.getDefaultRenderer(clazz));
            }
            this.setDefaultRenderer(Enum.class, (TableCellRenderer)((Object)new PropertyValueCellRenderer()));
        }

        public void setDefaultRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
            super.setDefaultRenderer(clazz, tableCellRenderer instanceof ValidationCellRenderer ? tableCellRenderer : new ValidationCellRenderer(tableCellRenderer));
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (keyEvent.isAltDown()) {
                return false;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
    }

    public class ComponentWrapperTableModel
    extends DefaultTableModel {
        private final List<RowInfo> m_rowData = new ArrayList<RowInfo>();
        private final List<RowInfo> m_unfilteredRowData = new ArrayList<RowInfo>();
        private final List<String> m_columnProps = new ArrayList<String>();
        private final List<String> m_columnNames = new ArrayList<String>();
        private final List<Class> m_columnTypes = new ArrayList<Class>();
        private final List<ComponentWrapper> m_componentWrappers = new ArrayList<ComponentWrapper>();
        private final List<String> m_rowNames = new ArrayList<String>();
        private final Map<Integer, NonPropertyColumnLogic> m_nonPropColumnLogics = new TreeMap<Integer, NonPropertyColumnLogic>();
        private int m_currentRowIndx = -1;

        @Override
        public int getRowCount() {
            return this.m_rowData != null ? this.m_rowData.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.m_columnNames.get(n);
        }

        public Class getColumnClass(int n) {
            Class<Enum> clazz = this.m_columnTypes.get(n);
            if (this.isComponentWrapperCell(n) && Enum.class.isAssignableFrom(clazz)) {
                clazz = Enum.class;
            }
            return clazz;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            ComponentWrapper componentWrapper;
            if (n >= this.m_rowData.size()) {
                return;
            }
            RowInfo rowInfo = this.m_rowData.get(n);
            if (this.m_currentRowIndx != n) {
                this.setCurrentRowIndx(n);
                rowInfo.refreshRow(this.m_componentWrappers);
            }
            if ((componentWrapper = this.m_componentWrappers.get(n2)) != null && componentWrapper.getPropertyName().equals("name")) {
                this.m_rowNames.set(n, String.valueOf(object));
            } else {
                object2 = this.m_nonPropColumnLogics.get(n2);
                if (object2 != null) {
                    ((NonPropertyColumnLogic)object2).setValueAt(object, n, n2);
                }
            }
            object2 = rowInfo.getRowColumns();
            if (n2 >= object2.size()) {
                return;
            }
            object2.set(n2, object);
            this.fireTableCellUpdated(n, n2);
        }

        public void resetColumns() {
            int n = this.getRowCount();
            for (int i = n - 1; i >= 0; --i) {
                this.deleteRow(i, false);
            }
            this.clearRowsCache();
        }

        private void clearRowsCache() {
            this.m_rowNames.clear();
            this.m_unfilteredRowData.clear();
            this.m_componentWrappers.clear();
        }

        public void setValueForProperty(C c, String string, Object object, int n) {
            String string2 = PropertyDisplayRegistry.getDisplayName(string, ChildTableEditorPanel.this.getProvider(), c);
            int n2 = this.m_columnNames.indexOf(string2);
            this.setValueAt(object, n, n2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n < this.m_rowData.size()) {
                NonPropertyColumnLogic nonPropertyColumnLogic;
                RowInfo rowInfo = this.m_rowData.get(n);
                List<Object> list = rowInfo.getRowColumns();
                if (n2 < list.size()) {
                    object = list.get(n2);
                }
                if ((nonPropertyColumnLogic = this.m_nonPropColumnLogics.get(n2)) != null) {
                    object = nonPropertyColumnLogic.getValueAt(object, n, n2);
                }
            }
            return object;
        }

        @Override
        public void moveRow(int n, int n2, int n3) {
            int n4 = n2 - n;
            for (int i = 0; i <= n4; ++i) {
                this.moveRowImpl(n + i, n3 + i);
            }
            ChildTableEditorPanel.this.commitChildProperty();
        }

        private void moveRowImpl(int n, int n2) {
            RowInfo rowInfo = this.m_rowData.remove(n);
            this.m_rowData.add(n2, rowInfo);
            if (ChildTableEditorPanel.this.m_showSearch) {
                RowInfo rowInfo2 = this.m_unfilteredRowData.remove(n);
                this.m_unfilteredRowData.add(n2, rowInfo2);
                String string = this.m_rowNames.remove(n);
                this.m_rowNames.add(n2, string);
            }
        }

        public RowInfo getRow(int n) {
            if (this.m_rowData.isEmpty()) {
                return null;
            }
            return this.m_rowData.get(n);
        }

        public void initialiseColumnHeaders(List<PropertyInfo> list) {
            if (!this.m_columnNames.isEmpty()) {
                this.m_columnNames.clear();
                this.m_columnTypes.clear();
                this.m_columnProps.clear();
            }
            TableColumnModel tableColumnModel = ChildTableEditorPanel.this.m_wrapperTable.getColumnModel();
            int n = 0;
            for (PropertyInfo propertyInfo : list) {
                Class<Boolean> clazz = propertyInfo.getPropertyClass();
                if (clazz.equals(Boolean.TYPE)) {
                    clazz = Boolean.class;
                }
                String string = propertyInfo.getPropertyName();
                this.m_columnProps.add(string);
                String string2 = PropertyDisplayRegistry.getDisplayName(string);
                this.m_columnTypes.add(clazz);
                this.m_columnNames.add(string2);
                TableColumn tableColumn = new TableColumn(n++);
                tableColumn.setIdentifier(string);
                tableColumn.setHeaderValue(string2);
                tableColumnModel.addColumn(tableColumn);
            }
        }

        public void addRow(int n, C c, boolean bl) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (String object2 : this.m_columnProps) {
                if (object2 == null) continue;
                if (n == 0) {
                    object = ChildTableEditorPanel.this.getOrCreateTableComponentWrapper(c, object2);
                    this.m_componentWrappers.add((ComponentWrapper)object);
                }
                object = ChildTableEditorPanel.this.getPropertyHelper().getPropertyValue(c, object2);
                arrayList.add(object);
            }
            for (Map.Entry entry : this.m_nonPropColumnLogics.entrySet()) {
                object = (Integer)entry.getKey();
                Object object2 = null;
                try {
                    NonPropertyColumnLogic nonPropertyColumnLogic = (NonPropertyColumnLogic)entry.getValue();
                    object2 = nonPropertyColumnLogic.getCellValue(c);
                }
                catch (Exception exception) {
                    ChildTableEditorPanel.this.getLogger().log(Level.SEVERE, "NonPropertyColumnLogic failed", exception);
                }
                if (n == 0) {
                    this.m_componentWrappers.add((Integer)object, null);
                }
                arrayList.add((Integer)object, object2);
            }
            RowInfo rowInfo = new RowInfo(ChildTableEditorPanel.this, c, arrayList);
            if (ChildTableEditorPanel.this.m_showSearch) {
                this.m_rowNames.add(n, c.getName());
                this.m_unfilteredRowData.add(n, rowInfo);
            }
            this.m_rowData.add(n, rowInfo);
            this.fireTableRowsInserted(n, n);
            if (bl) {
                ChildTableEditorPanel.this.m_wrapperTable.changeSelection(n, 0, false, false);
                this.setCurrentRowIndx(n);
            }
        }

        public void deleteRow(int n, boolean bl) {
            RowInfo rowInfo = this.m_rowData.get(n);
            Object c = rowInfo.getRowObject();
            this.m_rowData.remove(n);
            if (bl) {
                if (ChildTableEditorPanel.this.m_showSearch) {
                    int n2 = this.m_rowNames.indexOf(c.getName());
                    this.m_unfilteredRowData.remove(n2);
                    this.m_rowNames.remove(c.getName());
                }
                ChildTableEditorPanel.this.removeFromParent(c);
            }
            if (this.getRowCount() == 1 && ChildTableEditorPanel.this.m_reorderTable != null && ChildTableEditorPanel.this.m_reorderTable.getReorderableBar() != null) {
                ChildTableEditorPanel.this.m_reorderTable.getReorderableBar().setDownEnabled(false);
                ChildTableEditorPanel.this.m_reorderTable.getReorderableBar().setBottomEnabled(false);
            }
            if (this.getRowCount() == 0 && !ChildTableEditorPanel.this.isSearchInProgress()) {
                this.clearRowsCache();
            }
            this.fireTableRowsDeleted(n, n);
        }

        public void deleteRow(int n) {
            this.deleteRow(n, true);
        }

        private boolean isRowMatching(int n, String string) {
            String string2 = this.m_rowNames.get(n).toUpperCase();
            return string2.indexOf(string.toUpperCase()) != -1;
        }

        public void filterRows(String string) {
            this.m_rowData.clear();
            this.m_rowData.addAll(this.m_unfilteredRowData);
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                if (this.isRowMatching(i, string)) continue;
                this.deleteRow(i, false);
            }
            this.fireTableStructureChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            NonPropertyColumnLogic nonPropertyColumnLogic = this.m_nonPropColumnLogics.get(n2);
            boolean bl = nonPropertyColumnLogic == null ? ChildTableEditorPanel.this.isTableCellEditable(n, n2) : nonPropertyColumnLogic.isCellEditable(this.getRow(n).getRowObject());
            return bl;
        }

        public ComponentWrapper getComponentWrapperForColumn(int n, int n2) {
            RowInfo rowInfo = this.getRow(n);
            rowInfo.refreshRow(this.m_componentWrappers);
            this.setCurrentRowIndx(n);
            ComponentWrapper componentWrapper = this.m_componentWrappers.get(n2);
            return componentWrapper;
        }

        public List<String> getRowNames() {
            return this.m_rowNames;
        }

        public void addColumn(String string, int n, Class clazz, NonPropertyColumnLogic nonPropertyColumnLogic, TableCellRenderer tableCellRenderer) {
            Object object;
            this.m_columnProps.add(n, null);
            this.m_columnNames.add(n, string);
            this.m_columnTypes.add(n, clazz);
            this.m_nonPropColumnLogics.put(n, nonPropertyColumnLogic);
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                object = this.m_rowData.get(i);
                ((RowInfo)object).getRowColumns().add(n, nonPropertyColumnLogic.getCellValue(((RowInfo)object).getRowObject()));
            }
            TableColumnModel tableColumnModel = ChildTableEditorPanel.this.m_wrapperTable.getColumnModel();
            object = new TableColumn(n);
            ((TableColumn)object).setIdentifier(string);
            ((TableColumn)object).setHeaderValue(string);
            if (tableCellRenderer == null) {
                tableCellRenderer = ChildTableEditorPanel.this.m_wrapperTable.getDefaultRenderer(clazz);
            }
            ((TableColumn)object).setCellRenderer(new ValidationCellRenderer(tableCellRenderer));
            tableColumnModel.addColumn((TableColumn)object);
            tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, n);
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                tableColumnModel.getColumn(i).setModelIndex(i);
            }
            this.fireTableStructureChanged();
        }

        public C[] getChildren() {
            ChildDBObject[] childDBObjectArray = (ChildDBObject[])Array.newInstance(ChildTableEditorPanel.this.getChildClass(), this.getRowCount());
            for (int i = 0; i < this.getRowCount(); ++i) {
                childDBObjectArray[i] = this.getRow(i).getRowObject();
            }
            return childDBObjectArray;
        }

        private boolean isComponentWrapperCell(int n) {
            return !this.m_nonPropColumnLogics.containsKey(n);
        }

        public int getCurrentRowIndx() {
            return this.m_currentRowIndx;
        }

        public void setCurrentRowIndx(int n) {
            this.m_currentRowIndx = n;
        }

        public int getRowIndex(C c) {
            int n = -1;
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                RowInfo rowInfo = this.m_rowData.get(i);
                if (rowInfo.getRowObject() != c) continue;
                n = i;
                break;
            }
            return n;
        }
    }

    public static class RowInfo {
        private C m_rowObject;
        private List<Object> m_data;
        final /* synthetic */ ChildTableEditorPanel this$0;

        public RowInfo(C c, List<Object> list) {
            this.this$0 = var1_1;
            this.m_rowObject = c;
            this.m_data = list;
        }

        public void refreshRow(List<ComponentWrapper> list) {
            for (ComponentWrapper componentWrapper : list) {
                if (componentWrapper == null) continue;
                componentWrapper.refreshObject((DBObject)this.m_rowObject);
            }
        }

        public List<Object> getRowColumns() {
            return this.m_data;
        }

        public C getRowObject() {
            return this.m_rowObject;
        }
    }

    public static enum NewChildInsertPolicy {
        AFTER_SELECTED_ROW,
        AT_END;

    }

    public abstract class NonPropertyColumnLogic<C> {
        public abstract Object getCellValue(C var1);

        public void setValueAt(Object object, int n, int n2) {
        }

        public Object getValueAt(Object object, int n, int n2) {
            RowInfo rowInfo = ChildTableEditorPanel.this.getWrapperTableModel().getRow(n);
            Object c = rowInfo.getRowObject();
            return this.getCellValue(c);
        }

        public boolean isCellEditable(C c) {
            return false;
        }

        public String getPropertyPath(C c) {
            return null;
        }
    }

    private class ComponentWrapperCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComponentWrapper m_componentWrapper = null;
        private Object m_startingValue = null;

        private ComponentWrapperCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_componentWrapper.getPropertyValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = null;
            n2 = jTable.convertColumnIndexToModel(n2);
            ChildTableEditorPanel.this.addFocusManagerPropertyChangeListener();
            this.m_componentWrapper = ChildTableEditorPanel.this.m_wrapperTableModel.getComponentWrapperForColumn(n, n2);
            this.m_startingValue = this.m_componentWrapper.getPropertyValue();
            if (this.m_componentWrapper != null) {
                component = this.m_componentWrapper.getCellEditorComponent();
            }
            if (component instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)component;
                jCheckBox.setHorizontalAlignment(0);
                jCheckBox.setText(null);
                jCheckBox.setOpaque(false);
            }
            return component;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                return mouseEvent.getID() != 506;
            }
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            ChildTableEditorPanel.this.removeFocusManagerPropertyChangeListener();
            return ChildTableEditorPanel.this.commitCurrentWrapper() && super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (this.m_componentWrapper instanceof AsynchronousComponentWrapper) {
                ChildTableEditorPanel.this.cancelCurrentWrapper();
                super.cancelCellEditing();
            }
            ChildTableEditorPanel.this.removeFocusManagerPropertyChangeListener();
        }
    }

    private class StringCellEditor
    extends DefaultCellEditor {
        StringCellEditor() {
            super(new JTextField());
            ChildTableEditorPanel.this.getComponentFactory().getResourceHelper().setName(this.getComponent(), "StringCellEditor");
            this.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ChildTableEditorPanel.this.addFocusManagerPropertyChangeListener();
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public boolean stopCellEditing() {
            ChildTableEditorPanel.this.removeFocusManagerPropertyChangeListener();
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            ChildTableEditorPanel.this.removeFocusManagerPropertyChangeListener();
            super.cancelCellEditing();
        }
    }

    private class ValidationCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer m_delegate;

        ValidationCellRenderer(TableCellRenderer tableCellRenderer) {
            this.m_delegate = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.m_delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            DBValidationManager dBValidationManager = (DBValidationManager)ChildTableEditorPanel.this.getDataContext().find(DBValidationManager.class);
            if (dBValidationManager != null) {
                int n3 = jTable.convertColumnIndexToModel(n2);
                RowInfo rowInfo = ChildTableEditorPanel.this.m_wrapperTableModel.getRow(n);
                if (rowInfo != null) {
                    Object c = rowInfo.getRowObject();
                    String string = null;
                    ComponentWrapper componentWrapper = ChildTableEditorPanel.this.m_wrapperTableModel.m_componentWrappers.get(n3);
                    if (componentWrapper != null) {
                        string = componentWrapper.getPropertyName();
                    } else {
                        NonPropertyColumnLogic nonPropertyColumnLogic = ChildTableEditorPanel.this.m_wrapperTableModel.m_nonPropColumnLogics.get(n3);
                        if (nonPropertyColumnLogic != null) {
                            string = nonPropertyColumnLogic.getPropertyPath(c);
                        }
                    }
                    if (string != null) {
                        component = dBValidationManager.processRendererComponent(component, (DBObject)c, string);
                    }
                }
            }
            return component;
        }
    }

    protected class PropertyValueCellRenderer
    extends GenericTableCellRenderer {
        protected PropertyValueCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ComponentWrapper componentWrapper = ChildTableEditorPanel.this.m_wrapperTableModel.m_componentWrappers.get(n2 = jTable.convertColumnIndexToModel(n2));
            if (componentWrapper != null) {
                String string = componentWrapper.getPropertyName();
                object = PropertyDisplayListCellRenderer.normalizeValue(string, object);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

