/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Version;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PropertyAccess;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.components.ComponentFactoryImpl;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public abstract class BaseEditorPanel<T extends DBObject>
extends DefaultTraversablePanel
implements DBTraversable {
    private Namespace m_context;
    private final ComponentFactoryImpl m_componentFactory;
    private DBValidationHandler m_validationHandler;
    private DBUILayoutHelper m_layout;
    private boolean m_entered;
    private boolean m_initialized;
    private DBObjectListener m_objListener;
    private DBObjectListener m_factoryObjListener;
    private DBEditorConfig m_lastConfig;

    protected BaseEditorPanel() {
        this(null);
    }

    protected BaseEditorPanel(String string) {
        if (string == null) {
            string = this.getClass().getSimpleName();
        }
        this.m_componentFactory = new DBUIHelper(string, (Component)((Object)this));
        this.setName(string);
    }

    protected Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    protected final Namespace getDataContext() {
        if (this.m_context == null) {
            throw new IllegalStateException("Cannot call getDataContext() until the panel has been entered");
        }
        return this.m_context;
    }

    protected final DBObjectProvider getProvider() {
        return this.getEditorConfig().getProvider();
    }

    @Deprecated
    protected final DBUIHelper getHelper() {
        return (DBUIHelper)this.m_componentFactory;
    }

    @Deprecated
    protected DBObject getHelperOriginalObject() {
        return this.getOriginalObject();
    }

    @Deprecated
    protected DBObject getHelperObject() {
        return this.getUpdatedObject();
    }

    public final ComponentFactory getComponentFactory() {
        return this.m_componentFactory;
    }

    public final ComponentWrapper getOrCreateWrapper(String string) {
        return this.getOrCreateWrapperImpl(string, false);
    }

    public final ComponentWrapper getOrCreateButtonWrapper(String string) {
        return this.getOrCreateWrapperImpl(string, true);
    }

    private ComponentWrapper getOrCreateWrapperImpl(String string, boolean bl) {
        string = this.getComponentPath(string);
        ComponentWrapper componentWrapper = this.getComponentFactory().findComponentWrapper(string);
        if (componentWrapper == null) {
            ComponentContext componentContext = this.createComponentContext(string);
            componentContext.setButtonContext(bl);
            componentWrapper = this.getComponentFactory().createWrapper(componentContext);
            this.getComponentFactory().registerComponentWrapper(componentWrapper);
        }
        return componentWrapper;
    }

    protected String getComponentPath(String string) {
        return string;
    }

    protected final PropertyHelper getPropertyHelper() {
        return BaseEditorPanel.getPropertyHelper(this.getDataContext(), this.getProvider());
    }

    protected final boolean isEditing() {
        return this.getOriginalObject() != null;
    }

    protected final boolean isEntered() {
        return this.m_entered;
    }

    protected final boolean isInitialized() {
        return this.m_initialized;
    }

    protected final T getOriginalObject() {
        return (T)this.getEditorConfig().getOriginalObject();
    }

    protected final T getUpdatedObject() {
        return (T)this.getEditorConfig().getUpdatedObject();
    }

    @Deprecated
    protected final T getDBObject() {
        return this.getUpdatedObject();
    }

    protected final Schema[] getSchemaList() {
        return this.getEditorConfig().getSchemaList();
    }

    public final void onEntry(TraversableContext traversableContext) {
        this.onEntry((Namespace)traversableContext);
    }

    protected DBObject getComponentFactoryUpdatedObject() {
        return this.getHelperObject();
    }

    protected DBObject getComponentFactoryOriginalObject() {
        return this.getHelperOriginalObject();
    }

    private void setEntered(boolean bl) {
        PropertyAccess propertyAccess;
        this.m_entered = bl;
        this.getComponentFactory().setActive(bl);
        this.setPanelInContext(bl, BaseEditorPanel.class.getName());
        String string = this.getCustomPanelKey();
        if (string != null) {
            this.setPanelInContext(bl, string);
        }
        Namespace namespace = this.getDataContext();
        if (bl && namespace.find(BaseEditorPanel.class) == this && (propertyAccess = (PropertyAccess)namespace.find(PropertyAccess.class)) != null) {
            this.loadSettings(propertyAccess);
            namespace.remove(PropertyAccess.class.getName());
        }
        if (this.m_initialized) {
            this.registerListener((DBObject)this.getUpdatedObject(), this.m_objListener, bl);
            this.registerListener(this.getComponentFactoryUpdatedObject(), this.m_factoryObjListener, bl);
        }
        if (bl) {
            this.startValidationHandler();
        } else {
            this.stopValidationHandler();
        }
    }

    private void registerListener(DBObject dBObject, DBObjectListener dBObjectListener, boolean bl) {
        if (dBObjectListener != null && dBObject != null) {
            if (bl) {
                dBObject.addObjectListener(dBObjectListener);
            } else {
                dBObject.removeObjectListener(dBObjectListener);
            }
        }
    }

    protected final DBValidationHandler getValidationHandler() {
        DBValidationManager dBValidationManager;
        if (this.m_validationHandler == null && (dBValidationManager = (DBValidationManager)this.getDataContext().find(DBValidationManager.class)) != null) {
            this.m_validationHandler = dBValidationManager.createHandler(this.getEditorConfig(), this.getComponentFactory());
        }
        return this.m_validationHandler;
    }

    private void startValidationHandler() {
        DBValidationHandler dBValidationHandler = this.getValidationHandler();
        if (dBValidationHandler != null) {
            dBValidationHandler.startValidation(this.getComponentFactoryOriginalObject(), this.getComponentFactoryUpdatedObject());
        }
    }

    private void stopValidationHandler() {
        DBValidationHandler dBValidationHandler = this.getValidationHandler();
        if (dBValidationHandler != null) {
            dBValidationHandler.stopValidation();
        }
    }

    protected String getCustomPanelKey() {
        return null;
    }

    private void setPanelInContext(boolean bl, String string) {
        if (bl) {
            if (this.m_context.get(string) == null) {
                this.m_context.put(string, (Object)this);
            }
        } else if (this.m_context.get(string) == this) {
            this.m_context.remove(string);
        }
    }

    final void onEntry(Namespace namespace) {
        this.m_context = namespace;
        this.setEntered(false);
        try {
            this.m_componentFactory.setDataContext(this.m_context);
            this.m_componentFactory.setEditable(this.isEditable());
            if (!this.m_initialized) {
                this.m_initialized = true;
                this.initialiseComponents();
                this.m_objListener = this.createObjectListener();
                this.m_factoryObjListener = this.createComponentFactoryObjectListener();
                this.m_componentFactory.setUpdatedObject(this.getComponentFactoryUpdatedObject());
                this.m_componentFactory.processComponents();
            } else if (this.getUpdatedObject() != null) {
                this.refreshComponents();
            }
            this.initialisePanel();
            DBUIMnemonicBuilder dBUIMnemonicBuilder = new DBUIMnemonicBuilder((JPanel)((Object)this.getMnemonicBuilderPanel()), (JPanel)((Object)this));
            if (this.isInFlatEditor()) {
                dBUIMnemonicBuilder.removeAll();
            } else {
                dBUIMnemonicBuilder.build();
            }
            this.setEntered(true);
        }
        catch (Exception exception) {
            this.getLogger().log(Level.SEVERE, "Error entering panel", exception);
        }
    }

    protected void refreshComponents() {
        this.m_componentFactory.refreshComponents(this.getComponentFactoryUpdatedObject());
    }

    protected DBEditorConfig getEditorConfig() {
        return (DBEditorConfig)this.getDataContext().find(DBEditorConfig.class);
    }

    protected boolean isEditable() {
        return this.getEditorConfig().isEditable();
    }

    protected final void processComponent(String string) {
        this.m_componentFactory.processComponent(string);
    }

    @Deprecated
    protected final void processComponent(Component component) {
    }

    protected void initialiseComponents() {
    }

    protected abstract void initialisePanel();

    protected DBObjectListener createObjectListener() {
        return null;
    }

    protected DBObjectListener createComponentFactoryObjectListener() {
        return null;
    }

    public final void onExit(TraversableContext traversableContext) throws TraversalException {
        this.onExit((Namespace)traversableContext);
    }

    final void onExit(Namespace namespace) throws TraversalException {
        this.onExit(namespace, this.shouldValidateOnExit());
    }

    final void onExit(Namespace namespace, boolean bl) throws TraversalException {
        this.m_context = namespace;
        if (!this.commitCurrentWrapperImpl(false, true)) {
            throw new TraversalException(null);
        }
        try {
            this.setEntered(false);
            this.commitPanel();
            if (bl) {
                this.validateObject();
                this.canCommit();
            }
        }
        catch (TraversalException traversalException) {
            this.setEntered(true);
            throw traversalException;
        }
    }

    protected void canCommit() throws TraversalException {
        this.m_componentFactory.canCommit(this.getEditorConfig());
    }

    protected boolean shouldValidateOnExit() {
        boolean bl = true;
        Namespace namespace = this.getDataContext();
        PanelLibrary panelLibrary = (PanelLibrary)namespace.find(PanelLibrary.class);
        if (panelLibrary != null) {
            bl = panelLibrary.shouldValidateOnExit(this, namespace);
        }
        return bl;
    }

    protected void commitPanel() throws TraversalException {
    }

    protected void validateObject() throws TraversalException {
        try {
            this.doValidation(this.getComponentFactoryOriginalObject(), this.getComponentFactoryUpdatedObject());
        }
        catch (ValidationException validationException) {
            this.processValidationException(validationException);
        }
    }

    protected final ValidationLevel getValidationLevel() {
        DBEditorConfig dBEditorConfig;
        ValidationLevel validationLevel = null;
        PanelLibrary panelLibrary = (PanelLibrary)this.getDataContext().find(PanelLibrary.class);
        if (panelLibrary != null && (dBEditorConfig = this.getEditorConfig()) != null) {
            validationLevel = panelLibrary.getValidationLevel(dBEditorConfig);
        }
        return validationLevel == null ? ValidationLevel.SIMPLE : validationLevel;
    }

    protected final void doValidation(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        block3: {
            DBObjectProvider dBObjectProvider = this.getProvider();
            if (dBObject2 != null && dBObjectProvider instanceof AbstractDBObjectProvider) {
                try {
                    Collection<String> collection = this.getValidationPaths();
                    ((AbstractDBObjectProvider)dBObjectProvider).validate(new ValidationContext(dBObject, dBObject2, this.getValidationLevel(), collection == null ? (String[])null : collection.toArray(new String[collection.size()])));
                }
                catch (MissingValidatorException missingValidatorException) {
                    if (Version.DEBUG_BUILD == 0) break block3;
                    this.getLogger().log(Level.WARNING, missingValidatorException.getMessage());
                }
            }
        }
    }

    protected void processValidationException(ValidationException validationException) throws TraversalException {
        String string = validationException.getTitle();
        throw new TraversalException(validationException.getMessage(), string == null ? this.getErrorTitle() : string);
    }

    protected final String getInternalName(String string) throws TraversalException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        T t = this.getUpdatedObject();
        String string2 = t.getType();
        try {
            dBObjectProvider.validateName(string2, string);
        }
        catch (InvalidNameException invalidNameException) {
            String string3 = invalidNameException.getMessage();
            throw new TraversalException(this.getInvalidNameMessage(string, string2) + " " + string3, this.getErrorTitle());
        }
        return dBObjectProvider.getInternalName(string);
    }

    protected String getErrorTitle() {
        T t = this.getUpdatedObject();
        String string = DBTypeDisplayRegistry.getSingularDisplayName(t.getType());
        return UIBundle.format("BASE_ERROR_TITLE", string, t.getName());
    }

    protected String getInvalidNameMessage(String string, String string2) {
        String string3 = DBTypeDisplayRegistry.getSingularDisplayName(string2);
        if (ModelUtil.hasLength((String)string)) {
            return UIBundle.format("INVALID_NAME_MESSAGE", string, string3);
        }
        return UIBundle.format("EMPTY_NAME_MESSAGE", string3);
    }

    protected final String getExternalName(String string) {
        return this.getProvider().getExternalName(string);
    }

    protected final String getExternalName(String string, String string2) {
        return this.getProvider().getExternalName(string, string2);
    }

    protected final String getUniqueName(String string, ListModel listModel) {
        int n = listModel.getSize();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            Object e = listModel.getElementAt(i);
            hashSet.add(e.toString());
        }
        return DBUtil.getUniqueName(hashSet, (String)string);
    }

    protected Collection<String> getValidationPaths() {
        return this.getComponentFactory().getPaths();
    }

    protected ComponentContext createComponentContext(String string) {
        return this.getComponentFactory().createComponentContext(string, this.getComponentFactoryOriginalObject(), this.getComponentFactoryUpdatedObject());
    }

    public final boolean isInFlatEditor() {
        return this.getEditorConfig().isInFlatEditor();
    }

    protected DBUILayoutHelper getDBUILayoutHelper() {
        if (!this.m_initialized) {
            throw new IllegalStateException("Cannot get the layout helper before first call to initialiseComponents.");
        }
        if (this.m_layout == null) {
            this.m_layout = new DBUILayoutHelper((JPanel)((Object)this), this.isInFlatEditor());
        }
        return this.m_layout;
    }

    protected boolean commitCurrentWrapper() {
        return this.commitCurrentWrapperImpl(false, false);
    }

    protected void commitOrCancelCurrentWrapper() {
        this.commitCurrentWrapperImpl(true, false);
    }

    private boolean commitCurrentWrapperImpl(boolean bl, boolean bl2) {
        return AsynchronousComponentWrapper.commitCurrentWrapper(this.getDataContext(), bl, bl2);
    }

    @Override
    public Component getDefaultFocusComponent() {
        Component component = null;
        ComponentWrapper componentWrapper = this.getComponentFactory().findComponentWrapper("name");
        if (componentWrapper != null) {
            component = (Component)componentWrapper.getActiveComponent();
        }
        return component;
    }

    public void saveSettings(PropertyAccess propertyAccess) {
    }

    protected void loadSettings(PropertyAccess propertyAccess) {
    }

    protected final <D extends DBObject> D getInitialSelection(Class<D> clazz) {
        DBObject dBObject = null;
        DBEditorConfig dBEditorConfig = this.getEditorConfig();
        if (!this.isInitialSelectionProcessed() && (dBObject = DBUtil.findParentOfType((DBObject)this.getEditorConfig().getChildObject(), clazz)) != null) {
            this.setInitialSelectionProcessed();
        }
        return (D)dBObject;
    }

    protected void setInitialSelectionProcessed() {
        this.m_lastConfig = this.getEditorConfig();
    }

    protected final boolean isInitialSelectionProcessed() {
        return this.m_lastConfig == this.getEditorConfig();
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        boolean bl = false;
        DBEditorConfig dBEditorConfig = this.getEditorConfig();
        String string = dBEditorConfig.getProperty();
        if (string != null) {
            Object object;
            Object object2;
            DBObject dBObject = dBEditorConfig.getChildObject();
            ComponentFactory componentFactory = this.getComponentFactory();
            String string2 = string;
            if (dBObject != null && (object2 = this.getComponentFactoryUpdatedObject()) != dBObject) {
                object = DBUtil.getPropertyPath((DBObject)object2, (DBObject)dBObject);
                string2 = object == null ? null : Property.createPath((String[])new String[]{object, string});
            }
            if (string2 != null) {
                object2 = componentFactory.findComponentWrapper(string2);
                if (object2 == null) {
                    object = Property.getParentProperty((String)string2);
                    while (object != null) {
                        ComponentWrapper componentWrapper = componentFactory.findComponentWrapper((String)object);
                        if (componentWrapper != null) {
                            Component component = componentWrapper.getComponent();
                            if (component instanceof BaseEditorPanel) {
                                bl = ((BaseEditorPanel)((Object)component)).requestFocusForEditorConfig();
                            }
                            break;
                        }
                        object = Property.getParentProperty((String)object);
                    }
                } else {
                    object = ((ComponentWrapper)object2).getDefaultFocusComponent();
                    if (object != null) {
                        bl = true;
                        ((Component)object).requestFocusInWindow();
                    }
                }
            }
        }
        return bl;
    }

    public final ComponentWrapper<? extends BaseEditorPanel> createPanelWrapper() {
        return new BaseEditorPanelWrapper();
    }

    public final ComponentWrapper<JButton> createButtonWrapper() {
        return new BaseEditorPanelButtonWrapper();
    }

    protected Dimension getDialogInitialSize() {
        return new Dimension(600, 320);
    }

    private BaseEditorPanel getMnemonicBuilderPanel() {
        BaseEditorPanel baseEditorPanel = this;
        for (Object object = baseEditorPanel; object != null; object = ((Component)object).getParent()) {
            if (!(object instanceof BaseEditorPanel)) continue;
            baseEditorPanel = object;
        }
        return baseEditorPanel;
    }

    protected void initialiseWrappedPanel(ComponentContext componentContext) {
    }

    public static PropertyHelper getPropertyHelper(Namespace namespace, DBObjectProvider dBObjectProvider) {
        PropertyHelper propertyHelper = (PropertyHelper)namespace.find(PropertyHelper.class);
        if (propertyHelper == null) {
            propertyHelper = new PropertyHelper(dBObjectProvider);
            namespace.put(PropertyHelper.class.getName(), (Object)propertyHelper);
        }
        return propertyHelper;
    }

    class BaseEditorPanelWrapper<T extends BaseEditorPanel>
    extends ComponentWrapper<T> {
        private boolean m_entered;

        BaseEditorPanelWrapper() {
            super(BaseEditorPanel.this);
        }

        @Override
        protected void initialiseComponent() {
            super.initialiseComponent();
            BaseEditorPanel.this.initialiseWrappedPanel(this.getComponentContext());
        }

        @Override
        public Object getPropertyValue() {
            return this.getExistingPropertyValue();
        }

        @Override
        public void setPropertyValue(Object object) {
            this.enterComponent();
        }

        protected void enterComponent() {
            if (this.m_entered) {
                this.exitComponent();
            }
            this.m_entered = true;
            ((BaseEditorPanel)this.getActiveComponent()).onEntry(this.getTraversableContext());
        }

        protected void exitComponent() {
            if (this.m_entered) {
                this.m_entered = false;
                try {
                    ((BaseEditorPanel)this.getActiveComponent()).onExit((Namespace)this.getTraversableContext(), false);
                }
                catch (TraversalException traversalException) {
                    this.getLogger().severe(traversalException.getMessage());
                }
                catch (Exception exception) {
                    this.getLogger().log(Level.SEVERE, "Error entering panel", exception);
                }
            }
        }

        protected TraversableContext getTraversableContext() {
            return new TraversableContext(this.getComponentContext().getDataContext(), 0);
        }

        @Override
        protected void setActiveImpl(boolean bl) {
            if (!bl) {
                this.exitComponent();
            }
        }

        @Override
        public Component getDefaultFocusComponent() {
            return ((BaseEditorPanel)this.getActiveComponent()).getDefaultFocusComponent();
        }

        @Override
        protected Component getDefaultValidationComponent() {
            return null;
        }

        @Override
        protected void initialiseComponentListener() {
        }

        @Override
        public JLabel getLabel() {
            return null;
        }
    }

    class BaseEditorPanelButtonWrapper
    extends ComponentWrapper<JButton> {
        private String m_title;

        BaseEditorPanelButtonWrapper() {
            super(new JButton());
        }

        @Override
        public Object getPropertyValue() {
            return this.getExistingPropertyValue();
        }

        @Override
        public void setPropertyValue(Object object) {
        }

        @Override
        protected void initialiseComponentListener() {
        }

        @Override
        protected void initialiseComponent() {
            this.m_title = PropertyDisplayRegistry.getDisplayName(this.getPropertyName(), this.getProvider(), this.getUpdatedObject());
            JButton jButton = (JButton)this.getActiveComponent();
            jButton.setText(this.m_title + "...");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BaseEditorPanelButtonWrapper.this.launchDialog();
                }
            });
            BaseEditorPanel.this.initialiseWrappedPanel(this.getComponentContext());
        }

        private void launchDialog() {
            DBEditorConfig dBEditorConfig;
            Namespace namespace = new Namespace(this.getComponentContext().getDataContext());
            DBEditorConfig dBEditorConfig2 = (DBEditorConfig)namespace.find(DBEditorConfig.class.getName());
            BaseEditorPanel.this.getComponentFactory().setBasePath(this.getComponentContext().getBasePath());
            if (dBEditorConfig2 != null) {
                dBEditorConfig = DBEditorConfig.newClonedConfig(dBEditorConfig2);
                BaseDBEditorFactory.setEditorType(dBEditorConfig, DBEditorFactory.EditorType.EDIT_MODAL);
                namespace.put(DBEditorConfig.class.getName(), (Object)dBEditorConfig);
            }
            dBEditorConfig = new TDialogLauncher(this.getActiveComponent(), this.m_title, (Traversable)BaseEditorPanel.this, namespace);
            dBEditorConfig.setInitialSize(BaseEditorPanel.this.getDialogInitialSize());
            JEWTDialog jEWTDialog = dBEditorConfig.initDialog();
            jEWTDialog.setName(this.getPropertyName() + "-Dialog");
            jEWTDialog.setButtonMask(5);
            dBEditorConfig.showDialog();
        }
    }
}

